/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.validation.DependentResource;
import org.eclipse.wst.validation.Friend;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.DisabledResourceManager;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.ResourceUnavailableError;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class ValBuilderJob
extends WorkspaceJob {
    private static ValBuilderJob _job;
    private static Queue<ValidationRequest> _work;
    private final ValOperation _operation = new ValOperation();
    private static final int InterestedFlags = 0x103100;

    static {
        _work = new LinkedList<ValidationRequest>();
    }

    public static synchronized void validateProject(IProject project, IResourceDelta delta, int buildKind) {
        ValidationRequest request = new ValidationRequest(project, delta, buildKind);
        if (_job == null) {
            _job = new ValBuilderJob();
            _job.add(request);
            _job.schedule();
        } else {
            _job.add(request);
        }
    }

    private static synchronized ValidationRequest getRequest() {
        ValidationRequest request = _work.poll();
        if (request == null) {
            _job = null;
        }
        return request;
    }

    private ValBuilderJob() {
        super(ValMessages.JobName);
    }

    private void add(ValidationRequest request) {
        _work.add(request);
    }

    public boolean belongsTo(Object family) {
        if (family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
            return true;
        }
        if (family == ValidationBuilder.FAMILY_VALIDATION_JOB) {
            return true;
        }
        return super.belongsTo(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        Tracing.log("ValBuilderJob-01: Starting");
        try {
            this.startingValidation(monitor);
            ValidationRequest request = ValBuilderJob.getRequest();
            while (request != null) {
                this.run(request, monitor);
                request = ValBuilderJob.getRequest();
            }
        }
        finally {
            this.finishingValidation(monitor);
        }
        Tracing.log("ValBuilderJob-02: Finished");
        return Status.OK_STATUS;
    }

    private void startingValidation(IProgressMonitor monitor) {
        IValidatorVisitor startingVisitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.validationStarting(project, operation.getState(), monitor);
            }
        };
        ValManager.getDefault().accept(startingVisitor, null, ValType.Build, this.getOperation(), monitor);
    }

    private void finishingValidation(IProgressMonitor monitor) {
        IValidatorVisitor finishedVisitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.validationFinishing(project, operation.getState(), monitor);
            }
        };
        ValManager.getDefault().accept(finishedVisitor, null, ValType.Build, this.getOperation(), monitor);
    }

    /*
     * Loose catch block
     */
    private void run(ValidationRequest request, IProgressMonitor monitor) {
        block10: {
            this.setName(MessageFormat.format(ValMessages.JobNameWithProjectName, request.getProject().getName()));
            try {
                IValidatorVisitor startingVisitor = new IValidatorVisitor(){

                    public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                        validator.validationStarting(project, operation.getState(), monitor);
                    }
                };
                ValManager.getDefault().accept(startingVisitor, request.getProject(), ValType.Build, this.getOperation(), monitor);
                if (request.getDelta() == null) {
                    this.fullBuild(request, monitor);
                } else {
                    this.deltaBuild(request, monitor);
                }
            }
            catch (ProjectUnavailableError e) {
                ValidationPlugin.getPlugin().handleProjectUnavailableError(e);
                IValidatorVisitor finishedVisitor = new IValidatorVisitor(){

                    public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                        validator.validationFinishing(project, operation.getState(), monitor);
                    }
                };
                ValManager.getDefault().accept(finishedVisitor, request.getProject(), ValType.Build, this.getOperation(), monitor);
                break block10;
            }
            catch (ResourceUnavailableError e) {
                ValidationPlugin.getPlugin().handleResourceUnavailableError(e);
                IValidatorVisitor finishedVisitor = new /* invalid duplicate definition of identical inner class */;
                ValManager.getDefault().accept(finishedVisitor, request.getProject(), ValType.Build, this.getOperation(), monitor);
                break block10;
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException(e);
                {
                    catch (Throwable throwable) {
                        IValidatorVisitor finishedVisitor = new /* invalid duplicate definition of identical inner class */;
                        ValManager.getDefault().accept(finishedVisitor, request.getProject(), ValType.Build, this.getOperation(), monitor);
                        throw throwable;
                    }
                }
                IValidatorVisitor finishedVisitor = new /* invalid duplicate definition of identical inner class */;
                ValManager.getDefault().accept(finishedVisitor, request.getProject(), ValType.Build, this.getOperation(), monitor);
                break block10;
            }
            IValidatorVisitor finishedVisitor = new /* invalid duplicate definition of identical inner class */;
            ValManager.getDefault().accept(finishedVisitor, request.getProject(), ValType.Build, this.getOperation(), monitor);
        }
    }

    private void deltaBuild(ValidationRequest request, IProgressMonitor monitor) throws CoreException {
        ResourceCounter counter = new ResourceCounter();
        request.getDelta().accept((IResourceDeltaVisitor)counter);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)counter.getCount());
        Visitor vistitor = new Visitor(request, subMonitor, monitor, this.getOperation());
        request.getDelta().accept((IResourceDeltaVisitor)vistitor);
    }

    private void fullBuild(ValidationRequest request, IProgressMonitor monitor) throws CoreException {
        ResourceCounter counter = new ResourceCounter();
        request.getProject().accept((IResourceProxyVisitor)counter, 0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)counter.getCount());
        Visitor vistitor = new Visitor(request, subMonitor, monitor, this.getOperation());
        request.getProject().accept((IResourceVisitor)vistitor);
    }

    private ValOperation getOperation() {
        return this._operation;
    }

    static final class ResourceCounter
    implements IResourceProxyVisitor,
    IResourceDeltaVisitor {
        private int _count;

        ResourceCounter() {
        }

        public int getCount() {
            return this._count;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            ++this._count;
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            ++this._count;
            return true;
        }
    }

    static final class ValidationRequest {
        private final IProject _project;
        private final IResourceDelta _delta;
        private final int _buildKind;

        public ValidationRequest(IProject project, IResourceDelta delta, int buildKind) {
            this._project = project;
            this._delta = delta;
            this._buildKind = buildKind;
        }

        public IProject getProject() {
            return this._project;
        }

        public IResourceDelta getDelta() {
            return this._delta;
        }

        public int getBuildKind() {
            return this._buildKind;
        }
    }

    private static final class Visitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private final ValidationRequest _request;
        private final SubMonitor _subMonitor;
        private final IProgressMonitor _monitor;
        private final ValOperation _operation;

        public Visitor(ValidationRequest request, SubMonitor subMonitor, IProgressMonitor monitor, ValOperation operation) {
            this._request = request;
            this._subMonitor = subMonitor;
            this._monitor = monitor;
            this._operation = operation;
        }

        public boolean visit(IResource resource) throws CoreException {
            block4: {
                try {
                    if (!DisabledResourceManager.getDefault().isDisabled(resource)) break block4;
                    MarkerManager.getDefault().deleteMarkers(resource, this._operation.getStarted(), 2);
                    return false;
                }
                catch (ResourceUnavailableError e) {
                    if (Tracing.isLogging()) {
                        Tracing.log("ValBuilderJob-02: " + e.toString());
                    }
                    return false;
                }
            }
            ValManager.getDefault().validate(this._request.getProject(), resource, 0, ValType.Build, this._request.getBuildKind(), this._operation, (IProgressMonitor)this._subMonitor.newChild(1));
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IDependencyIndex index;
            IProject project;
            boolean isChanged;
            IResource resource = delta.getResource();
            if (DisabledResourceManager.getDefault().isDisabled(resource)) {
                MarkerManager.getDefault().deleteMarkers(resource, this._operation.getStarted(), 2);
                return false;
            }
            int kind = delta.getKind();
            boolean bl = isChanged = (kind & 4) != 0;
            if (isChanged && (delta.getFlags() & 0x103100) == 0) {
                return true;
            }
            if ((kind & 3) != 0 && resource.getType() == 1) {
                ValManager.getDefault().clearValProperty((IResource)resource.getProject());
            }
            if ((kind & 5) != 0) {
                ValManager.getDefault().validate(this._request.getProject(), resource, delta.getKind(), ValType.Build, this._request.getBuildKind(), this._operation, (IProgressMonitor)this._subMonitor.newChild(1));
            }
            if ((kind & 2) != 0 && !this._operation.isValidatedProject((IResource)(project = resource.getProject()))) {
                ValManager.getDefault().validate(this._request.getProject(), delta.getResource(), 2, ValType.Build, this._request.getBuildKind(), this._operation, (IProgressMonitor)this._subMonitor.newChild(1));
                this._operation.addValidatedProject((IResource)project);
            }
            if ((index = ValidationFramework.getDefault().getDependencyIndex()).isDependedOn(resource)) {
                MarkerManager mm = MarkerManager.getDefault();
                for (DependentResource dr : index.get(resource)) {
                    Validator val = dr.getValidator();
                    if (!Friend.shouldValidate(val, dr.getResource(), ValType.Build, new ContentTypeWrapper())) continue;
                    this._operation.getState().put("org.eclipse.wst.validation.Trigger", resource);
                    ValidationEvent event = new ValidationEvent(dr.getResource(), 0, delta);
                    if (val.shouldClearMarkers(event)) {
                        mm.clearMarker(dr.getResource(), val);
                    }
                    ValManager.getDefault().validate(val, this._operation, dr.getResource(), 0, this._monitor, event);
                }
            }
            return true;
        }
    }
}

