/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tracing.rcp.ui.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliCommandLine;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliOption;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.ICliParser;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.TracingRcpPlugin;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.messages.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;

@NonNullByDefault
public class RcpCliParser
implements ICliParser {
    private static final String OPTION_COMMAND_LINE_OPEN_SHORT = "o";
    private static final String OPTION_COMMAND_LINE_OPEN_LONG = "open";
    private static final String OPTION_COMMAND_LINE_OPEN_DESCRIPTION = Objects.requireNonNull(Messages.CliParser_OpenTraceDescription);
    private static final String OPTION_COMMAND_LINE_LIST_SHORT = "l";
    private static final String OPTION_COMMAND_LINE_LIST_LONG = "list";
    private static final String OPTION_COMMAND_LINE_LIST_DESCRIPTION = Objects.requireNonNull(Messages.CliParser_ListCapabilitiesDescription);
    private final List<CliOption> fOptions = new ArrayList<CliOption>();

    public RcpCliParser() {
        this.fOptions.add(CliOption.createSimpleOption((String)OPTION_COMMAND_LINE_LIST_SHORT, (String)OPTION_COMMAND_LINE_LIST_LONG, (String)OPTION_COMMAND_LINE_LIST_DESCRIPTION));
        this.fOptions.add(CliOption.createOptionWithArgs((String)OPTION_COMMAND_LINE_OPEN_SHORT, (String)OPTION_COMMAND_LINE_OPEN_LONG, (String)OPTION_COMMAND_LINE_OPEN_DESCRIPTION, (boolean)true, (boolean)true, (String)"path"));
    }

    public boolean preStartup(CliCommandLine commandLine) {
        if (commandLine.hasOption(OPTION_COMMAND_LINE_LIST_SHORT)) {
            System.out.println(Messages.CliParser_ListSupportedTraceTypes);
            System.out.println();
            for (TraceTypeHelper helper : TmfTraceType.getTraceTypeHelpers()) {
                System.out.println(String.valueOf(helper.getName()) + ": " + helper.getTraceTypeId());
                System.out.println();
            }
            return true;
        }
        return false;
    }

    public IStatus workspaceLoading(CliCommandLine commandLine, IProgressMonitor monitor) {
        if (commandLine.hasOption(OPTION_COMMAND_LINE_OPEN_SHORT)) {
            IProject defaultProject = RcpCliParser.createDefaultProject();
            IStatus returnStatus = Status.OK_STATUS;
            List<Path> allTracePaths = RcpCliParser.replaceHomeDir(commandLine.getOptionValues(OPTION_COMMAND_LINE_OPEN_SHORT));
            ArrayList<Path> tracePaths = new ArrayList<Path>();
            for (Path tracePath : allTracePaths) {
                if (!tracePath.toFile().exists()) {
                    returnStatus = RcpCliParser.addStatus(returnStatus, (IStatus)new Status(4, "org.eclipse.tracecompass.rcp.ui", NLS.bind((String)Messages.CliParser_TraceDoesNotExist, (Object)tracePath)));
                    continue;
                }
                tracePaths.add(tracePath);
            }
            Collection<TmfCommonProjectElement> existingTraceElement = RcpCliParser.findElements(tracePaths);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            WaitAllTracesOpened service = RcpCliParser.openTraceIfNecessary(defaultProject, tracePaths, existingTraceElement, monitor);
            returnStatus = RcpCliParser.addStatus(returnStatus, service.waitForCompletion(monitor));
            service.dispose();
            return returnStatus;
        }
        return Status.OK_STATUS;
    }

    private static Collection<TmfCommonProjectElement> findElements(List<Path> tracePaths) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(0);
        ArrayList<TmfCommonProjectElement> wanted = new ArrayList<TmfCommonProjectElement>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TmfProjectElement pElement = TmfProjectRegistry.getProject((IProject)project);
            if (pElement != null) {
                ArrayList tElements = new ArrayList();
                TmfTraceFolder tracesFolder = pElement.getTracesFolder();
                if (tracesFolder != null) {
                    tElements.addAll(tracesFolder.getTraces());
                }
                for (TmfCommonProjectElement tElement : tElements) {
                    Path elementPath = new Path(tElement.getLocation().getPath());
                    if (!tracePaths.contains(elementPath)) continue;
                    wanted.add(tElement);
                    tracePaths.remove(elementPath);
                }
            }
            ++n2;
        }
        return wanted;
    }

    private static List<Path> replaceHomeDir(String[] tracePaths) {
        ArrayList<Path> tracesToOpen = new ArrayList<Path>();
        String[] stringArray = tracePaths;
        int n = tracePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String tracePath;
            String traceToOpen = tracePath = stringArray[n2];
            String userHome = System.getProperty("user.home");
            if (traceToOpen != null && traceToOpen.startsWith("~/") && userHome != null) {
                traceToOpen = traceToOpen.replaceFirst("^~", userHome);
            }
            tracesToOpen.add(new Path(traceToOpen));
            ++n2;
        }
        return tracesToOpen;
    }

    private static IStatus addStatus(IStatus currentStatus, IStatus status) {
        if (currentStatus.isOK()) {
            return status;
        }
        if (currentStatus.isMultiStatus()) {
            ((MultiStatus)currentStatus).add(status);
            return currentStatus;
        }
        MultiStatus baseStatus = new MultiStatus("org.eclipse.tracecompass.rcp.ui", 1, Messages.CliParser_OpeningTraces, null);
        baseStatus.add(currentStatus);
        baseStatus.add(status);
        return baseStatus;
    }

    private static WaitAllTracesOpened openTraceIfNecessary(IProject project, List<Path> tracePaths, Collection<TmfCommonProjectElement> existingTraces, IProgressMonitor monitor) {
        WaitAllTracesOpened waitService = new WaitAllTracesOpened(tracePaths, existingTraces);
        if (!existingTraces.isEmpty()) {
            Display.getDefault().asyncExec(() -> {
                for (TmfCommonProjectElement existingTrace : existingTraces) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        IStatus status = TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)existingTrace);
                        if (status.isOK() && status.getCode() == 0) continue;
                        waitService.registerStatus(new Path(existingTrace.getLocation().getPath()), status);
                    }
                    catch (Exception e) {
                        waitService.registerException(new Path(existingTrace.getLocation().getPath()), e);
                    }
                }
            });
        }
        if (tracePaths.isEmpty()) {
            return waitService;
        }
        TmfTraceFolder destinationFolder = TmfProjectRegistry.getProject((IProject)project, (boolean)true).getTracesFolder();
        if (!tracePaths.isEmpty()) {
            Display.getDefault().asyncExec(() -> {
                for (Path tracePath : tracePaths) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        IStatus status = TmfOpenTraceHelper.openTraceFromPath((TmfTraceFolder)destinationFolder, (String)tracePath.toOSString(), (Shell)TracingRcpPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
                        if (status.isOK() && status.getCode() == 0) continue;
                        waitService.registerStatus(tracePath, status);
                    }
                    catch (CoreException e) {
                        waitService.registerException(tracePath, e);
                    }
                }
            });
        }
        return waitService;
    }

    private static IProject createDefaultProject() {
        return TmfProjectRegistry.createProject((String)TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public List<CliOption> getCmdLineOptions() {
        return this.fOptions;
    }

    public static class WaitAllTracesOpened
    extends TmfComponent {
        private final List<Path> fTracePath = new ArrayList<Path>();
        private final CountDownLatch fFinishedLatch;
        private IStatus fStatus = Status.OK_STATUS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WaitAllTracesOpened(List<Path> tracePaths, Collection<TmfCommonProjectElement> existingTraces) {
            super("Waiting for traces opening");
            List<Path> list = this.fTracePath;
            synchronized (list) {
                this.fTracePath.addAll(tracePaths);
                for (TmfCommonProjectElement element : existingTraces) {
                    this.fTracePath.add(new Path(element.getLocation().getPath()));
                }
                this.fFinishedLatch = new CountDownLatch(this.fTracePath.size());
                Set openedTraces = TmfTraceManager.getInstance().getOpenedTraces();
                for (ITmfTrace trace : openedTraces) {
                    Path path = new Path(trace.getPath());
                    if (!this.fTracePath.contains(path)) continue;
                    this.fTracePath.remove(path);
                    this.fFinishedLatch.countDown();
                }
            }
        }

        @TmfSignalHandler
        public synchronized void traceOpened(TmfTraceOpenedSignal signal) {
            ITmfTrace trace = signal.getTrace();
            Path path = new Path(trace.getPath());
            if (this.fTracePath.contains(path)) {
                this.fTracePath.remove(path);
                this.fFinishedLatch.countDown();
            }
        }

        @TmfSignalHandler
        public synchronized void traceSelected(TmfTraceSelectedSignal signal) {
            ITmfTrace trace = signal.getTrace();
            Path path = new Path(trace.getPath());
            if (this.fTracePath.contains(path)) {
                this.fTracePath.remove(path);
                this.fFinishedLatch.countDown();
            }
        }

        private IStatus waitForCompletion(IProgressMonitor monitor) {
            try {
                while (!this.fFinishedLatch.await(500L, TimeUnit.MILLISECONDS)) {
                    if (!monitor.isCanceled()) continue;
                    return RcpCliParser.addStatus(this.fStatus, (IStatus)new Status(8, "org.eclipse.tracecompass.rcp.ui", NLS.bind((String)Messages.CliParser_CancelStillWaiting, this.fTracePath)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.fStatus;
        }

        private void registerException(Path path, Throwable throwable) {
            this.registerStatus(path, (IStatus)new Status(4, "org.eclipse.tracecompass.rcp.ui", this.getName(), throwable));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerStatus(Path path, IStatus status) {
            List<Path> list = this.fTracePath;
            synchronized (list) {
                if (this.fTracePath.contains(path)) {
                    this.fTracePath.remove(path);
                    this.fFinishedLatch.countDown();
                    this.fStatus = RcpCliParser.addStatus(this.fStatus, status);
                }
            }
        }
    }
}

