/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class AddDelegateMethodsOperation
implements IWorkspaceRunnable {
    private boolean fApply = true;
    private final List fCreated = new ArrayList();
    private TextEdit fEdit = null;
    private final IJavaScriptElement fInsert;
    private final String[] fMethodKeys;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final IType fType;
    private final JavaScriptUnit fUnit;
    private final String[] fVariableKeys;

    public AddDelegateMethodsOperation(IType type, IJavaScriptElement insert, JavaScriptUnit unit, String[] variableKeys, String[] methodKeys, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)variableKeys);
        Assert.isNotNull((Object)methodKeys);
        Assert.isNotNull((Object)settings);
        Assert.isTrue((variableKeys.length == methodKeys.length ? 1 : 0) != 0);
        this.fType = type;
        this.fInsert = insert;
        this.fUnit = unit;
        this.fVariableKeys = variableKeys;
        this.fMethodKeys = methodKeys;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    public final String[] getCreatedMethods() {
        String[] keys = new String[this.fCreated.size()];
        this.fCreated.toArray(keys);
        return keys;
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        block26: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                IBinding[][] bindings;
                monitor.beginTask("", 1);
                monitor.setTaskName(CodeGenerationMessages.AddDelegateMethodsOperation_monitor_message);
                this.fCreated.clear();
                IJavaScriptUnit unit = this.fType.getJavaScriptUnit();
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(unit, this.fUnit);
                ITypeBinding binding = null;
                ListRewrite rewriter = null;
                if (this.fType.isAnonymous()) {
                    ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent(NodeFinder.perform((ASTNode)rewrite.getRoot(), this.fType.getNameRange()), ClassInstanceCreation.class);
                    if (creation != null) {
                        binding = creation.resolveTypeBinding();
                        AnonymousClassDeclaration declaration = creation.getAnonymousClassDeclaration();
                        if (declaration != null) {
                            rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                        }
                    }
                } else {
                    AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)rewrite.getRoot(), this.fType.getNameRange()), AbstractTypeDeclaration.class);
                    if (declaration != null) {
                        binding = declaration.resolveBinding();
                        rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                    }
                }
                if (binding == null || rewriter == null || (bindings = StubUtility2.getDelegatableMethods(rewrite.getAST(), binding)) == null || bindings.length <= 0) break block26;
                ITextFileBuffer buffer = null;
                IDocument document = null;
                try {
                    CompilationUnitChange change;
                    TextEdit edit;
                    if (!JavaModelUtil.isPrimary(unit)) {
                        document = new Document(unit.getBuffer().getContents());
                    } else {
                        buffer = RefactoringFileBuffers.acquire(unit);
                        document = buffer.getDocument();
                    }
                    ASTNode insertion = null;
                    if (this.fInsert instanceof IFunction) {
                        insertion = ASTNodes.getParent(NodeFinder.perform((ASTNode)rewrite.getRoot(), ((IFunction)this.fInsert).getNameRange()), FunctionDeclaration.class);
                    }
                    String variableKey = null;
                    String methodKey = null;
                    FunctionDeclaration stub = null;
                    int index = 0;
                    while (index < this.fMethodKeys.length) {
                        methodKey = this.fMethodKeys[index];
                        variableKey = this.fVariableKeys[index];
                        if (monitor.isCanceled()) break;
                        int offset = 0;
                        while (offset < bindings.length) {
                            if (bindings[offset][0].getKey().equals(variableKey) && bindings[offset][1].getKey().equals(methodKey)) {
                                stub = StubUtility2.createDelegationStub(rewrite.getCu(), rewrite.getASTRewrite(), rewrite.getImportRewrite(), rewrite.getAST(), bindings[offset], this.fSettings);
                                if (stub == null) break;
                                this.fCreated.add(methodKey);
                                if (insertion != null) {
                                    rewriter.insertBefore((ASTNode)stub, insertion, null);
                                    break;
                                }
                                rewriter.insertLast((ASTNode)stub, null);
                                break;
                            }
                            ++offset;
                        }
                        ++index;
                    }
                    CompilationUnitChange result = rewrite.createChange();
                    if (!(result instanceof CompilationUnitChange) || (edit = (change = result).getEdit()) == null) break block26;
                    try {
                        this.fEdit = edit;
                        if (this.fApply) {
                            edit.apply(document, 2);
                        }
                        if (this.fSave) {
                            if (buffer != null) {
                                buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                            } else {
                                unit.getBuffer().setContents(document.get());
                            }
                        }
                    }
                    catch (Exception exception) {
                        throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
                    }
                }
                finally {
                    if (buffer != null) {
                        RefactoringFileBuffers.release(unit);
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

