/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model;

public enum LogLevelType {
    LOGLEVEL("<=", "RANGE"),
    LOGLEVEL_ALL("All", "ALL"),
    LOGLEVEL_ONLY("==", "SINGLE"),
    LOGLEVEL_NONE("", "UNKNOWN");

    private final String fShortName;
    private final String fMiName;

    private LogLevelType(String shortName, String miName) {
        this.fShortName = shortName;
        this.fMiName = miName;
    }

    public String getShortName() {
        return this.fShortName;
    }

    public String getMiName() {
        return this.fMiName;
    }

    public static LogLevelType valueOfString(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        LogLevelType[] logLevelTypeArray = LogLevelType.values();
        int n = logLevelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevelType lltype = logLevelTypeArray[n2];
            if (!lltype.equals((Object)LOGLEVEL_NONE)) {
                boolean isEqual;
                boolean bl = isEqual = lltype.fShortName.equalsIgnoreCase(name) || lltype.fMiName.equalsIgnoreCase(name);
                if (isEqual) {
                    return lltype;
                }
            }
            ++n2;
        }
        return LOGLEVEL_NONE;
    }
}

