/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceFileHandler {
    protected String[] nameEntries;
    protected String[] hostEntries;
    protected String[] pathEntries;
    protected String[] protocolEntries;
    protected String[] portEntries;
    protected String[] isICEnabled = null;
    protected String namePreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpName", "", null);
    protected String hostPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpHost", "", null);
    protected String pathPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPath", "", null);
    protected String protocolPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpProtocol", "", null);
    protected String portPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPort", "", null);
    protected String icEnabledPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpICEnabled", "", null);
    protected int numEntries = 0;
    protected int numHostEntries = 0;
    protected static String PREFERENCE_ENTRY_DELIMITER = ",";
    public static final int LOCAL_HELP_ONLY = 0;
    public static final int LOCAL_HELP_PRIORITY = 1;
    public static final int REMOTE_HELP_PRIORITY = 2;

    public PreferenceFileHandler() {
        if (this.hostPreference.length() == 0) {
            this.hostEntries = new String[0];
            this.numHostEntries = 0;
        } else {
            this.hostEntries = this.hostPreference.split(PREFERENCE_ENTRY_DELIMITER);
            this.numHostEntries = this.hostEntries.length;
        }
        this.nameEntries = this.getValues(this.namePreference, "");
        this.pathEntries = this.getValues(this.pathPreference, "/");
        this.protocolEntries = this.getValues(this.protocolPreference, "http");
        this.portEntries = this.getValues(this.portPreference, "80");
        this.isICEnabled = this.getValues(this.icEnabledPreference, "true");
        this.numEntries = this.nameEntries == null ? 0 : this.nameEntries.length;
    }

    protected String[] getValues(String preferenceEntry, String appendString) {
        if (this.numHostEntries == 0) {
            return new String[0];
        }
        String[] updatedArray = null;
        String[] currEntries = !preferenceEntry.isEmpty() ? preferenceEntry.split(PREFERENCE_ENTRY_DELIMITER) : new String[]{};
        if (currEntries.length != this.numHostEntries) {
            updatedArray = new String[this.numHostEntries];
            if (currEntries.length > this.numHostEntries) {
                int i = 0;
                while (i < this.numHostEntries) {
                    updatedArray[i] = currEntries[i];
                    ++i;
                }
            } else {
                int entryCount = 0;
                int i = 0;
                while (i < currEntries.length) {
                    updatedArray[i] = currEntries[i];
                    ++entryCount;
                    ++i;
                }
                i = entryCount;
                while (i < this.numHostEntries) {
                    updatedArray[i] = appendString;
                    ++i;
                }
            }
            currEntries = updatedArray;
        }
        return currEntries;
    }

    public static void commitRemoteICs(RemoteIC[] remoteICs) {
        RemoteIC remote_ic = null;
        Object name = "";
        Object host = "";
        Object path = "";
        Object protocol = "";
        Object port = "";
        Object enabledString = "";
        int numICs = remoteICs.length;
        if (numICs > 0) {
            remote_ic = remoteICs[0];
            name = remote_ic.getName();
            host = remote_ic.getHost();
            path = remote_ic.getPath();
            protocol = remote_ic.getProtocol();
            port = remote_ic.getPort();
            boolean enabled = remote_ic.isEnabled();
            enabledString = "" + enabled;
            int i = 1;
            while (i < numICs) {
                remote_ic = remoteICs[i];
                name = (String)name + PREFERENCE_ENTRY_DELIMITER + remote_ic.getName();
                host = (String)host + PREFERENCE_ENTRY_DELIMITER + remote_ic.getHost();
                path = (String)path + PREFERENCE_ENTRY_DELIMITER + remote_ic.getPath();
                protocol = (String)protocol + PREFERENCE_ENTRY_DELIMITER + remote_ic.getProtocol();
                port = (String)port + PREFERENCE_ENTRY_DELIMITER + remote_ic.getPort();
                enabledString = (String)enabledString + PREFERENCE_ENTRY_DELIMITER + remote_ic.isEnabled();
                ++i;
            }
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.put("remoteHelpName", (String)name);
        prefs.put("remoteHelpHost", (String)host);
        prefs.put("remoteHelpPath", (String)path);
        prefs.put("remoteHelpProtocol", (String)protocol);
        prefs.put("remoteHelpPort", (String)port);
        prefs.put("remoteHelpICEnabled", (String)enabledString);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public ArrayList<RemoteIC> getRemoteICList() {
        ArrayList<RemoteIC> remoteICList = new ArrayList<RemoteIC>();
        int totalICs = this.getTotalRemoteInfocenters();
        int i = 0;
        while (i < totalICs) {
            String host = this.getHostEntries()[i];
            String name = this.getNameEntries()[i];
            String path = this.getPathEntries()[i];
            String protocol = this.getProtocolEntries()[i];
            String port = this.getPortEntries()[i];
            String enabledDisabled = this.getEnabledEntries()[i];
            boolean currEnabled = enabledDisabled.equalsIgnoreCase("true");
            RemoteIC initRemoteIC = new RemoteIC(currEnabled, name, host, path, protocol, port);
            remoteICList.add(initRemoteIC);
            ++i;
        }
        return remoteICList;
    }

    public static int getEmbeddedHelpOption() {
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        boolean isRemotePreferred = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpPreferred", false, null);
        if (!isRemoteOn) {
            return 0;
        }
        if (!isRemotePreferred) {
            return 1;
        }
        return 2;
    }

    public String[] getHostEntries() {
        return this.hostEntries;
    }

    public String[] getNameEntries() {
        return this.nameEntries;
    }

    public String[] getPathEntries() {
        return this.pathEntries;
    }

    public String[] getProtocolEntries() {
        return this.protocolEntries;
    }

    public String[] getPortEntries() {
        return this.portEntries;
    }

    public String[] getEnabledEntries() {
        return this.isICEnabled;
    }

    public int getTotalRemoteInfocenters() {
        return this.numEntries;
    }

    public String[] isEnabled() {
        return this.isICEnabled;
    }

    public String getDelimeter() {
        return PREFERENCE_ENTRY_DELIMITER;
    }
}

