/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tracecompass.core.trace;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.tracecompass.core.trace.LttngTraceCompassJulEventFactory;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventFactory;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class LttngTraceCompassJulTrace
extends CtfTmfTrace {
    private static final int CONFIDENCE = 101;
    private static final String LTTNG_JUL_EVENT = "lttng_jul:event";

    public LttngTraceCompassJulTrace() {
        super((CtfTmfEventFactory)LttngTraceCompassJulEventFactory.instance());
    }

    public IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("domain");
            if (domain == null || !domain.equals("\"ust\"")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.tracecompass.core", "Not a UST trace, so not a JUL trace");
            }
            Collection eventNames = ((CtfTraceValidationStatus)status).getEventNames();
            if (eventNames.size() == 1 && LTTNG_JUL_EVENT.equals(eventNames.iterator().next())) {
                return new TraceValidationStatus(101, "org.eclipse.tracecompass.incubator.tracecompass.core");
            }
        }
        return status;
    }
}

