/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.AbstractJUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class LegacyXmlResultFormatter
extends AbstractJUnitResultFormatter
implements TestResultFormatter {
    private static final double ONE_SECOND = 1000.0;
    private OutputStream outputStream;
    private final Map<TestIdentifier, Stats> testIds = new ConcurrentHashMap<TestIdentifier, Stats>();
    private final Map<TestIdentifier, Optional<String>> skipped = new ConcurrentHashMap<TestIdentifier, Optional<String>>();
    private final Map<TestIdentifier, Optional<Throwable>> failed = new ConcurrentHashMap<TestIdentifier, Optional<Throwable>>();
    private final Map<TestIdentifier, Optional<Throwable>> aborted = new ConcurrentHashMap<TestIdentifier, Optional<Throwable>>();
    private TestPlan testPlan;
    private long testPlanStartedAt = -1L;
    private long testPlanEndedAt = -1L;
    private final AtomicLong numTestsRun = new AtomicLong(0L);
    private final AtomicLong numTestsFailed = new AtomicLong(0L);
    private final AtomicLong numTestsSkipped = new AtomicLong(0L);
    private final AtomicLong numTestsAborted = new AtomicLong(0L);
    private boolean useLegacyReportingName = true;

    LegacyXmlResultFormatter() {
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.testPlanStartedAt = System.currentTimeMillis();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlanEndedAt = System.currentTimeMillis();
        try {
            new XMLReportWriter().write();
        }
        catch (IOException | XMLStreamException e) {
            this.handleException(e);
        }
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        long currentTime = System.currentTimeMillis();
        this.numTestsSkipped.incrementAndGet();
        this.skipped.put(testIdentifier, Optional.ofNullable(reason));
        Stats stats = new Stats(testIdentifier, currentTime);
        stats.endedAt = currentTime;
        this.testIds.put(testIdentifier, stats);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        long currentTime = System.currentTimeMillis();
        this.testIds.putIfAbsent(testIdentifier, new Stats(testIdentifier, currentTime));
        if (testIdentifier.isTest()) {
            this.numTestsRun.incrementAndGet();
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        long currentTime = System.currentTimeMillis();
        Stats stats = this.testIds.get(testIdentifier);
        if (stats != null) {
            stats.endedAt = currentTime;
        }
        switch (testExecutionResult.getStatus()) {
            case SUCCESSFUL: {
                break;
            }
            case ABORTED: {
                this.numTestsAborted.incrementAndGet();
                this.aborted.put(testIdentifier, testExecutionResult.getThrowable());
                break;
            }
            case FAILED: {
                this.numTestsFailed.incrementAndGet();
                this.failed.put(testIdentifier, testExecutionResult.getThrowable());
            }
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
    }

    @Override
    public void setDestination(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public void setUseLegacyReportingName(boolean useLegacyReportingName) {
        this.useLegacyReportingName = useLegacyReportingName;
    }

    private final class XMLReportWriter {
        private static final String ELEM_TESTSUITE = "testsuite";
        private static final String ELEM_PROPERTIES = "properties";
        private static final String ELEM_PROPERTY = "property";
        private static final String ELEM_TESTCASE = "testcase";
        private static final String ELEM_SKIPPED = "skipped";
        private static final String ELEM_FAILURE = "failure";
        private static final String ELEM_ABORTED = "aborted";
        private static final String ELEM_SYSTEM_OUT = "system-out";
        private static final String ELEM_SYSTEM_ERR = "system-err";
        private static final String ATTR_CLASSNAME = "classname";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_VALUE = "value";
        private static final String ATTR_TIME = "time";
        private static final String ATTR_TIMESTAMP = "timestamp";
        private static final String ATTR_NUM_ABORTED = "aborted";
        private static final String ATTR_NUM_FAILURES = "failures";
        private static final String ATTR_NUM_TESTS = "tests";
        private static final String ATTR_NUM_SKIPPED = "skipped";
        private static final String ATTR_MESSAGE = "message";
        private static final String ATTR_TYPE = "type";

        private XMLReportWriter() {
        }

        void write() throws XMLStreamException, IOException {
            try (XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(LegacyXmlResultFormatter.this.outputStream, "UTF-8");){
                writer.writeStartDocument();
                this.writeTestSuite(writer);
                writer.writeEndDocument();
            }
        }

        void writeTestSuite(XMLStreamWriter writer) throws XMLStreamException, IOException {
            writer.writeStartElement(ELEM_TESTSUITE);
            String testsuiteName = this.determineTestSuiteName();
            this.writeAttribute(writer, ATTR_NAME, testsuiteName);
            this.writeAttribute(writer, ATTR_TIME, String.valueOf((double)(LegacyXmlResultFormatter.this.testPlanEndedAt - LegacyXmlResultFormatter.this.testPlanStartedAt) / 1000.0));
            String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
            this.writeAttribute(writer, ATTR_TIMESTAMP, timestamp);
            this.writeAttribute(writer, ATTR_NUM_TESTS, String.valueOf(LegacyXmlResultFormatter.this.numTestsRun.longValue()));
            this.writeAttribute(writer, ATTR_NUM_FAILURES, String.valueOf(LegacyXmlResultFormatter.this.numTestsFailed.longValue()));
            this.writeAttribute(writer, "skipped", String.valueOf(LegacyXmlResultFormatter.this.numTestsSkipped.longValue()));
            this.writeAttribute(writer, "aborted", String.valueOf(LegacyXmlResultFormatter.this.numTestsAborted.longValue()));
            this.writeProperties(writer);
            this.writeTestCase(writer);
            this.writeSysOut(writer);
            this.writeSysErr(writer);
            writer.writeEndElement();
        }

        void writeProperties(XMLStreamWriter writer) throws XMLStreamException {
            Properties properties = LegacyXmlResultFormatter.this.context.getProperties();
            if (properties == null || properties.isEmpty()) {
                return;
            }
            writer.writeStartElement(ELEM_PROPERTIES);
            for (String prop : properties.stringPropertyNames()) {
                writer.writeStartElement(ELEM_PROPERTY);
                this.writeAttribute(writer, ATTR_NAME, prop);
                this.writeAttribute(writer, ATTR_VALUE, properties.getProperty(prop));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        void writeTestCase(XMLStreamWriter writer) throws XMLStreamException {
            for (Map.Entry entry : LegacyXmlResultFormatter.this.testIds.entrySet()) {
                TestSource testSource;
                TestIdentifier testId = (TestIdentifier)entry.getKey();
                if (!testId.isTest() && !LegacyXmlResultFormatter.this.failed.containsKey(testId)) continue;
                String classname = null;
                Optional<ClassSource> parentClassSource = testId.isTest() ? this.findFirstParentClassSource(testId) : this.findFirstClassSource(testId);
                if (parentClassSource.isPresent()) {
                    classname = parentClassSource.get().getClassName();
                } else if (testId.getSource().isPresent() && (testSource = (TestSource)testId.getSource().get()) instanceof MethodSource) {
                    classname = ((MethodSource)testSource).getClassName();
                }
                if (classname == null) {
                    classname = testId.getUniqueIdObject().toString();
                }
                writer.writeStartElement(ELEM_TESTCASE);
                this.writeAttribute(writer, ATTR_CLASSNAME, classname);
                this.writeAttribute(writer, ATTR_NAME, LegacyXmlResultFormatter.this.useLegacyReportingName ? testId.getLegacyReportingName() : testId.getDisplayName());
                Stats stats = (Stats)entry.getValue();
                this.writeAttribute(writer, ATTR_TIME, String.valueOf((double)(stats.endedAt - stats.startedAt) / 1000.0));
                this.writeSkipped(writer, testId);
                this.writeFailed(writer, testId);
                this.writeAborted(writer, testId);
                writer.writeEndElement();
            }
        }

        private void writeSkipped(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.skipped.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement("skipped");
            Optional reason = (Optional)LegacyXmlResultFormatter.this.skipped.get(testIdentifier);
            if (reason.isPresent()) {
                this.writeAttribute(writer, ATTR_MESSAGE, (String)reason.get());
            }
            writer.writeEndElement();
        }

        private void writeFailed(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.failed.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement(ELEM_FAILURE);
            Optional cause = (Optional)LegacyXmlResultFormatter.this.failed.get(testIdentifier);
            if (cause.isPresent()) {
                Throwable t = (Throwable)cause.get();
                String message = t.getMessage();
                if (message != null && !message.trim().isEmpty()) {
                    this.writeAttribute(writer, ATTR_MESSAGE, message);
                }
                this.writeAttribute(writer, ATTR_TYPE, t.getClass().getName());
                this.writeCDataSafely(writer, StringUtils.getStackTrace((Throwable)t));
            }
            writer.writeEndElement();
        }

        private void writeAborted(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.aborted.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement("aborted");
            Optional cause = (Optional)LegacyXmlResultFormatter.this.aborted.get(testIdentifier);
            if (cause.isPresent()) {
                Throwable t = (Throwable)cause.get();
                String message = t.getMessage();
                if (message != null && !message.trim().isEmpty()) {
                    this.writeAttribute(writer, ATTR_MESSAGE, message);
                }
                this.writeAttribute(writer, ATTR_TYPE, t.getClass().getName());
                this.writeCDataSafely(writer, StringUtils.getStackTrace((Throwable)t));
            }
            writer.writeEndElement();
        }

        private void writeSysOut(XMLStreamWriter writer) throws XMLStreamException, IOException {
            if (!LegacyXmlResultFormatter.this.hasSysOut()) {
                return;
            }
            writer.writeStartElement(ELEM_SYSTEM_OUT);
            try (Reader reader = LegacyXmlResultFormatter.this.getSysOutReader();){
                this.writeCharactersFrom(reader, writer);
            }
            writer.writeEndElement();
        }

        private void writeSysErr(XMLStreamWriter writer) throws XMLStreamException, IOException {
            if (!LegacyXmlResultFormatter.this.hasSysErr()) {
                return;
            }
            writer.writeStartElement(ELEM_SYSTEM_ERR);
            try (Reader reader = LegacyXmlResultFormatter.this.getSysErrReader();){
                this.writeCharactersFrom(reader, writer);
            }
            writer.writeEndElement();
        }

        private void writeCDataSafely(XMLStreamWriter writer, String cdata) throws XMLStreamException {
            writer.writeCData(cdata.replace("]]>", "]]]]><![CDATA[>"));
        }

        private void writeCharactersFrom(Reader reader, XMLStreamWriter writer) throws IOException, XMLStreamException {
            char[] chars = new char[1024];
            int numRead = -1;
            while ((numRead = reader.read(chars)) != -1) {
                writer.writeCharacters(this.encode(new String(chars, 0, numRead)));
            }
        }

        private void writeAttribute(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
            writer.writeAttribute(name, this.encode(value));
        }

        private String encode(String s) {
            boolean changed = false;
            StringBuilder sb = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (!DOMElementWriter.isLegalXmlCharacter((char)c)) {
                    changed = true;
                    sb.append("&#").append((int)c).append(';');
                    continue;
                }
                sb.append(c);
            }
            return changed ? sb.toString() : s;
        }

        private String determineTestSuiteName() {
            Set roots = LegacyXmlResultFormatter.this.testPlan.getRoots();
            if (roots.isEmpty()) {
                return "UNKNOWN";
            }
            for (TestIdentifier root : roots) {
                Optional<ClassSource> classSource = this.findFirstClassSource(root);
                if (!classSource.isPresent()) continue;
                return classSource.get().getClassName();
            }
            return "UNKNOWN";
        }

        private Optional<ClassSource> findFirstClassSource(TestIdentifier root) {
            TestSource source;
            if (root.getSource().isPresent() && (source = (TestSource)root.getSource().get()) instanceof ClassSource) {
                return Optional.of((ClassSource)source);
            }
            for (TestIdentifier child : LegacyXmlResultFormatter.this.testPlan.getChildren(root)) {
                Optional<ClassSource> classSource = this.findFirstClassSource(child);
                if (!classSource.isPresent()) continue;
                return classSource;
            }
            return Optional.empty();
        }

        private Optional<ClassSource> findFirstParentClassSource(TestIdentifier testId) {
            Optional parent = LegacyXmlResultFormatter.this.testPlan.getParent(testId);
            if (!parent.isPresent()) {
                return Optional.empty();
            }
            if (!((TestIdentifier)parent.get()).getSource().isPresent()) {
                return this.findFirstParentClassSource((TestIdentifier)parent.get());
            }
            TestSource parentSource = (TestSource)((TestIdentifier)parent.get()).getSource().get();
            return parentSource instanceof ClassSource ? Optional.of((ClassSource)parentSource) : this.findFirstParentClassSource((TestIdentifier)parent.get());
        }
    }

    private final class Stats {
        private final TestIdentifier testIdentifier;
        private final long startedAt;
        private long endedAt;

        private Stats(TestIdentifier testIdentifier, long startedAt) {
            this.testIdentifier = testIdentifier;
            this.startedAt = startedAt;
        }
    }
}

