/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.util.HashMap;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public class JavaScriptProcess
extends PlatformObject
implements IProcess {
    private HashMap attributes = new HashMap();
    private ILaunch launch = null;
    private boolean terminated = false;
    private String name = null;

    public JavaScriptProcess(ILaunch launch, String name) {
        this.launch = launch;
        this.name = name;
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProcess.class) {
            return this;
        }
        if (adapter == ILaunch.class) {
            return this.launch;
        }
        if (adapter.equals(IDebugTarget.class)) {
            IDebugTarget[] targets = this.launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    void fireEvent(DebugEvent event) {
        DebugPlugin dp = DebugPlugin.getDefault();
        if (dp != null) {
            dp.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTerminate() {
        JavaScriptProcess javaScriptProcess = this;
        synchronized (javaScriptProcess) {
            return !this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        JavaScriptProcess javaScriptProcess = this;
        synchronized (javaScriptProcess) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        JavaScriptProcess javaScriptProcess = this;
        synchronized (javaScriptProcess) {
            if (!this.terminated) {
                this.fireEvent(new DebugEvent((Object)this, 8));
                this.terminated = true;
            }
        }
    }

    public String getLabel() {
        return this.name;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        if (key != null) {
            this.attributes.put(key, value);
            this.fireEvent(new DebugEvent((Object)this, 16));
        }
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }
}

