/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceDataType;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceValueSign;

public class BinaryFTraceFormatField {
    private final String fFieldName;
    private final BinaryFTraceDataType fFieldType;
    private final String fStrFieldType;
    private final int fOffset;
    private final int fSize;
    private final BinaryFTraceValueSign fSigned;
    private final boolean fDataLoc;
    private final int fArrayLength;
    private final boolean fPointer;

    private BinaryFTraceFormatField(BinaryFTraceFormatFieldBuilder builder) {
        this.fFieldName = builder.fBuilderFieldName;
        this.fFieldType = builder.fBuilderFieldType;
        this.fStrFieldType = builder.fBuilderStrFieldType;
        this.fOffset = builder.fBuilderOffset;
        this.fSize = builder.fBuilderSize;
        this.fSigned = builder.fBuilderSigned;
        this.fDataLoc = builder.fBuilderDataLoc;
        this.fArrayLength = builder.fBuilderArrayLength;
        this.fPointer = builder.fBuilderPointer;
    }

    public String getStrFieldType() {
        return this.fStrFieldType;
    }

    public BinaryFTraceDataType getFieldType() {
        return this.fFieldType;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getSize() {
        return this.fSize;
    }

    public BinaryFTraceValueSign getSigned() {
        return this.fSigned;
    }

    public boolean isDataLoc() {
        return this.fDataLoc;
    }

    public int getArrayLength() {
        return this.fArrayLength;
    }

    public boolean isPointer() {
        return this.fPointer;
    }

    public boolean isString() {
        return this.fFieldType == BinaryFTraceDataType.CHAR && this.fArrayLength >= 0;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Field name: ").append(this.fFieldName).append("; Field type: ").append((Object)this.fFieldType).append("; Offset: ").append(this.fOffset).append("; Size: ").append(this.fSize).append("; Signed: ").append((Object)this.fSigned);
        return strBuilder.toString();
    }

    /* synthetic */ BinaryFTraceFormatField(BinaryFTraceFormatFieldBuilder binaryFTraceFormatFieldBuilder, BinaryFTraceFormatField binaryFTraceFormatField) {
        this(binaryFTraceFormatFieldBuilder);
    }

    public static class BinaryFTraceFormatFieldBuilder {
        public static final int DEFAULT_ARRAY_LENGTH = -1;
        public static final int UNKNOWN_ARRAY_LENGTH = 0;
        private String fBuilderFieldName = "";
        private BinaryFTraceDataType fBuilderFieldType = BinaryFTraceDataType.UNKNOWN;
        private String fBuilderStrFieldType = "";
        private int fBuilderOffset = -1;
        private int fBuilderSize = 0;
        private BinaryFTraceValueSign fBuilderSigned = BinaryFTraceValueSign.UNSIGNED;
        private boolean fBuilderDataLoc = false;
        private int fBuilderArrayLength = -1;
        private boolean fBuilderPointer = false;

        public BinaryFTraceFormatFieldBuilder fieldName(String fieldName) {
            this.fBuilderFieldName = fieldName;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder fieldType(BinaryFTraceDataType fieldType) {
            this.fBuilderFieldType = fieldType;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder strFieldType(String strFieldType) {
            this.fBuilderStrFieldType = strFieldType;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder offset(int offset) {
            this.fBuilderOffset = offset;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder size(int size) {
            this.fBuilderSize = size;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder signed(BinaryFTraceValueSign signed) {
            this.fBuilderSigned = signed;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder dataLoc(boolean isDataLoc) {
            this.fBuilderDataLoc = isDataLoc;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder array(int arrayLength) {
            this.fBuilderArrayLength = arrayLength;
            return this;
        }

        public BinaryFTraceFormatFieldBuilder pointer(boolean isPointer) {
            this.fBuilderPointer = isPointer;
            return this;
        }

        public BinaryFTraceFormatField build() {
            return new BinaryFTraceFormatField(this, null);
        }
    }
}

