/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.DetailedProgressViewer;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.ProgressLabelProvider;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.ProgressViewUpdater;
import org.eclipse.e4.ui.progress.internal.ProgressViewerContentProvider;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BlockedJobsDialog
extends IconAndMessageDialog {
    protected static BlockedJobsDialog singleton;
    private DetailedProgressViewer viewer;
    private String blockedTaskName = ProgressMessages.SubTaskInfo_UndefinedTaskName;
    private Button cancelSelected;
    private IProgressMonitor blockingMonitor;
    private JobTreeElement blockedElement = new BlockedUIElement();
    private IProgressService progressService;
    private FinishedJobs finishedJobs;
    private ProgressManager progressManager;
    private ProgressViewUpdater progressViewUpdater;

    public static BlockedJobsDialog createBlockedDialog(Shell parentShell, IProgressMonitor blockedMonitor, IStatus reason, String taskName, IProgressService progressService, FinishedJobs finishedJobs, ProgressViewUpdater viewUpdater, ProgressManager progressManager) {
        if (singleton != null) {
            return singleton;
        }
        singleton = new BlockedJobsDialog(parentShell, blockedMonitor, reason, progressService, finishedJobs, viewUpdater, progressManager);
        if (taskName == null || taskName.length() == 0) {
            singleton.setBlockedTaskName(ProgressMessages.BlockedJobsDialog_UserInterfaceTreeElement);
        } else {
            singleton.setBlockedTaskName(taskName);
        }
        if (parentShell == null) {
            UIJob dialogJob = new UIJob(ProgressMessages.EventLoopProgressMonitor_OpenDialogJobName){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (singleton == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ProgressManagerUtil.rescheduleIfModalShellOpen(this, Services.getInstance().getProgressService())) {
                        return Status.CANCEL_STATUS;
                    }
                    singleton.open();
                    return Status.OK_STATUS;
                }
            };
            dialogJob.setSystem(true);
            dialogJob.schedule(Services.getInstance().getProgressService().getLongOperationTime());
        } else {
            singleton.open();
        }
        return singleton;
    }

    public static void clear(IProgressMonitor monitor) {
        if (singleton == null) {
            return;
        }
        singleton.close(monitor);
    }

    private BlockedJobsDialog(Shell parentShell, IProgressMonitor blocking, IStatus blockingStatus, IProgressService progressService, FinishedJobs finishedJobs, ProgressViewUpdater viewUpdater, ProgressManager progressManager) {
        super(parentShell == null ? ProgressManagerUtil.getDefaultParent() : parentShell);
        this.blockingMonitor = blocking;
        this.progressService = progressService;
        this.finishedJobs = finishedJobs;
        this.progressViewUpdater = viewUpdater;
        this.progressManager = progressManager;
        this.setShellStyle(0x10C30 | BlockedJobsDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
        this.setMessage(blockingStatus.getMessage());
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.message);
        this.createMessageArea(parent);
        this.showJobDetails(parent);
        return parent;
    }

    void showJobDetails(Composite parent) {
        int heightHint;
        this.viewer = new DetailedProgressViewer(parent, 2818, this.progressService, this.finishedJobs);
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        ProgressViewerContentProvider provider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = heightHint = this.convertHeightInCharsToPixels(10);
        this.viewer.getControl().setLayoutData((Object)data);
    }

    private ProgressViewerContentProvider getContentProvider() {
        return new ProgressViewerContentProvider(this.viewer, this.finishedJobs, this.progressViewUpdater, this.progressManager, true, false){

            @Override
            public Object[] getElements(Object inputElement) {
                Object[] elements = super.getElements(inputElement);
                Object[] result = new Object[elements.length + 1];
                System.arraycopy(elements, 0, result, 1, elements.length);
                result[0] = BlockedJobsDialog.this.blockedElement;
                return result;
            }
        };
    }

    private void clearCursors() {
        this.clearCursor((Control)this.cancelSelected);
        this.clearCursor((Control)this.getShell());
    }

    private void clearCursor(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setCursor(null);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ProgressMessages.BlockedJobsDialog_BlockedTitle);
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.blockingMonitor;
    }

    public boolean close(IProgressMonitor monitor) {
        if (this.blockingMonitor != monitor) {
            return false;
        }
        return this.close();
    }

    public boolean close() {
        singleton = null;
        this.clearCursors();
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    void setBlockedTaskName(String taskName) {
        this.blockedTaskName = taskName;
    }

    private class BlockedUIElement
    extends JobTreeElement {
        private BlockedUIElement() {
        }

        @Override
        Object[] getChildren() {
            return ProgressManagerUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        String getDisplayString() {
            if (BlockedJobsDialog.this.blockedTaskName == null || BlockedJobsDialog.this.blockedTaskName.length() == 0) {
                return ProgressMessages.BlockedJobsDialog_UserInterfaceTreeElement;
            }
            return BlockedJobsDialog.this.blockedTaskName;
        }

        @Override
        public Image getDisplayImage() {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }

        @Override
        boolean hasChildren() {
            return false;
        }

        @Override
        boolean isActive() {
            return true;
        }

        @Override
        boolean isJobInfo() {
            return false;
        }

        @Override
        public void cancel() {
            BlockedJobsDialog.this.blockingMonitor.setCanceled(true);
        }

        @Override
        public boolean isCancellable() {
            return true;
        }
    }
}

