/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.service.prefs.BackingStoreException;

public class HelpPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String WBROWSER_PAGE_ID = "org.eclipse.ui.browser.preferencePage";
    private Combo useExternalCombo;
    private Combo searchLocationCombo;
    private Combo openModeCombo;
    private Combo dialogHelpCombo;
    private Combo windowHelpCombo;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelp");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        Label description = new Label(mainComposite, 0);
        description.setText(Messages.select_browser);
        this.createOpenModesPrefs(mainComposite);
        this.createDynamicHelpArea(mainComposite);
        this.createSpacer(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        return mainComposite;
    }

    private void createOpenModesPrefs(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(Messages.HelpPreferencePage_openModeGroup);
        this.createSearchLocation((Composite)group);
        this.createHelpViewOpenPrefs(group);
        this.createOpenContents((Composite)group);
        this.createLinkArea((Composite)group);
    }

    private void createDynamicHelpArea(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(Messages.HelpPreferencePage_contextHelpGroup);
        this.createWindowContextPrefs(group);
        this.createDialogContextPrefs(group);
    }

    private void createSearchLocation(Composite mainComposite) {
        Label searchLocationLabel = new Label(mainComposite, 0);
        searchLocationLabel.setText(Messages.HelpPreferencePage_searchLocation);
        searchLocationLabel.setLayoutData((Object)this.createLabelData());
        this.searchLocationCombo = new Combo(mainComposite, 8);
        this.searchLocationCombo.add(Messages.HelpPreferencePage_view);
        this.searchLocationCombo.add(Messages.HelpPreferencePage_openInBrowser);
        this.searchLocationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        boolean searchFromBrowser = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "search_from_browser", false, null);
        this.searchLocationCombo.setText(searchFromBrowser ? Messages.HelpPreferencePage_openInBrowser : Messages.HelpPreferencePage_view);
    }

    private void createOpenContents(Composite mainComposite) {
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            Label isExternalLabel = new Label(mainComposite, 0);
            isExternalLabel.setText(Messages.HelpPreferencePage_openContents);
            isExternalLabel.setLayoutData((Object)this.createLabelData());
            this.useExternalCombo = new Combo(mainComposite, 8);
            this.useExternalCombo.add(Messages.HelpPreferencePage_helpBrowser);
            this.useExternalCombo.add(Messages.HelpPreferencePage_externalBrowser);
            this.useExternalCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            boolean useExternal = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "always_external_browser", false, null);
            this.useExternalCombo.setText(useExternal ? Messages.HelpPreferencePage_externalBrowser : Messages.HelpPreferencePage_helpBrowser);
        }
    }

    private void createLinkArea(Composite parent) {
        IPreferenceNode node = this.getPreferenceNode(WBROWSER_PAGE_ID);
        if (node != null) {
            PreferenceLinkArea linkArea = new PreferenceLinkArea(parent, 64, WBROWSER_PAGE_ID, Messages.HelpPreferencePage_message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
            GridData data = new GridData(768);
            linkArea.getControl().setLayoutData((Object)data);
        }
    }

    private void createHelpViewOpenPrefs(Group group) {
        if (PlatformUI.getWorkbench().getBrowserSupport().isInternalWebBrowserAvailable()) {
            Label ohelpDescription = new Label((Composite)group, 0);
            ohelpDescription.setText(Messages.HelpPreferencePage_olabel);
            ohelpDescription.setLayoutData((Object)this.createLabelData());
            this.openModeCombo = new Combo((Composite)group, 8);
            this.openModeCombo.add(Messages.HelpPreferencePage_openInPlace);
            this.openModeCombo.add(Messages.HelpPreferencePage_openInEditor);
            this.openModeCombo.add(Messages.HelpPreferencePage_openInBrowser);
            this.openModeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            String openMode = Platform.getPreferencesService().getString("org.eclipse.help.base", "help_view_open_mode", "in_place", null);
            this.openModeCombo.setText(this.openModeToString(openMode));
        }
    }

    private void createDialogContextPrefs(Group group) {
        Label dhelpDescription = new Label((Composite)group, 0);
        dhelpDescription.setText(Messages.HelpPreferencePage_dlabel);
        dhelpDescription.setLayoutData((Object)this.createLabelData());
        this.dialogHelpCombo = new Combo((Composite)group, 8);
        this.dialogHelpCombo.add(Messages.HelpPreferencePage_tray);
        this.dialogHelpCombo.add(Messages.HelpPreferencePage_infopop);
        this.dialogHelpCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        boolean dinfopop = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "dialog_infopop", false, null);
        this.dialogHelpCombo.setText(dinfopop ? Messages.HelpPreferencePage_infopop : Messages.HelpPreferencePage_tray);
    }

    private void createWindowContextPrefs(Group group) {
        Label whelpDescription = new Label((Composite)group, 0);
        whelpDescription.setText(Messages.HelpPreferencePage_wlabel);
        whelpDescription.setLayoutData((Object)this.createLabelData());
        this.windowHelpCombo = new Combo((Composite)group, 8);
        this.windowHelpCombo.add(Messages.HelpPreferencePage_view);
        this.windowHelpCombo.add(Messages.HelpPreferencePage_infopop);
        this.windowHelpCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        boolean winfopop = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "window_infopop", false, null);
        this.windowHelpCombo.setText(winfopop ? Messages.HelpPreferencePage_infopop : Messages.HelpPreferencePage_view);
    }

    private GridData createLabelData() {
        GridData data = new GridData(4, 0x1000000, true, false);
        data.verticalIndent = 5;
        return data;
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        for (IPreferenceNode next : PlatformUI.getWorkbench().getPreferenceManager().getElements(0)) {
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        boolean searchFromBrowser;
        IEclipsePreferences defaults = DefaultScope.INSTANCE.getNode("org.eclipse.help.base");
        if (this.useExternalCombo != null) {
            boolean useExternal = defaults.getBoolean("always_external_browser", false);
            this.useExternalCombo.setText(useExternal ? Messages.HelpPreferencePage_externalBrowser : Messages.HelpPreferencePage_helpBrowser);
        }
        this.searchLocationCombo.setText((searchFromBrowser = defaults.getBoolean("search_from_browser", false)) ? Messages.HelpPreferencePage_openInBrowser : Messages.HelpPreferencePage_view);
        boolean winfopop = defaults.getBoolean("window_infopop", false);
        this.windowHelpCombo.setText(winfopop ? Messages.HelpPreferencePage_infopop : Messages.HelpPreferencePage_view);
        boolean dinfopop = defaults.getBoolean("dialog_infopop", false);
        this.dialogHelpCombo.setText(dinfopop ? Messages.HelpPreferencePage_infopop : Messages.HelpPreferencePage_tray);
        if (this.openModeCombo != null) {
            String openMode = defaults.get("help_view_open_mode", "in_place");
            this.openModeCombo.setText(this.openModeToString(openMode));
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        if (this.useExternalCombo != null) {
            boolean isExternalBrowser = this.useExternalCombo.getText().equals(Messages.HelpPreferencePage_externalBrowser);
            pref.putBoolean("always_external_browser", isExternalBrowser);
            BrowserManager.getInstance().setAlwaysUseExternal(isExternalBrowser);
        }
        pref.putBoolean("search_from_browser", this.searchLocationCombo.getText().equals(Messages.HelpPreferencePage_openInBrowser));
        pref.putBoolean("window_infopop", this.windowHelpCombo.getText().equals(Messages.HelpPreferencePage_infopop));
        pref.putBoolean("dialog_infopop", this.dialogHelpCombo.getText().equals(Messages.HelpPreferencePage_infopop));
        if (this.openModeCombo != null) {
            pref.put("help_view_open_mode", this.openModeFromString(this.openModeCombo.getText()));
        }
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            ILog.of(((Object)((Object)this)).getClass()).error("Failed to save preferences", (Throwable)e);
        }
        return true;
    }

    private String openModeToString(String openMode) {
        if ("in browser".equals(openMode)) {
            return Messages.HelpPreferencePage_openInBrowser;
        }
        if ("in editor".equals(openMode)) {
            return Messages.HelpPreferencePage_openInEditor;
        }
        return Messages.HelpPreferencePage_openInPlace;
    }

    private String openModeFromString(String openMode) {
        if (Messages.HelpPreferencePage_openInBrowser.equals(openMode)) {
            return "in browser";
        }
        if (Messages.HelpPreferencePage_openInEditor.equals(openMode)) {
            return "in editor";
        }
        return "in_place";
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }
}

