/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.equinox.internal.p2.ui.viewers.IDeferredQueryTreeListener;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class DeferredQueryTreeContentManager
extends DeferredTreeContentManager {
    Object elementRequested;
    ListenerList<IDeferredQueryTreeListener> listeners;
    private final AbstractTreeViewer treeViewer;

    public DeferredQueryTreeContentManager(AbstractTreeViewer viewer) {
        super(viewer);
        this.treeViewer = viewer;
        this.listeners = new ListenerList();
    }

    protected void addChildren(Object parent, Object[] children, IProgressMonitor monitor) {
        UIJob updateJob = UIJob.create((String)"Adding children", updateMonitor -> {
            if (this.treeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.treeViewer.add(parent, children);
            return Status.OK_STATUS;
        });
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public Object[] getChildren(Object parent) {
        this.elementRequested = parent;
        return super.getChildren(parent);
    }

    protected void startFetchingDeferredChildren(Object parent, IDeferredWorkbenchAdapter adapter, PendingUpdateAdapter placeholder) {
        if (placeholder instanceof ElementPendingUpdateAdapter) {
            this.notifyListener(true, (ElementPendingUpdateAdapter)placeholder);
        }
        super.startFetchingDeferredChildren(parent, adapter, placeholder);
    }

    protected void runClearPlaceholderJob(PendingUpdateAdapter placeholder) {
        if (placeholder instanceof ElementPendingUpdateAdapter) {
            ElementPendingUpdateAdapter pendingUpdate = (ElementPendingUpdateAdapter)placeholder;
            if (pendingUpdate.isRemoved()) {
                return;
            }
            this.notifyListener(false, (ElementPendingUpdateAdapter)placeholder);
            UIJob clearJob = UIJob.create((String)"Clearing", monitor -> {
                if (!pendingUpdate.isRemoved()) {
                    Control control = this.treeViewer.getControl();
                    if (control.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.treeViewer.remove((Object)placeholder);
                    pendingUpdate.setRemoved(true);
                }
                return Status.OK_STATUS;
            });
            clearJob.setSystem(true);
            long timeout = Util.isGtk() ? 100 : 0;
            clearJob.schedule(timeout);
            return;
        }
        super.runClearPlaceholderJob(placeholder);
    }

    protected PendingUpdateAdapter createPendingUpdateAdapter() {
        return new ElementPendingUpdateAdapter(this.elementRequested);
    }

    public void addListener(IDeferredQueryTreeListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    private void notifyListener(boolean starting, ElementPendingUpdateAdapter placeholder) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        if (starting) {
            for (IDeferredQueryTreeListener deferredQueryTreeListener : this.listeners) {
                deferredQueryTreeListener.fetchingDeferredChildren(placeholder.element, (Object)placeholder);
            }
        } else {
            for (IDeferredQueryTreeListener deferredQueryTreeListener : this.listeners) {
                deferredQueryTreeListener.finishedFetchingDeferredChildren(placeholder.element, (Object)placeholder);
            }
        }
    }

    class ElementPendingUpdateAdapter
    extends PendingUpdateAdapter {
        Object element;

        ElementPendingUpdateAdapter(Object element) {
            this.element = element;
        }

        public boolean isRemoved() {
            return super.isRemoved();
        }

        public void setRemoved(boolean removedValue) {
            super.setRemoved(removedValue);
        }
    }
}

