/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.AbstractSegmentStoreStatisticsDataProviderTest;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics.StubSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsAspects;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreStatisticsDataProviderTest
extends AbstractSegmentStoreStatisticsDataProviderTest {
    private static final @NonNull List<@NonNull String> EXPECTED_HEADER_LIST = Arrays.asList("Label", "Minimum", "Maximum", "Average", "Std Dev", "Count", "Total", "Min Time Range", "Max Time Range");
    private static final @NonNull List<@NonNull DataType> EXPECTED_DATATYPE_LIST = Arrays.asList(DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.TIME_RANGE, DataType.TIME_RANGE);
    private static final @NonNull List<@NonNull String> EXPECTED_TOOLTIP_LIST = Arrays.asList("", "", "", "", "", "", "", "", "");
    private static final List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_FULL = Arrays.asList(Arrays.asList("", "0", "65.534 \u00b5s", "32.767 \u00b5s", "18.918 \u00b5s", "65535", "2.147 s", "[0,0]", "[65534,131068]"), Arrays.asList("Total", "0", "65.534 \u00b5s", "32.767 \u00b5s", "18.918 \u00b5s", "65535", "2.147 s", "[0,0]", "[65534,131068]"), Arrays.asList("even", "0", "65.534 \u00b5s", "32.767 \u00b5s", "18.919 \u00b5s", "32768", "1.074 s", "[0,0]", "[65534,131068]"), Arrays.asList("odd", "1 ns", "65.533 \u00b5s", "32.767 \u00b5s", "18.918 \u00b5s", "32767", "1.074 s", "[1,2]", "[65533,131066]"));
    private static final @NonNull List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_SELECTION = Arrays.asList(Arrays.asList("Selection", "512 ns", "4.096 \u00b5s", "2.304 \u00b5s", "1.035 \u00b5s", "3585", "8.26 ms", "[512,1024]", "[4096,8192]"), Arrays.asList("even", "512 ns", "4.096 \u00b5s", "2.304 \u00b5s", "1.035 \u00b5s", "1793", "4.131 ms", "[512,1024]", "[4096,8192]"), Arrays.asList("odd", "513 ns", "4.095 \u00b5s", "2.304 \u00b5s", "1.035 \u00b5s", "1792", "4.129 ms", "[513,1026]", "[4095,8190]"));
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder> EXPECTED_STATS_FULL = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("", 0L, -1L, 0L, 65534L, 32767.0, 18918.46, 65535L, 2.147385345E9, 0L, 0L, 65534L, 131068L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Total", 4L, 0L, 0L, 65534L, 32767.0, 18918.46, 65535L, 2.147385345E9, 0L, 0L, 65534L, 131068L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("even", 5L, 4L, 0L, 65534L, 32767.0, 18918.9, 32768L, 1.073709056E9, 0L, 0L, 65534L, 131068L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("odd", 6L, 4L, 1L, 65533L, 32767.0, 18918.32, 32767L, 1.073676289E9, 1L, 2L, 65533L, 131066L));
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder> EXPECTED_STATS_SELECTION = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Selection", 7L, 0L, 512L, 4096L, 2304.0, 1035.04, 3585L, 8259840.0, 512L, 1024L, 4096L, 8192L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("even", 8L, 7L, 512L, 4096L, 2304.0, 1035.48, 1793L, 4131072.0, 512L, 1024L, 4096L, 8192L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("odd", 9L, 7L, 513L, 4095L, 2304.0, 1034.9, 1792L, 4128768.0, 513L, 1026L, 4095L, 8190L));
    private static final List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_WITH_MAPPER_FULL = Arrays.asList(Arrays.asList("My", "0", "65534", "32767.0", "18918.46928268775", "65535", "2.147385345E9", "[0,0]", "[65534,131068]"), Arrays.asList("MyTotal", "0", "65534", "32767.0", "18918.46928268775", "65535", "2.147385345E9", "[0,0]", "[65534,131068]"), Arrays.asList("Myeven", "0", "65534", "32767.0", "18918.90229373787", "32768", "1.073709056E9", "[0,0]", "[65534,131068]"), Arrays.asList("Myodd", "1", "65533", "32767.0", "18918.32494346861", "32767", "1.073676289E9", "[1,2]", "[65533,131066]"));
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder> EXPECTED_STATS_WITH_MAPPER_FULL = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("My", 1L, -1L, 0L, 65534L, 32767.0, 18918.46, 65535L, 2.147385345E9, 0L, 0L, 65534L, 131068L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("MyTotal", 10L, 1L, 0L, 65534L, 32767.0, 18918.46, 65535L, 2.147385345E9, 0L, 0L, 65534L, 131068L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Myeven", 11L, 10L, 0L, 65534L, 32767.0, 18918.9, 32768L, 1.073709056E9, 0L, 0L, 65534L, 131068L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Myodd", 12L, 10L, 1L, 65533L, 32767.0, 18918.32, 32767L, 1.073676289E9, 1L, 2L, 65533L, 131066L));
    private static final String USER_DEFINED_EXTRA_HEADER = "userDefinedHeader";
    private static final String USER_DEFINED_EXTRA_VALUE = "userDefinedValue";
    private static final DataType USER_DEFINED_DATATYPE = DataType.STRING;
    private static final @NonNull List<@NonNull String> EXPECTED_HEADER_LIST_USER_DEFINED = Stream.concat(EXPECTED_HEADER_LIST.stream(), Stream.of("userDefinedHeader")).collect(Collectors.toList());
    private static final @NonNull List<@NonNull DataType> EXPECTED_DATATYPE_LIST_USER_DEFINED = Stream.concat(EXPECTED_DATATYPE_LIST.stream(), Stream.of(USER_DEFINED_DATATYPE)).collect(Collectors.toList());
    private static final @NonNull List<@NonNull String> EXPECTED_TOOLTIP_LIST_USER_DEFINED = Stream.concat(EXPECTED_TOOLTIP_LIST.stream(), Stream.of("")).collect(Collectors.toList());
    private static final List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_FULL_USER_DEFINED = LIST_OF_EXPECTED_LABELS_FULL.stream().map(list -> Stream.concat(list.stream(), Stream.of(USER_DEFINED_EXTRA_VALUE)).collect(Collectors.toList())).collect(Collectors.toList());
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined> EXPECTED_STATS_FULL_USER_DEFINED = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("", 2L, -1L, 0L, 65534L, 32767.0, 18918.46, 65535L, 2.147385345E9, 0L, 0L, 65534L, 131068L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("Total", 13L, 2L, 0L, 65534L, 32767.0, 18918.46, 65535L, 2.147385345E9, 0L, 0L, 65534L, 131068L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("even", 14L, 13L, 0L, 65534L, 32767.0, 18918.9, 32768L, 1.073709056E9, 0L, 0L, 65534L, 131068L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("odd", 15L, 13L, 1L, 65533L, 32767.0, 18918.32, 32767L, 1.073676289E9, 1L, 2L, 65533L, 131066L, "userDefinedValue"));
    private static List<ITableColumnDescriptor> fExpectedDescriptors;
    private static List<ITableColumnDescriptor> fExpectedDescriptorsUserDefined;
    private static SegmentStoreStatisticsDataProvider fTestDataProvider;
    private static SegmentStoreStatisticsDataProvider fTestDataProvider2;
    private static SegmentStoreStatisticsDataProvider fTestDataProviderWithUserDefinedAspect;
    private static SegmentStoreStatisticsDataProvider fTestDataProviderWithModuleError;
    private static TmfXmlTraceStub fTrace;

    @BeforeClass
    public static void init() throws TmfAnalysisException {
        SegmentStoreStatisticsDataProviderTest.resetIds();
        fExpectedDescriptors = new ArrayList<ITableColumnDescriptor>();
        int i = 0;
        while (i < EXPECTED_HEADER_LIST.size()) {
            fExpectedDescriptors.add((ITableColumnDescriptor)new TableColumnDescriptor.Builder().setText(EXPECTED_HEADER_LIST.get(i)).setTooltip(EXPECTED_TOOLTIP_LIST.get(i)).setDataType(EXPECTED_DATATYPE_LIST.get(i)).build());
            ++i;
        }
        fExpectedDescriptorsUserDefined = new ArrayList<ITableColumnDescriptor>();
        i = 0;
        while (i < EXPECTED_HEADER_LIST_USER_DEFINED.size()) {
            fExpectedDescriptorsUserDefined.add((ITableColumnDescriptor)new TableColumnDescriptor.Builder().setText(EXPECTED_HEADER_LIST_USER_DEFINED.get(i)).setTooltip(EXPECTED_TOOLTIP_LIST_USER_DEFINED.get(i)).setDataType(EXPECTED_DATATYPE_LIST_USER_DEFINED.get(i)).build());
            ++i;
        }
        fTrace = new TmfXmlTraceStubNs();
        @NonNull StubSegmentStatisticsAnalysis fixture = SegmentStoreStatisticsDataProviderTest.getValidSegmentStats((ITmfTrace)fTrace);
        TmfXmlTraceStub trace = fTrace;
        Assert.assertNotNull((Object)trace);
        fTestDataProvider = new SegmentStoreStatisticsDataProvider((ITmfTrace)trace, (IStatisticsAnalysis)fixture, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore");
        fTestDataProvider2 = new SegmentStoreStatisticsDataProvider((ITmfTrace)trace, (IStatisticsAnalysis)fixture, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore");
        fTestDataProvider2.setLabelMapper(e -> "My" + e);
        fTestDataProvider2.setMapper(String::valueOf);
        @NonNull IDataAspect<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull SegmentStoreStatisticsAspects.NamedStatistics> userDefinedAspect = new IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics>(){

            public String getName() {
                return SegmentStoreStatisticsDataProviderTest.USER_DEFINED_EXTRA_HEADER;
            }

            public @Nullable Object apply(SegmentStoreStatisticsAspects.NamedStatistics input) {
                return SegmentStoreStatisticsDataProviderTest.USER_DEFINED_EXTRA_VALUE;
            }
        };
        fTestDataProviderWithUserDefinedAspect = new SegmentStoreStatisticsDataProvider((ITmfTrace)trace, (IStatisticsAnalysis)fixture, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore", Arrays.asList(userDefinedAspect));
        fixture = SegmentStoreStatisticsDataProviderTest.getValidSegmentStats((ITmfTrace)fTrace, true);
        fTestDataProviderWithModuleError = new SegmentStoreStatisticsDataProvider((ITmfTrace)trace, (IStatisticsAnalysis)fixture, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore");
    }

    @AfterClass
    public static void cleanup() {
        if (fTestDataProvider != null) {
            fTestDataProvider.dispose();
        }
        if (fTestDataProvider2 != null) {
            fTestDataProvider2.dispose();
        }
        if (fTestDataProviderWithUserDefinedAspect != null) {
            fTestDataProviderWithUserDefinedAspect.dispose();
        }
        if (fTestDataProviderWithModuleError != null) {
            fTestDataProviderWithModuleError.dispose();
        }
        if (fTrace != null) {
            fTrace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeFullRange() {
        HashMap<@NonNull K, @NonNull V> fetchParameters = new HashMap();
        @NonNull @NonNull TmfModelResponse response = fTestDataProvider.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptors, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_FULL, EXPECTED_STATS_FULL, entries, 0, EXPECTED_STATS_FULL.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeSpecificRange() {
        long start = 1024L;
        long end = 4096L;
        FilterTimeQueryFilter filter = new FilterTimeQueryFilter(start, end, 2, true);
        @NonNull @NonNull Map fetchParameters = FetchParametersUtils.filteredTimeQueryToMap((FilterTimeQueryFilter)filter);
        @NonNull @NonNull TmfModelResponse response = fTestDataProvider.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptors, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_FULL, EXPECTED_STATS_FULL, entries, 0, EXPECTED_STATS_FULL.size() + EXPECTED_STATS_SELECTION.size());
        SegmentStoreStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_SELECTION, EXPECTED_STATS_SELECTION, entries, LIST_OF_EXPECTED_LABELS_FULL.size(), EXPECTED_STATS_FULL.size() + EXPECTED_STATS_SELECTION.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeWithMapperFullRange() {
        HashMap<@NonNull K, @NonNull V> fetchParameters = new HashMap();
        @NonNull @NonNull TmfModelResponse response = fTestDataProvider2.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptors, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_WITH_MAPPER_FULL, EXPECTED_STATS_WITH_MAPPER_FULL, entries, 0, EXPECTED_STATS_WITH_MAPPER_FULL.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeWithUserDefinedAspectsFullRange() {
        HashMap<@NonNull K, @NonNull V> fetchParameters = new HashMap();
        @NonNull @NonNull TmfModelResponse response = fTestDataProviderWithUserDefinedAspect.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST_USER_DEFINED.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST_USER_DEFINED, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST_USER_DEFINED.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptorsUserDefined, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreStatisticsDataProviderTest.verifyEntriesWithUserDefinedAspect(LIST_OF_EXPECTED_LABELS_FULL_USER_DEFINED, EXPECTED_STATS_FULL_USER_DEFINED, entries, 0, EXPECTED_STATS_FULL_USER_DEFINED.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testModuleExecutionError() {
        long start = 1024L;
        long end = 4096L;
        FilterTimeQueryFilter filter = new FilterTimeQueryFilter(start, end, 2, true);
        @NonNull @NonNull Map fetchParameters = FetchParametersUtils.filteredTimeQueryToMap((FilterTimeQueryFilter)filter);
        @NonNull @NonNull TmfModelResponse response = fTestDataProviderWithModuleError.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)ITmfResponse.Status.FAILED, (Object)response.getStatus());
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNull((Object)treeModel);
    }

    private static @NonNull StubSegmentStatisticsAnalysis getValidSegmentStats(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        return SegmentStoreStatisticsDataProviderTest.getValidSegmentStats(trace, false);
    }

    private static @NonNull StubSegmentStatisticsAnalysis getValidSegmentStats(@NonNull ITmfTrace trace, final boolean moduleError) throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis(){

            @Override
            public boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
                if (moduleError) {
                    throw new TmfAnalysisException("Failure");
                }
                return super.executeAnalysis(monitor);
            }
        };
        fixture.setTrace(trace);
        fixture.getDependentAnalyses();
        fixture.schedule();
        fixture.waitForCompletion();
        return fixture;
    }
}

