/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty.decoder;

import java.util.HashMap;
import java.util.Map;
import org.vertx.java.core.dns.impl.netty.DnsResource;
import org.vertx.java.core.dns.impl.netty.DnsResponse;
import org.vertx.java.core.dns.impl.netty.decoder.AddressDecoder;
import org.vertx.java.core.dns.impl.netty.decoder.DomainDecoder;
import org.vertx.java.core.dns.impl.netty.decoder.MailExchangerDecoder;
import org.vertx.java.core.dns.impl.netty.decoder.RecordDecoder;
import org.vertx.java.core.dns.impl.netty.decoder.ServiceDecoder;
import org.vertx.java.core.dns.impl.netty.decoder.StartOfAuthorityDecoder;
import org.vertx.java.core.dns.impl.netty.decoder.TextDecoder;

public final class RecordDecoderFactory {
    private static RecordDecoderFactory factory = new RecordDecoderFactory(null);
    private final Map<Integer, RecordDecoder<?>> decoders = new HashMap();

    public static RecordDecoderFactory getFactory() {
        return factory;
    }

    public static void setFactory(RecordDecoderFactory factory) {
        if (factory == null) {
            throw new NullPointerException("Cannot set record decoder factory to null.");
        }
        RecordDecoderFactory.factory = factory;
    }

    public RecordDecoderFactory() {
        this(true, null);
    }

    public RecordDecoderFactory(Map<Integer, RecordDecoder<?>> customDecoders) {
        this(true, customDecoders);
    }

    public RecordDecoderFactory(boolean useDefaultDecoders, Map<Integer, RecordDecoder<?>> customDecoders) {
        if (!useDefaultDecoders && (customDecoders == null || customDecoders.isEmpty())) {
            throw new IllegalStateException("No decoders have been included to be used with this factory.");
        }
        if (useDefaultDecoders) {
            this.decoders.put(1, new AddressDecoder(4));
            this.decoders.put(28, new AddressDecoder(16));
            this.decoders.put(15, new MailExchangerDecoder());
            this.decoders.put(16, new TextDecoder());
            this.decoders.put(33, new ServiceDecoder());
            DomainDecoder decoder = new DomainDecoder();
            this.decoders.put(2, decoder);
            this.decoders.put(5, decoder);
            this.decoders.put(12, decoder);
            this.decoders.put(6, new StartOfAuthorityDecoder());
        }
        if (customDecoders != null) {
            this.decoders.putAll(customDecoders);
        }
    }

    public <T> T decode(int type, DnsResponse response, DnsResource resource) {
        RecordDecoder<?> decoder = this.decoders.get(type);
        if (decoder == null) {
            throw new IllegalStateException("Unsupported resource record type [id: " + type + "].");
        }
        T result = null;
        try {
            result = (T)decoder.decode(response, resource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

