/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.impl.CMap;
import com.hazelcast.query.Expression;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;

public class AddMapIndex
extends AbstractRemotelyProcessable {
    String mapName;
    private Expression expression;
    private boolean ordered;
    private int attributeIndex = -1;
    private transient Throwable error;

    public AddMapIndex() {
    }

    public AddMapIndex(String mapName, Expression expression, boolean ordered) {
        this.mapName = mapName;
        this.expression = expression;
        this.ordered = ordered;
    }

    public AddMapIndex(String mapName, Expression expression, boolean ordered, int attributeIndex) {
        this.mapName = mapName;
        this.attributeIndex = attributeIndex;
        this.setExpression(expression);
        this.setOrdered(ordered);
    }

    public void process() {
        CMap cmap = this.node.concurrentMapManager.getOrCreateMap(this.mapName);
        try {
            cmap.addIndex(this.getExpression(), this.isOrdered(), this.attributeIndex);
        }
        catch (Exception e) {
            this.error = e;
            this.node.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage());
        }
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeBoolean(this.isOrdered());
        out.writeInt(this.attributeIndex);
        AddMapIndex.writeObject(out, this.getExpression());
    }

    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.setOrdered(in.readBoolean());
        this.attributeIndex = in.readInt();
        this.setExpression((Expression)AddMapIndex.readObject(in));
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    public void setAttributeIndex(int attributeIndex) {
        this.attributeIndex = attributeIndex;
    }

    public Throwable getError() {
        return this.error;
    }
}

