/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DateHelper {
    static final String timestampFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    static final String dateFormat = "EEE MMM dd HH:mm:ss zzz yyyy";
    static final String sqlDateFormat = "yyyy-MM-dd";
    static final String sqlTimeFormat = "HH:mm:ss";

    static Date parseDate(String value) {
        try {
            return DateHelper.getUtilDateFormat().parse(value);
        }
        catch (ParseException e) {
            return (Date)DateHelper.throwRuntimeParseException(value, e);
        }
    }

    static Timestamp parseTimeStamp(String value) {
        try {
            return new Timestamp(DateHelper.getTimestampFormat().parse(value).getTime());
        }
        catch (ParseException e) {
            return (Timestamp)DateHelper.throwRuntimeParseException(value, e);
        }
    }

    static java.sql.Date parseSqlDate(String value) {
        try {
            return new java.sql.Date(DateHelper.getSqlDateFormat().parse(value).getTime());
        }
        catch (ParseException e) {
            return (java.sql.Date)DateHelper.throwRuntimeParseException(value, e);
        }
    }

    static Time parseSqlTime(String value) {
        try {
            return new Time(DateHelper.getSqlTimeFormat().parse(value).getTime());
        }
        catch (ParseException e) {
            return (Time)DateHelper.throwRuntimeParseException(value, e);
        }
    }

    static Date tryParse(String value) {
        try {
            return DateHelper.getUtilDateFormat().parse(value);
        }
        catch (Exception ignored) {
            try {
                return DateHelper.getTimestampFormat().parse(value);
            }
            catch (Exception ignored2) {
                try {
                    return DateHelper.getSqlDateFormat().parse(value);
                }
                catch (Exception exception) {
                    return (Date)DateHelper.throwRuntimeParseException(value, null);
                }
            }
        }
    }

    private static <T> T throwRuntimeParseException(String value, Exception e) {
        throw new RuntimeException("Unable to parse date from value: '" + value + "' ! Valid formats are: '" + dateFormat + "', '" + timestampFormat + "' and '" + sqlDateFormat + "'.", e);
    }

    private static DateFormat getTimestampFormat() {
        return new SimpleDateFormat(timestampFormat);
    }

    private static DateFormat getSqlDateFormat() {
        return new SimpleDateFormat(sqlDateFormat);
    }

    private static DateFormat getUtilDateFormat() {
        return new SimpleDateFormat(dateFormat);
    }

    private static DateFormat getSqlTimeFormat() {
        return new SimpleDateFormat(sqlTimeFormat);
    }

    private DateHelper() {
    }
}

