/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class ServerWebSocketImpl
extends WebSocketImplBase
implements ServerWebSocket {
    private final String uri;
    private final String path;
    private final String query;
    private final Runnable connectRunnable;
    private final MultiMap headers;
    Object metric;
    private boolean connected;
    private boolean rejected;

    public ServerWebSocketImpl(VertxInternal vertx, String uri, String path, String query, MultiMap headers, ConnectionBase conn, boolean supportsContinuation, Runnable connectRunnable, int maxWebSocketFrameSize) {
        super(vertx, conn, supportsContinuation, maxWebSocketFrameSize);
        this.uri = uri;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.connectRunnable = connectRunnable;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public synchronized void reject() {
        this.checkClosed();
        if (this.connectRunnable == null) {
            throw new IllegalStateException("Cannot reject websocket on the client side");
        }
        if (this.connected) {
            throw new IllegalStateException("Cannot reject websocket, it has already been written to");
        }
        this.rejected = true;
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.getPeerCertificateChain();
    }

    @Override
    public synchronized void close() {
        this.checkClosed();
        if (this.connectRunnable != null) {
            if (this.rejected) {
                throw new IllegalStateException("Cannot close websocket, it has been rejected");
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        super.close();
    }

    @Override
    public synchronized ServerWebSocket handler(Handler<Buffer> handler) {
        this.checkClosed();
        this.dataHandler = handler;
        return this;
    }

    @Override
    public synchronized ServerWebSocket endHandler(Handler<Void> handler) {
        this.checkClosed();
        this.endHandler = handler;
        return this;
    }

    @Override
    public synchronized ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.checkClosed();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized ServerWebSocket closeHandler(Handler<Void> handler) {
        this.checkClosed();
        this.closeHandler = handler;
        return this;
    }

    @Override
    public synchronized ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.checkClosed();
        this.frameHandler = handler;
        return this;
    }

    @Override
    public synchronized ServerWebSocket pause() {
        this.checkClosed();
        this.conn.doPause();
        return this;
    }

    @Override
    public synchronized ServerWebSocket resume() {
        this.checkClosed();
        this.conn.doResume();
        return this;
    }

    @Override
    public synchronized ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.checkClosed();
        this.conn.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        this.checkClosed();
        return this.conn.isNotWritable();
    }

    @Override
    public ServerWebSocket write(Buffer data) {
        this.writeFrame(WebSocketFrame.binaryFrame(data, true));
        return this;
    }

    @Override
    public synchronized ServerWebSocket drainHandler(Handler<Void> handler) {
        this.checkClosed();
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized ServerWebSocket writeFrame(WebSocketFrame frame) {
        if (this.connectRunnable != null) {
            if (this.rejected) {
                throw new IllegalStateException("Cannot write to websocket, it has been rejected");
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        super.writeFrameInternal(frame);
        return this;
    }

    @Override
    public ServerWebSocket writeFinalTextFrame(String text) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true));
    }

    @Override
    public ServerWebSocket writeFinalBinaryFrame(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    @Override
    public synchronized ServerWebSocket writeBinaryMessage(Buffer data) {
        this.checkClosed();
        this.writeMessageInternal(data);
        return this;
    }

    private void connect() {
        this.connectRunnable.run();
        this.connected = true;
    }

    synchronized void connectNow() {
        if (!this.connected && !this.rejected) {
            this.connect();
        }
    }

    synchronized boolean isRejected() {
        return this.rejected;
    }
}

