/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxThread;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class VertxThreadFactory
implements ThreadFactory {
    private static final Object FOO = new Object();
    private static Map<VertxThread, Object> weakMap = new WeakHashMap<VertxThread, Object>();
    private final String prefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final BlockedThreadChecker checker;
    private final boolean worker;

    private static synchronized void addToMap(VertxThread thread) {
        weakMap.put(thread, FOO);
    }

    VertxThreadFactory(String prefix, BlockedThreadChecker checker, boolean worker) {
        this.prefix = prefix;
        this.checker = checker;
        this.worker = worker;
    }

    public static synchronized void unsetContext(ContextImpl ctx) {
        for (VertxThread thread : weakMap.keySet()) {
            if (thread.getContext() != ctx) continue;
            thread.setContext(null);
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        VertxThread t = new VertxThread(runnable, this.prefix + this.threadCount.getAndIncrement(), this.worker);
        if (this.checker != null) {
            this.checker.registerThread(t);
        }
        VertxThreadFactory.addToMap(t);
        return t;
    }
}

