/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;

public final class BundleManifestUtils {
    public static BundleManifest readBundleManifest(File file, String ... archiveSuffixes) throws IOException, SecurityException {
        String fileName = file.getName();
        Reader reader = null;
        if (file.isDirectory()) {
            File manifestFile = new File(file, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                reader = BundleManifestUtils.manifestReaderFromFile(manifestFile);
            }
        } else {
            String[] stringArray = archiveSuffixes;
            int n = archiveSuffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (fileName.endsWith(suffix)) {
                    reader = BundleManifestUtils.manifestReaderFromJar(file);
                }
                ++n2;
            }
        }
        if (reader != null) {
            return BundleManifestFactory.createBundleManifest((Reader)reader);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Reader manifestReaderFromJar(File file) throws IOException, SecurityException {
        JarEntry entry;
        JarFile jar;
        block12: {
            jar = null;
            jar = new JarFile(file);
            entry = jar.getJarEntry("META-INF/MANIFEST.MF");
            if (entry != null) break block12;
            if (jar == null) return null;
            try {
                jar.close();
                return null;
            }
            catch (IOException ioe) {
                throw new IOException(String.format("Failed to close file '%s'.", file.getName()), ioe);
            }
        }
        StringWriter writer = new StringWriter();
        FileCopyUtils.copy((Reader)new InputStreamReader(jar.getInputStream(entry)), (Writer)writer);
        StringReader stringReader = new StringReader(writer.toString());
        if (jar == null) return stringReader;
        try {
            jar.close();
            return stringReader;
        }
        catch (IOException ioe) {
            throw new IOException(String.format("Failed to close file '%s'.", file.getName()), ioe);
        }
        catch (SecurityException se) {
            try {
                throw new SecurityException(String.format("Failed to read manifest from file '%s'.", file.getName()), se);
                catch (Exception e) {
                    throw new IOException(String.format("Failed to read manifest from file '%s'.", file.getName()), e);
                }
            }
            catch (Throwable throwable) {
                if (jar == null) throw throwable;
                try {
                    jar.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new IOException(String.format("Failed to close file '%s'.", file.getName()), ioe);
                }
            }
        }
    }

    private static Reader manifestReaderFromFile(File file) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            FileCopyUtils.copy((Reader)new InputStreamReader(new FileInputStream(file)), (Writer)writer);
            return new StringReader(writer.toString());
        }
        catch (IOException ioe) {
            throw new IOException("Failed to create reader for manifest file.", ioe);
        }
    }
}

