/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.impl;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.dump.impl.DumpContributorPublisher;
import org.eclipse.virgo.medic.dump.impl.StandardDumpContributorResolver;
import org.eclipse.virgo.medic.dump.impl.StandardDumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.EventLoggerFactory;
import org.eclipse.virgo.medic.eventlog.impl.BundleSearchingPropertyResourceBundleResolver;
import org.eclipse.virgo.medic.eventlog.impl.EventLoggerServiceFactory;
import org.eclipse.virgo.medic.eventlog.impl.StandardLocaleResolver;
import org.eclipse.virgo.medic.eventlog.impl.logback.LogBackEventLoggerFactory;
import org.eclipse.virgo.medic.impl.config.ConfigurationChangeListener;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.log.ConfigurationPublicationFailedException;
import org.eclipse.virgo.medic.log.DelegatingPrintStream;
import org.eclipse.virgo.medic.log.LoggingConfigurationPublisher;
import org.eclipse.virgo.medic.log.impl.CallingBundleResolver;
import org.eclipse.virgo.medic.log.impl.ClassSelector;
import org.eclipse.virgo.medic.log.impl.ExecutionStackAccessor;
import org.eclipse.virgo.medic.log.impl.LoggingLevel;
import org.eclipse.virgo.medic.log.impl.LoggingPrintStreamWrapper;
import org.eclipse.virgo.medic.log.impl.PackageNameFilteringClassSelector;
import org.eclipse.virgo.medic.log.impl.SecurityManagerExecutionStackAccessor;
import org.eclipse.virgo.medic.log.impl.StandardCallingBundleResolver;
import org.eclipse.virgo.medic.log.impl.StandardDelegatingPrintStream;
import org.eclipse.virgo.medic.log.impl.config.BundleResourceConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.CompositeConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.ConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.ServiceRegistryConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.StandardLoggingConfigurationPublisher;
import org.eclipse.virgo.medic.log.impl.logback.DelegatingContextSelector;
import org.eclipse.virgo.medic.log.impl.logback.JoranLoggerContextConfigurer;
import org.eclipse.virgo.medic.log.impl.logback.StandardContextSelectorDelegate;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogController
implements ConfigurationChangeListener {
    private static final String LOGGER_NAME_SYSERR = "System.err";
    private static final String LOGGER_NAME_SYSOUT = "System.out";
    private static final String LOGGER_NAME_SYSERR_DELEGATE = "delegating.System.err";
    private static final String LOGGER_NAME_SYSOUT_DELEGATE = "delegating.System.out";
    private static final String PROPERTY_MEDIC_CONFIG_PATH = "org.eclipse.virgo.medic.log.config.path";
    private static final String DEFAULT_CONTEXT_SELECTOR = "ch.qos.logback.classic.selector.DefaultContextSelector";
    private static final String PROPERTY_LOGBACK_CONTEXT_SELECTOR = "logback.ContextSelector";
    private volatile StandardDumpGenerator dumpGenerator;
    private volatile LogBackEventLoggerFactory eventLoggerFactory;
    private volatile DumpContributorPublisher dumpContributorPublisher;
    private volatile PrintStream sysOut = System.out;
    private volatile PrintStream sysErr = System.err;
    private PrintStream delegatingSysOut = new StandardDelegatingPrintStream(System.out);
    private PrintStream delegatingSysErr = new StandardDelegatingPrintStream(System.err);
    private ServiceRegistration<?> delegatingSysOutRegistration;
    private ServiceRegistration<?> delegatingSysErrRegistration;
    private ServiceRegistration<?> sysOutRegistration;
    private ServiceRegistration<?> sysErrRegistration;
    private volatile ExecutionStackAccessor stackAccessor;
    private volatile ConsoleHandler javaConsoleHandler;
    private static final List<String> DEFAULT_LOGGING_PACKAGES = Arrays.asList("org.apache.commons.logging", "org.apache.log4j", "org.slf4j", "org.slf4j.impl", "org.eclipse.virgo.medic.log", "org.eclipse.virgo.medic.log.impl", "org.eclipse.virgo.medic.log.impl.logback");
    private BundleContext bundleContext;
    private ConfigurationProvider configurationProvider;
    private ServiceRegistrationTracker registrationTracker;

    public LogController(BundleContext ctx, ConfigurationProvider cfgProvider, ServiceRegistrationTracker regTracker) throws ConfigurationPublicationFailedException {
        this.bundleContext = ctx;
        this.configurationProvider = cfgProvider;
        this.registrationTracker = regTracker;
        StandardContextSelectorDelegate delegate = LogController.createContextSelectorDelegate(this.bundleContext);
        this.registrationTracker.track(this.bundleContext.registerService(BundleListener.class.getName(), (Object)delegate, null));
        DelegatingContextSelector.setDelegate(delegate);
        StandardLoggingConfigurationPublisher loggingConfigurationPublisher = new StandardLoggingConfigurationPublisher(this.bundleContext);
        this.registrationTracker.track(this.bundleContext.registerService(LoggingConfigurationPublisher.class.getName(), (Object)loggingConfigurationPublisher, null));
        this.publishDefaultConfigurationIfAvailable(this.bundleContext, loggingConfigurationPublisher);
        System.setProperty(PROPERTY_LOGBACK_CONTEXT_SELECTOR, DelegatingContextSelector.class.getName());
        this.stackAccessor = new SecurityManagerExecutionStackAccessor();
        this.sysOut = System.out;
        this.sysErr = System.err;
    }

    public void dumpStart() {
        this.dumpGenerator = new StandardDumpGenerator(new StandardDumpContributorResolver(this.bundleContext), this.configurationProvider, this.eventLoggerFactory.createEventLogger(this.bundleContext.getBundle()));
        this.registrationTracker.track(this.bundleContext.registerService(DumpGenerator.class.getName(), (Object)this.dumpGenerator, null));
        this.dumpContributorPublisher = new DumpContributorPublisher(this.bundleContext);
        this.dumpContributorPublisher.publishDumpContributors();
    }

    public void dumpStop() {
        if (this.dumpGenerator != null) {
            this.dumpGenerator.close();
        }
        if (this.dumpContributorPublisher != null) {
            this.dumpContributorPublisher.retractDumpContributors();
        }
    }

    public void logStart() throws ConfigurationPublicationFailedException {
        Dictionary<String, String> configuration = this.configurationProvider.getConfiguration();
        SLF4JBridgeHandler.install();
        this.updateLogConfiguration(configuration);
    }

    public void logStop() {
        System.setProperty(PROPERTY_LOGBACK_CONTEXT_SELECTOR, DEFAULT_CONTEXT_SELECTOR);
        DelegatingContextSelector.setDelegate(null);
        if (this.sysOut != null) {
            System.setOut(this.sysOut);
        }
        if (this.sysErr != null) {
            System.setErr(this.sysErr);
        }
        SLF4JBridgeHandler.uninstall();
        this.enableJulConsoleLogger();
    }

    private void enableJulConsoleLogger() {
        if (this.javaConsoleHandler != null) {
            this.getJavaRootLogger().addHandler(this.javaConsoleHandler);
        }
    }

    private void disableJulConsoleHandler() {
        Handler[] handlers;
        Logger rootLogger = this.getJavaRootLogger();
        Handler[] handlerArray = handlers = rootLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof ConsoleHandler) {
                this.javaConsoleHandler = (ConsoleHandler)handler;
                rootLogger.removeHandler(handler);
            }
            ++n2;
        }
    }

    public void eventLogStart() {
        this.eventLoggerFactory = this.createFactory(this.bundleContext);
        EventLoggerServiceFactory serviceFactory = new EventLoggerServiceFactory(this.eventLoggerFactory);
        this.registrationTracker.track(this.bundleContext.registerService(EventLoggerFactory.class.getName(), (Object)this.eventLoggerFactory, null));
        this.registrationTracker.track(this.bundleContext.registerService(EventLogger.class.getName(), (Object)serviceFactory, null));
    }

    private PrintStream wrapPrintStream(PrintStream printStream, String loggerName, LoggingLevel loggingLevel, ExecutionStackAccessor stackAccessor, ConfigurationProvider configurationProvider, String configurationProperty) {
        LoggingPrintStreamWrapper wrapper = new LoggingPrintStreamWrapper(printStream, loggerName, loggingLevel, stackAccessor, configurationProvider, configurationProperty);
        return wrapper;
    }

    private ServiceRegistration<?> publishPrintStream(PrintStream printStream, String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("org.eclipse.virgo.medic.log.printStream", name);
        ServiceRegistration registration = this.bundleContext.registerService(PrintStream.class.getName(), (Object)printStream, properties);
        this.registrationTracker.track(registration);
        return registration;
    }

    private ServiceRegistration<?> publishDelegatingPrintStream(PrintStream printStream, String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("org.eclipse.virgo.medic.log.printStream", name);
        String[] classes = new String[]{DelegatingPrintStream.class.getName()};
        ServiceRegistration delegatingPrintStreamRegistration = this.bundleContext.registerService(classes, (Object)printStream, properties);
        this.registrationTracker.track(delegatingPrintStreamRegistration);
        return delegatingPrintStreamRegistration;
    }

    private void publishDefaultConfigurationIfAvailable(BundleContext context, StandardLoggingConfigurationPublisher publisher) throws ConfigurationPublicationFailedException {
        File logConfigFile;
        String logConfigPath = context.getProperty(PROPERTY_MEDIC_CONFIG_PATH);
        if (logConfigPath != null && (logConfigFile = new File(logConfigPath)).exists()) {
            publisher.publishDefaultConfiguration(new File(logConfigPath));
        }
    }

    private static StandardContextSelectorDelegate createContextSelectorDelegate(BundleContext bundleContext) {
        ConfigurationLocator configurationLocator = LogController.createConfigurationLocator(bundleContext);
        CallingBundleResolver loggingCallerLocator = LogController.createLoggingCallerLocator();
        JoranLoggerContextConfigurer loggerContextConfigurer = new JoranLoggerContextConfigurer();
        return new StandardContextSelectorDelegate(loggingCallerLocator, configurationLocator, bundleContext.getBundle(), loggerContextConfigurer);
    }

    private static ConfigurationLocator createConfigurationLocator(BundleContext bundleContext) {
        return new CompositeConfigurationLocator(new ServiceRegistryConfigurationLocator(bundleContext), new BundleResourceConfigurationLocator());
    }

    private static CallingBundleResolver createLoggingCallerLocator() {
        ClassSelector classSelector = LogController.createClassSelector();
        ExecutionStackAccessor executionStackAccessor = LogController.createExecutionStackAccessor();
        return new StandardCallingBundleResolver(executionStackAccessor, classSelector);
    }

    private static ClassSelector createClassSelector() {
        return new PackageNameFilteringClassSelector(DEFAULT_LOGGING_PACKAGES);
    }

    private static ExecutionStackAccessor createExecutionStackAccessor() {
        return new SecurityManagerExecutionStackAccessor();
    }

    private LogBackEventLoggerFactory createFactory(BundleContext context) {
        BundleSearchingPropertyResourceBundleResolver resourceBundleResolver = new BundleSearchingPropertyResourceBundleResolver();
        return new LogBackEventLoggerFactory(resourceBundleResolver, new StandardLocaleResolver(), context.getBundle());
    }

    private Logger getJavaRootLogger() {
        return Logger.getLogger("");
    }

    @Override
    public void configurationChanged(ConfigurationProvider provider) {
        Dictionary<String, String> configuration = this.configurationProvider.getConfiguration();
        this.updateLogConfiguration(configuration);
    }

    private synchronized void updateLogConfiguration(Dictionary<String, String> configuration) {
        if (Boolean.valueOf(configuration.get("log.wrapSysOut")).booleanValue()) {
            this.delegatingSysOutRegistration = this.publishDelegatingPrintStream(this.delegatingSysOut, LOGGER_NAME_SYSOUT_DELEGATE);
            this.sysOutRegistration = this.publishPrintStream(this.sysOut, LOGGER_NAME_SYSOUT);
            System.setOut(this.wrapPrintStream(System.out, LOGGER_NAME_SYSOUT, LoggingLevel.INFO, this.stackAccessor, this.configurationProvider, "log.wrapSysOut"));
        } else {
            if (this.delegatingSysOutRegistration != null) {
                this.registrationTracker.unregister(this.delegatingSysOutRegistration);
                this.delegatingSysOutRegistration = null;
            }
            if (this.sysOutRegistration != null) {
                this.registrationTracker.unregister(this.sysOutRegistration);
                this.sysOutRegistration = null;
            }
            System.setOut(this.delegatingSysOut);
        }
        if (Boolean.valueOf(configuration.get("log.wrapSysErr")).booleanValue()) {
            this.delegatingSysErrRegistration = this.publishDelegatingPrintStream(this.delegatingSysErr, LOGGER_NAME_SYSERR_DELEGATE);
            this.sysErrRegistration = this.publishPrintStream(this.sysErr, LOGGER_NAME_SYSERR);
            System.setErr(this.wrapPrintStream(System.err, LOGGER_NAME_SYSERR, LoggingLevel.ERROR, this.stackAccessor, this.configurationProvider, "log.wrapSysErr"));
        } else {
            if (this.delegatingSysErrRegistration != null) {
                this.registrationTracker.unregister(this.delegatingSysErrRegistration);
                this.delegatingSysErrRegistration = null;
            }
            if (this.sysErrRegistration != null) {
                this.registrationTracker.unregister(this.sysErrRegistration);
                this.sysErrRegistration = null;
            }
            System.setErr(this.delegatingSysErr);
        }
        if (Boolean.valueOf(configuration.get("log.jul.consoleHandler")).booleanValue()) {
            this.enableJulConsoleLogger();
        } else {
            this.disableJulConsoleHandler();
        }
    }
}

