/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.entry;

import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.entry.AbstractEntry;
import org.eclipse.jetty.util.resource.Resource;

public class KeystoreEntry
extends AbstractEntry {
    private String url;
    private String type;
    private KeyStore keystore;

    public KeyStore toKeyStore() throws PolicyException {
        if (this.keystore != null && !this.isDirty()) {
            return this.keystore;
        }
        try {
            this.keystore = KeyStore.getInstance(this.type);
            URL keyStoreLocation = new URL(this.url);
            Resource r = Resource.newResource((URL)keyStoreLocation);
            InputStream istream = r.getInputStream();
            this.keystore.load(istream, null);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        return this.keystore;
    }

    @Override
    public void expand(PolicyContext context) throws PolicyException {
        this.url = context.evaluate(this.url);
        this.setExpanded(true);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

