/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.launcher;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.osgi.launcher.FrameworkBuilder;
import org.eclipse.virgo.osgi.launcher.parser.ArgumentParser;
import org.eclipse.virgo.osgi.launcher.parser.BundleEntry;
import org.eclipse.virgo.osgi.launcher.parser.LaunchCommand;
import org.osgi.framework.BundleException;

public class Launcher {
    private static final char UNRECOGNIZED_ARGUMENT_SEPARATOR = ',';
    private static final String FRAMEWORK_PROPERTY_UNRECOGNIZED_ARGUMENTS = "org.eclipse.virgo.osgi.launcher.unrecognizedArguments";
    private static final String SYSTEM_PROPERTY_TMPDIR = "java.io.tmpdir";

    public static void main(String[] args) throws IOException {
        BundleEntry[] bundleDeclarations;
        Launcher.ensureTmpDirExists();
        ArgumentParser parser = new ArgumentParser();
        LaunchCommand command = parser.parse(args);
        FrameworkBuilder builder = new FrameworkBuilder(command.getConfigProperties());
        BundleEntry[] bundleEntryArray = bundleDeclarations = command.getBundleEntries();
        int n = bundleDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            BundleEntry bundleDeclaration = bundleEntryArray[n2];
            builder.addBundle(bundleDeclaration.getURI());
            ++n2;
        }
        Map<String, String> declaredProperties = command.getDeclaredProperties();
        for (Map.Entry<String, String> entry : declaredProperties.entrySet()) {
            builder.addFrameworkProperty(entry.getKey(), entry.getValue());
        }
        builder.addFrameworkProperty(FRAMEWORK_PROPERTY_UNRECOGNIZED_ARGUMENTS, Launcher.createUnrecognizedArgumentsProperty(command));
        try {
            builder.start();
        }
        catch (BundleException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static void ensureTmpDirExists() throws IOException {
        File tmpDir;
        String tmpDirProperty = System.getProperty(SYSTEM_PROPERTY_TMPDIR);
        if (tmpDirProperty != null && !(tmpDir = new File(tmpDirProperty)).isDirectory() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to create tmp directory '" + tmpDir.getAbsolutePath() + "'");
        }
    }

    private static String createUnrecognizedArgumentsProperty(LaunchCommand launchCommand) {
        List<String> unrecognizedArguments = launchCommand.getUnrecognizedArguments();
        StringBuilder propertyBuilder = new StringBuilder();
        int i = 0;
        while (i < unrecognizedArguments.size()) {
            propertyBuilder.append(unrecognizedArguments.get(i));
            if (i + 1 < unrecognizedArguments.size()) {
                propertyBuilder.append(',');
            }
            ++i;
        }
        return propertyBuilder.toString();
    }
}

