/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle.test;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javassist.ClassPool;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenWebBeansTestMetaDataDiscoveryService
extends AbstractMetaDataDiscovery {
    @Override
    protected void configure() {
    }

    public void deployClasses(Collection<Class<?>> classes) {
        if (classes != null) {
            for (Class<?> clazz : classes) {
                this.addBeanClass(clazz);
            }
        }
    }

    public void deployXMLs(Collection<String> xmls) {
        if (xmls != null) {
            for (String url : xmls) {
                try {
                    this.addBeanXml(new URL(url));
                }
                catch (MalformedURLException e) {
                    throw new WebBeansDeploymentException("could not convert to URL: " + url, e);
                }
            }
        }
    }

    private void addBeanClass(Class<?> clazz) {
        Asserts.assertNotNull(clazz);
        URL url = ClassPool.getDefault().find(clazz.getName());
        try {
            this.getAnnotationDB().scanClass(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addBeanXml(URL url) {
        Asserts.assertNotNull(url);
        this.addWebBeansXmlLocation(url);
    }
}

