/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.config.internal.StandardConfigurationExporter;
import org.eclipse.virgo.nano.core.ConfigurationExporter;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.util.common.IterableEnumeration;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigurationPublisher {
    private final Logger LOGGER;
    private final ConfigurationAdmin configAdmin;
    private final PropertiesSource[] sources;
    private static final String KERNEL_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel";
    private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    ConfigurationPublisher(ConfigurationAdmin configAdmin, PropertiesSource ... sources) {
        try {
            this.LOGGER = LoggerFactory.getLogger(this.getClass());
            this.configAdmin = configAdmin;
            this.sources = sources == null ? new PropertiesSource[]{} : sources;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void publishConfigurations() throws IOException {
        try {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                PropertiesSource[] propertiesSourceArray = this.sources;
                int n = this.sources.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertiesSource source = propertiesSourceArray[n2];
                    Map<String, Properties> configurationProperties = source.getConfigurationProperties();
                    if (configurationProperties != null) {
                        for (Map.Entry<String, Properties> entry : configurationProperties.entrySet()) {
                            this.populateConfigurationWithProperties(entry.getKey(), entry.getValue());
                        }
                    }
                    ++n2;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void registerConfigurationExporterService(@NonNull BundleContext bundleContext) throws IOException {
        BundleContext bundleContext2 = bundleContext;
        try {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                void context;
                NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8(bundleContext2);
                ConfigurationExporter configurationExporter = this.createConfigurationExporterService();
                context.registerService(ConfigurationExporter.class, (Object)configurationExporter, null);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private ConfigurationExporter createConfigurationExporterService() throws IOException {
        try {
            StandardConfigurationExporter standardConfigurationExporter;
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                StandardConfigurationExporter configurationExporter;
                Configuration kernelregionConfiguration = this.configAdmin.getConfiguration(KERNEL_REGION_CONFIGURATION_PID);
                Configuration userregionConfiguration = this.configAdmin.getConfiguration(USER_REGION_CONFIGURATION_PID);
                standardConfigurationExporter = configurationExporter = new StandardConfigurationExporter(userregionConfiguration, kernelregionConfiguration);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return standardConfigurationExporter;
        }
        catch (Throwable throwable) {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void populateConfigurationWithProperties(@NonNull String string, @NonNull Properties properties) throws IOException {
        Properties properties2 = properties;
        String string2 = string;
        try {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                void properties3;
                void pid;
                NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8(string2);
                NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82(properties2);
                Configuration config = this.getConfiguration((String)pid, (Properties)properties3);
                Hashtable configProperties = config.getProperties();
                if (configProperties == null) {
                    configProperties = new Hashtable();
                }
                for (Object key : new IterableEnumeration(properties3.keys())) {
                    Object value = properties3.get(key);
                    ((Dictionary)configProperties).put(key, value);
                }
                try {
                    config.update(configProperties);
                }
                catch (RuntimeException e) {
                    this.LOGGER.error(String.format("Failed to update configuration for pid '%s'", pid), (Throwable)e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private Configuration getConfiguration(String pid, Properties properties) throws IOException {
        try {
            Configuration result = null;
            String factoryPid = properties.getProperty("service.factoryPid");
            result = StringUtils.hasText((String)factoryPid) ? this.configAdmin.createFactoryConfiguration(factoryPid, null) : this.configAdmin.getConfiguration(pid, null);
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("ConfigurationPublisher.java", Class.forName("org.eclipse.virgo.nano.config.internal.ConfigurationPublisher"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "publishConfigurations", "org.eclipse.virgo.nano.config.internal.ConfigurationPublisher", "", "", "java.io.IOException:", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "registerConfigurationExporterService", "org.eclipse.virgo.nano.config.internal.ConfigurationPublisher", "org.osgi.framework.BundleContext:", "context:", "java.io.IOException:", "void"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createConfigurationExporterService", "org.eclipse.virgo.nano.config.internal.ConfigurationPublisher", "", "", "java.io.IOException:", "org.eclipse.virgo.nano.core.ConfigurationExporter"), 80);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "populateConfigurationWithProperties", "org.eclipse.virgo.nano.config.internal.ConfigurationPublisher", "java.lang.String:java.util.Properties:", "pid:properties:", "java.io.IOException:", "void"), 89);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.config.internal.ConfigurationPublisher");
    }
}

