/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.ddlgen.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.OutputMode;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GenerationOutputModeWizardPage
extends WizardPage {
    GenerationOutputModeGroup outputModeGroup;

    public GenerationOutputModeWizardPage() {
        super("Database Schema");
        this.setTitle(EclipseLinkUiMessages.GenerationOutputModeWizardPage_title);
        this.setMessage(EclipseLinkUiMessages.GenerationOutputModeWizardPage_desc);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.outputModeGroup = new GenerationOutputModeGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    public OutputMode getOutputMode() {
        return this.outputModeGroup.getOutputMode();
    }

    class GenerationOutputModeGroup {
        private OutputMode outputMode;
        private final Button databaseButton;
        private final Button sqlScriptButton;
        private final Button bothButton;

        private GenerationOutputModeGroup(Composite parent) {
            Group outputModeGroup = new Group(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            outputModeGroup.setLayout((Layout)layout);
            outputModeGroup.setLayoutData((Object)new GridData(768));
            outputModeGroup.setText(EclipseLinkUiMessages.GenerationOutputModeWizardPage_generationOutputMode);
            SelectionListener outputModeButtonListener = this.buildOutputModeRadioButtonListener();
            this.databaseButton = this.buildRadioButton((Composite)outputModeGroup, EclipseLinkUiMessages.OutputModeComposite_database, outputModeButtonListener, 3);
            this.sqlScriptButton = this.buildRadioButton((Composite)outputModeGroup, EclipseLinkUiMessages.OutputModeComposite_sql_script, outputModeButtonListener, 3);
            this.bothButton = this.buildRadioButton((Composite)outputModeGroup, EclipseLinkUiMessages.OutputModeComposite_both, outputModeButtonListener, 3);
            this.databaseButton.setSelection(true);
            this.outputModeButtonChanged();
        }

        private SelectionListener buildOutputModeRadioButtonListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    GenerationOutputModeGroup.this.outputModeButtonChanged();
                }
            };
        }

        private void outputModeButtonChanged() {
            if (this.databaseButton.getSelection()) {
                this.outputMode = OutputMode.database;
            } else if (this.sqlScriptButton.getSelection()) {
                this.outputMode = OutputMode.sql_script;
            } else if (this.bothButton.getSelection()) {
                this.outputMode = OutputMode.both;
            }
        }

        private Button buildRadioButton(Composite parent, String text, SelectionListener listener, int horizontalSpan) {
            Button radioButton = new Button(parent, 16);
            GridData gridData = new GridData();
            gridData.horizontalSpan = horizontalSpan;
            radioButton.setLayoutData((Object)gridData);
            radioButton.setText(text);
            radioButton.addSelectionListener(listener);
            return radioButton;
        }

        private OutputMode getOutputMode() {
            return this.outputMode;
        }
    }
}

