/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.caching;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.CacheType;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Caching;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.CachingEntity;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCachingPropertyComposite
extends Pane<CachingEntity> {
    public EntityCachingPropertyComposite(Pane<? extends Caching> parentComposite, PropertyValueModel<CachingEntity> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentComposite, subjectHolder, enabledModel, parent);
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlCachingTab_cacheTypeLabel);
        new CacheTypeComboViewer(container);
        this.addLabel(container, EclipseLinkUiMessages.CacheSizeComposite_cacheSize);
        this.addCacheSizeCombo(container);
        TriStateCheckBox sharedCacheCheckBox = this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheLabel, this.buildSharedCacheHolder(), this.buildSharedCacheStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_CACHING);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        sharedCacheCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private String getSubjectName() {
        return ((CachingEntity)this.getSubjectHolder().getValue()).getName();
    }

    private Caching getSubjectParent() {
        return ((CachingEntity)this.getSubjectHolder().getValue()).getParent();
    }

    private void addCacheSizeCombo(Composite container) {
        new IntegerCombo<CachingEntity>((Pane)this, container){

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_CACHING;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Caching, Integer>(EntityCachingPropertyComposite.this.buildCachingHolder(), new String[]{"cacheSizeDefault"}){

                    protected Integer buildValue_() {
                        Integer value = ((Caching)this.subject).getCacheSizeDefault();
                        if (value == null) {
                            value = ((Caching)this.subject).getDefaultCacheSizeDefault();
                        }
                        return value;
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<CachingEntity, Integer>(this.getSubjectHolder(), new String[]{"cacheSize"}){

                    protected Integer buildValue_() {
                        return EntityCachingPropertyComposite.this.getSubjectParent().getCacheSizeOf(EntityCachingPropertyComposite.this.getSubjectName());
                    }

                    protected void setValue_(Integer value) {
                        EntityCachingPropertyComposite.this.getSubjectParent().setCacheSizeOf(EntityCachingPropertyComposite.this.getSubjectName(), value);
                    }
                };
            }
        };
    }

    private PropertyValueModel<Caching> buildCachingHolder() {
        return new TransformationPropertyValueModel<CachingEntity, Caching>(this.getSubjectHolder()){

            protected Caching transform_(CachingEntity value) {
                return value.getParent();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildSharedCacheHolder() {
        return new PropertyAspectAdapter<CachingEntity, Boolean>(this.getSubjectHolder(), new String[]{"sharedCache"}){

            protected Boolean buildValue_() {
                return EntityCachingPropertyComposite.this.getSubjectParent().getSharedCacheOf(EntityCachingPropertyComposite.this.getSubjectName());
            }

            protected void setValue_(Boolean value) {
                EntityCachingPropertyComposite.this.getSubjectParent().setSharedCacheOf(EntityCachingPropertyComposite.this.getSubjectName(), value);
            }
        };
    }

    private PropertyValueModel<String> buildSharedCacheStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultAndNonDefaultSharedCacheHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlCachingTab_defaultSharedCacheLabel, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlCachingTab_sharedCacheLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheHolder() {
        return new ListPropertyValueModelAdapter<Boolean>(this.buildDefaultAndNonDefaultSharedCacheListHolder()){

            protected Boolean buildValue() {
                if (this.listModel.size() == 1) {
                    return (Boolean)this.listModel.listIterator().next();
                }
                return null;
            }
        };
    }

    private ListValueModel<Boolean> buildDefaultAndNonDefaultSharedCacheListHolder() {
        ArrayList<ListValueModel<Boolean>> holders = new ArrayList<ListValueModel<Boolean>>(2);
        holders.add(this.buildSharedCacheListHolder());
        holders.add(this.buildDefaultSharedCacheListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private ListValueModel<Boolean> buildSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildSharedCacheHolder());
    }

    private ListValueModel<Boolean> buildDefaultSharedCacheListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSharedCacheHolder());
    }

    private PropertyValueModel<Boolean> buildDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<Caching, Boolean>(this.buildCachingHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                Boolean value = ((Caching)this.subject).getSharedCacheDefault();
                if (value == null) {
                    value = ((Caching)this.subject).getDefaultSharedCacheDefault();
                }
                return value;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheTypeComboViewer
    extends EnumFormComboViewer<CachingEntity, CacheType> {
        private CacheTypeComboViewer(Composite parent) {
            super((Pane)EntityCachingPropertyComposite.this, parent);
        }

        protected void addPropertyNames(Collection<String> propertyNames) {
            super.addPropertyNames(propertyNames);
            propertyNames.add("cacheType");
        }

        private PropertyValueModel<Caching> buildCachingHolder() {
            return new TransformationPropertyValueModel<CachingEntity, Caching>(this.getSubjectHolder()){

                protected Caching transform_(CachingEntity value) {
                    return value.getParent();
                }
            };
        }

        private PropertyValueModel<CacheType> buildDefaultCacheTypeHolder() {
            return new PropertyAspectAdapter<Caching, CacheType>(this.buildCachingHolder(), new String[]{"cacheTypeDefault"}){

                protected CacheType buildValue_() {
                    CacheType cacheType = ((Caching)this.subject).getCacheTypeDefault();
                    if (cacheType == null) {
                        cacheType = ((Caching)this.subject).getDefaultCacheTypeDefault();
                    }
                    return cacheType;
                }
            };
        }

        private PropertyChangeListener buildDefaultCachingTypePropertyChangeListener() {
            return new SWTPropertyChangeListenerWrapper(this.buildDefaultCachingTypePropertyChangeListener_());
        }

        private PropertyChangeListener buildDefaultCachingTypePropertyChangeListener_() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent e) {
                    if (e.getNewValue() != null && !CacheTypeComboViewer.this.getControl().isDisposed()) {
                        CacheTypeComboViewer.this.doPopulate();
                    }
                }
            };
        }

        protected CacheType[] getChoices() {
            return CacheType.values();
        }

        protected CacheType getDefaultValue() {
            return EntityCachingPropertyComposite.this.getSubjectParent().getDefaultCacheType();
        }

        protected String displayString(CacheType value) {
            switch (value) {
                case full: {
                    return EclipseLinkUiMessages.CacheTypeComposite_full;
                }
                case weak: {
                    return EclipseLinkUiMessages.CacheTypeComposite_weak;
                }
                case soft: {
                    return EclipseLinkUiMessages.CacheTypeComposite_soft;
                }
                case soft_weak: {
                    return EclipseLinkUiMessages.CacheTypeComposite_soft_weak;
                }
                case hard_weak: {
                    return EclipseLinkUiMessages.CacheTypeComposite_hard_weak;
                }
                case none: {
                    return EclipseLinkUiMessages.CacheTypeComposite_none;
                }
            }
            throw new IllegalStateException();
        }

        protected void doPopulate() {
            super.doPopulate();
        }

        protected CacheType getValue() {
            return EntityCachingPropertyComposite.this.getSubjectParent().getCacheTypeOf(EntityCachingPropertyComposite.this.getSubjectName());
        }

        protected void initialize() {
            super.initialize();
            PropertyValueModel<CacheType> defaultCacheTypeHolder = this.buildDefaultCacheTypeHolder();
            defaultCacheTypeHolder.addPropertyChangeListener("value", this.buildDefaultCachingTypePropertyChangeListener());
        }

        protected void setValue(CacheType value) {
            EntityCachingPropertyComposite.this.getSubjectParent().setCacheTypeOf(EntityCachingPropertyComposite.this.getSubjectName(), value);
        }

        protected boolean sortChoices() {
            return false;
        }

        protected String getHelpId() {
            return EclipseLinkHelpContextIds.PERSISTENCE_CACHING;
        }
    }
}

