/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.caching;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Caching;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.CachingEntity;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.caching.EntityCachingPropertyComposite;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.plugin.JptNoSQLEclipseLinkUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite<T extends Caching>
extends Pane<T> {
    private ModifiableCollectionValueModel<CachingEntity> selectedEntitiesModel;
    private PropertyValueModel<CachingEntity> selectedEntityModel;

    public EntityListComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedEntitiesModel = this.buildSelectedEntitiesModel();
        this.selectedEntityModel = this.buildSelectedEntityModel((CollectionValueModel<CachingEntity>)this.selectedEntitiesModel);
    }

    private ModifiableCollectionValueModel<CachingEntity> buildSelectedEntitiesModel() {
        return new SimpleCollectionValueModel();
    }

    private PropertyValueModel<CachingEntity> buildSelectedEntityModel(CollectionValueModel<CachingEntity> selectedEntitiesModel) {
        return new CollectionPropertyValueModelAdapter<CachingEntity, CachingEntity>(selectedEntitiesModel){

            protected CachingEntity buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (CachingEntity)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, EclipseLinkUiMessages.CachingEntityListComposite_groupTitle);
    }

    protected void initializeLayout(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.selectedEntitiesModel, this.buildEntityLabelProvider(), EclipseLinkHelpContextIds.PERSISTENCE_CACHING);
        new EntityCachingPropertyComposite(this, this.selectedEntityModel, this.buildPaneEnablerModel(this.selectedEntityModel), container);
    }

    private AddRemovePane.Adapter<CachingEntity> buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter<CachingEntity>(){

            public CachingEntity addNewItem() {
                return EntityListComposite.this.addEntity();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<CachingEntity> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<CachingEntity> selectedItemsModel) {
                CachingEntity cachingEntity = (CachingEntity)selectedItemsModel.iterator().next();
                ((Caching)EntityListComposite.this.getSubject()).removeEntity(cachingEntity.getName());
            }
        };
    }

    private CachingEntity addEntity() {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Caching)this.getSubject()).entityExists(entityName)) {
                return ((Caching)this.getSubject()).addEntity(entityName);
            }
        }
        return null;
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        Entity entity = ((Caching)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CachingEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CachingEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        return ((Caching)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                CachingEntity entityCaching = (CachingEntity)element;
                return entityCaching.getName();
            }
        };
    }

    private ListValueModel<CachingEntity> buildEntitiesListHolder() {
        return new ListAspectAdapter<Caching, CachingEntity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterable<CachingEntity> getListIterable() {
                return ((Caching)this.subject).getEntities();
            }

            protected int size_() {
                return ((Caching)this.subject).getEntitiesSize();
            }
        };
    }

    private PropertyValueModel<Boolean> buildPaneEnablerModel(PropertyValueModel<CachingEntity> entityHolder) {
        return new TransformationPropertyValueModel<CachingEntity, Boolean>(entityHolder){

            protected Boolean transform_(CachingEntity value) {
                return value.entityNameIsValid();
            }
        };
    }
}

