/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.customization;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Customization;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.CustomizationEntity;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.plugin.JptNoSQLEclipseLinkUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite
extends Pane<Customization> {
    private ModifiableCollectionValueModel<CustomizationEntity> selectedEntitiesModel;
    private PropertyValueModel<CustomizationEntity> selectedEntityModel;

    public EntityListComposite(Pane<? extends Customization> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedEntitiesModel = this.buildSelectedEntitiesModel();
        this.selectedEntityModel = this.buildSelectedEntityModel((CollectionValueModel<CustomizationEntity>)this.selectedEntitiesModel);
    }

    private ModifiableCollectionValueModel<CustomizationEntity> buildSelectedEntitiesModel() {
        return new SimpleCollectionValueModel();
    }

    private PropertyValueModel<CustomizationEntity> buildSelectedEntityModel(CollectionValueModel<CustomizationEntity> selectedEntitiesModel) {
        return new CollectionPropertyValueModelAdapter<CustomizationEntity, CustomizationEntity>(selectedEntitiesModel){

            protected CustomizationEntity buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (CustomizationEntity)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, EclipseLinkUiMessages.CustomizationEntityListComposite_groupTitle);
    }

    protected void initializeLayout(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.selectedEntitiesModel, this.buildEntityLabelProvider(), EclipseLinkHelpContextIds.PERSISTENCE_CUSTOMIZATION);
        Hyperlink customizationHyperlink = this.addHyperlink(container, EclipseLinkUiMessages.PersistenceXmlCustomizationTab_customizerLabel);
        this.initializeClassChooser(container, customizationHyperlink);
    }

    private AddRemovePane.Adapter<CustomizationEntity> buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter<CustomizationEntity>(){

            public CustomizationEntity addNewItem() {
                return EntityListComposite.this.addEntity();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<CustomizationEntity> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<CustomizationEntity> selectedItemsModel) {
                CustomizationEntity customizationEntity = (CustomizationEntity)selectedItemsModel.iterator().next();
                ((Customization)EntityListComposite.this.getSubject()).removeEntity(customizationEntity.getName());
            }
        };
    }

    private CustomizationEntity addEntity() {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Customization)this.getSubject()).entityExists(entityName)) {
                return ((Customization)this.getSubject()).addEntity(entityName);
            }
        }
        return null;
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        Entity entity = ((Customization)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CustomizationEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CustomizationEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        return ((Customization)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                CustomizationEntity entityCustomization = (CustomizationEntity)element;
                return entityCustomization.getName();
            }
        };
    }

    private ModifiablePropertyValueModel<CustomizationEntity> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<CustomizationEntity> buildEntitiesListHolder() {
        return new ListAspectAdapter<Customization, CustomizationEntity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterable<CustomizationEntity> getListIterable() {
                return ((Customization)this.subject).getEntities();
            }

            protected int size_() {
                return ((Customization)this.subject).getEntitiesSize();
            }
        };
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(PropertyValueModel<CustomizationEntity> entityHolder) {
        return new TransformationPropertyValueModel<CustomizationEntity, Boolean>(entityHolder){

            protected Boolean transform_(CustomizationEntity value) {
                return value.entityNameIsValid();
            }
        };
    }

    private ClassChooserPane<CustomizationEntity> initializeClassChooser(Composite container, Hyperlink hyperlink) {
        return new ClassChooserPane<CustomizationEntity>((Pane)this, this.selectedEntityModel, this.buildPaneEnablerHolder(this.selectedEntityModel), container, hyperlink){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<CustomizationEntity, String>(this.getSubjectHolder(), new String[]{"descriptorCustomizer"}){

                    protected String buildValue_() {
                        return this.getSubjectParent().getDescriptorCustomizerOf(this.getSubjectName());
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        this.getSubjectParent().setDescriptorCustomizerOf(this.getSubjectName(), value);
                    }
                };
            }

            protected String getClassName() {
                return this.getSubjectParent().getDescriptorCustomizerOf(this.getSubjectName());
            }

            protected IJavaProject getJavaProject() {
                return this.getSubjectParent().getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                this.getSubjectParent().setDescriptorCustomizerOf(this.getSubjectName(), className);
            }

            protected String getSuperInterfaceName() {
                return "org.eclipse.persistence.config.DescriptorCustomizer";
            }

            private String getSubjectName() {
                return ((CustomizationEntity)this.getSubjectHolder().getValue()).getName();
            }

            private Customization getSubjectParent() {
                return ((CustomizationEntity)this.getSubjectHolder().getValue()).getParent();
            }
        };
    }
}

