/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.v2_0.persistence;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Logging2_0;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.LoggingLevel;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.options.EclipseLinkLoggingComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLogging2_0Composite
extends EclipseLinkLoggingComposite<Logging2_0> {
    private static final String DEFAULT_PROPERTY = "categoriesDefaultLoggingLevel";

    public EclipseLinkLogging2_0Composite(Pane<?> parent, PropertyValueModel<Logging2_0> subjectModel, Composite parentComposite) {
        super(parent, subjectModel, parentComposite);
    }

    @Override
    protected void initializeLayout(Composite container) {
        super.initializeLayout(container);
        Section loggingLevelComposite = this.addCategoryLoggingLevelSection(container);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        loggingLevelComposite.setLayoutData((Object)gridData);
    }

    protected Section addCategoryLoggingLevelSection(Composite container) {
        final Section loggingSection = this.getWidgetFactory().createSection(container, 2);
        loggingSection.setText(EclipseLinkUiMessages.PersistenceXmlLoggingTab_categoryLoggingLevelSectionTitle);
        loggingSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && loggingSection.getClient() == null) {
                    loggingSection.setClient((Control)EclipseLinkLogging2_0Composite.this.createCategoryLoggingLevelClient(loggingSection));
                }
            }
        });
        return loggingSection;
    }

    protected Composite createCategoryLoggingLevelClient(Section loggingSection) {
        Composite loggingClient = this.getWidgetFactory().createComposite((Composite)loggingSection);
        loggingClient.setLayout((Layout)new GridLayout(2, false));
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_cacheLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "cacheLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_connectionLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "connectionLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_dmsLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "dmsLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_ejbLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "ejbLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_ejb_or_metadataLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "ejb_or_metadataLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_eventLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "eventLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_jpa_metamodelLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "jpa_metamodelLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_propagationLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "propagationLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_propertiesLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "propertiesLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_queryLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "queryLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_sequencingLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "sequencingLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_serverLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "serverLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_sqlLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "sqlLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_transactionLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "transactionLoggingLevel");
        this.addLabel(loggingClient, EclipseLinkUiMessages.PersistenceXmlLoggingTab_weaverLoggingLevelLabel);
        this.addLoggingLevelCombo(loggingClient, "weaverLoggingLevel");
        return loggingClient;
    }

    @Override
    protected void logPropertiesComposite(Composite container) {
        super.logPropertiesComposite(container);
        TriStateCheckBox connectionCheckBox = this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMessages.PersistenceXmlLoggingTab_connectionLabel, this.buildConnectionHolder(), this.buildConnectionStringHolder(), null);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        connectionCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private ModifiablePropertyValueModel<Boolean> buildConnectionHolder() {
        return new PropertyAspectAdapter<Logging2_0, Boolean>(this.getSubjectHolder(), new String[]{"connection"}){

            protected Boolean buildValue_() {
                return ((Logging2_0)this.subject).getConnection();
            }

            protected void setValue_(Boolean value) {
                ((Logging2_0)this.subject).setConnection(value);
            }
        };
    }

    private PropertyValueModel<String> buildConnectionStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultConnectionHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_connectionLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlLoggingTab_connectionLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultConnectionHolder() {
        return new PropertyAspectAdapter<Logging2_0, Boolean>(this.getSubjectHolder(), new String[]{"connection"}){

            protected Boolean buildValue_() {
                if (((Logging2_0)this.subject).getConnection() != null) {
                    return null;
                }
                return ((Logging2_0)this.subject).getDefaultConnection();
            }
        };
    }

    protected EnumFormComboViewer<Logging2_0, LoggingLevel> addLoggingLevelCombo(Composite container, final String category) {
        return new EnumFormComboViewer<Logging2_0, LoggingLevel>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add(EclipseLinkLogging2_0Composite.DEFAULT_PROPERTY);
                propertyNames.add("sqlLoggingLevel");
                propertyNames.add("transactionLoggingLevel");
                propertyNames.add("eventLoggingLevel");
                propertyNames.add("connectionLoggingLevel");
                propertyNames.add("queryLoggingLevel");
                propertyNames.add("cacheLoggingLevel");
                propertyNames.add("propagationLoggingLevel");
                propertyNames.add("sequencingLoggingLevel");
                propertyNames.add("ejbLoggingLevel");
                propertyNames.add("dmsLoggingLevel");
                propertyNames.add("ejb_or_metadataLoggingLevel");
                propertyNames.add("jpa_metamodelLoggingLevel");
                propertyNames.add("weaverLoggingLevel");
                propertyNames.add("propertiesLoggingLevel");
                propertyNames.add("serverLoggingLevel");
            }

            protected LoggingLevel[] getChoices() {
                return LoggingLevel.values();
            }

            protected boolean sortChoices() {
                return false;
            }

            protected LoggingLevel getDefaultValue() {
                return ((Logging2_0)this.getSubject()).getCategoriesDefaultLevel();
            }

            protected String displayString(LoggingLevel value) {
                switch (value) {
                    case all: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_all;
                    }
                    case config: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_config;
                    }
                    case fine: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_fine;
                    }
                    case finer: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_finer;
                    }
                    case finest: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_finest;
                    }
                    case info: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_info;
                    }
                    case off: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_off;
                    }
                    case severe: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_severe;
                    }
                    case warning: {
                        return EclipseLinkUiMessages.EclipseLinkCategoryLoggingLevelComposite_warning;
                    }
                }
                throw new IllegalStateException();
            }

            protected LoggingLevel getValue() {
                return ((Logging2_0)this.getSubject()).getLevel(category);
            }

            protected void setValue(LoggingLevel value) {
                ((Logging2_0)this.getSubject()).setLevel(category, value);
            }

            protected void propertyChanged(String propertyName) {
                if (propertyName != category && propertyName != EclipseLinkLogging2_0Composite.DEFAULT_PROPERTY) {
                    return;
                }
                super.propertyChanged(propertyName);
            }
        };
    }
}

