/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.jpa.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.gen.internal.BaseEntityGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.DatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.plugin.JptNoSQLEclipseLinkUiPlugin;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.CollectionSelectorWizardPage;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.DynamicDefaultTableGenerationWizardPage;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.JptJpaEclipseLinkUiEntityGenMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.NoSqlConnectionConfigPage;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.PromptEclipseLinkProjectWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.persistence.tools.gen.nosql.mongo.MongoEntityGenerator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class GenerateDynamicEntitiesFromNoSqlDb
extends Wizard
implements INewWizard {
    protected JpaProject jpaProject;
    protected IStructuredSelection selection;
    private ORMGenCustomizer customizer = null;
    private PromptEclipseLinkProjectWizardPage projectPage;
    private NoSqlConnectionConfigPage noSqlConnectionConfigPage;
    private CollectionSelectorWizardPage collectionSelectorWizardPage;
    protected DynamicDefaultTableGenerationWizardPage dynamicDefaultTableGenerationPage;
    protected final ResourceManager resourceManager;
    static final String DATABASE_NAME_PROPERTY = "databaseNameText";
    static final String HOST_PROPERTY = "hostText";
    static final String PORT_PROPERTY = "portText";
    static final String ROW_SAMPLE_SIZE_PROPERTY = "rowSampleSizeText";
    static final String PACKAGE_NAME = "packageName";
    private static final String HELP_CONTEXT_ID = String.valueOf(JptNoSQLEclipseLinkUiPlugin.instance().getPluginID()) + ".GenerateEntitiesFromSchemaWizard";

    public GenerateDynamicEntitiesFromNoSqlDb() {
        this.resourceManager = this.buildResourceManager();
        this.setWindowTitle(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_generateEntities);
    }

    public GenerateDynamicEntitiesFromNoSqlDb(JpaProject jpaProject, IStructuredSelection selection) {
        this.jpaProject = jpaProject;
        this.selection = selection;
        this.resourceManager = this.buildResourceManager();
        this.setWindowTitle(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_generateEntities);
    }

    protected ResourceManager buildResourceManager() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench != null ? jpaWorkbench.buildLocalResourceManager() : new LocalResourceManager(JFaceResources.getResources((Display)this.getWorkbench().getDisplay()));
    }

    protected JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)PlatformTools.getAdapter((Object)this.getWorkbench(), JpaWorkbench.class);
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public IWizardPage getStartingPage() {
        if (this.projectPage != null) {
            if (this.dynamicDefaultTableGenerationPage != null) {
                return this.dynamicDefaultTableGenerationPage;
            }
            return this.projectPage;
        }
        return super.getStartingPage();
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        if (this.jpaProject == null && this.selection != null) {
            this.jpaProject = this.getJpaProjectFromSelection(this.selection);
        }
        if (!this.projectIsValidSelection(this.jpaProject)) {
            this.projectPage = this.buildProjectWizardPage();
            this.addPage((IWizardPage)this.projectPage);
            return;
        }
        this.addMainPages();
    }

    protected JpaProject getJpaProjectFromSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IProject) {
            return this.getJpaProject((IProject)firstElement);
        }
        if (firstElement instanceof IJavaElement) {
            IProject project = ((IJavaElement)firstElement).getJavaProject().getProject();
            return this.getJpaProject(project);
        }
        return null;
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    protected void addMainPages() {
        this.createORMGenCustomizer(null);
        this.noSqlConnectionConfigPage = new NoSqlConnectionConfigPage();
        this.addPage((IWizardPage)this.noSqlConnectionConfigPage);
        this.collectionSelectorWizardPage = new CollectionSelectorWizardPage(this.jpaProject, this.resourceManager, true);
        this.addPage((IWizardPage)this.collectionSelectorWizardPage);
        this.dynamicDefaultTableGenerationPage = new DynamicDefaultTableGenerationWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.dynamicDefaultTableGenerationPage);
        this.dynamicDefaultTableGenerationPage.init(this.selection);
    }

    protected String getCustomizationFileName() {
        return "org.eclipse.jpt.nosql.gen.dynamic";
    }

    public boolean performFinish() {
        if (this.jpaProject == null) {
            return true;
        }
        if (this.customizer == null) {
            return false;
        }
        try {
            this.customizer.setDatabaseAnnotationNameBuilder(this.buildDatabaseAnnotationNameBuilder());
            this.customizer.save();
        }
        catch (IOException e) {
            JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
        }
        OverwriteConfirmer overwriteConfirmer = null;
        if (GenerateDynamicEntitiesFromNoSqlDb.showOverwriteWarning()) {
            overwriteConfirmer = new OverwriteConfirmer();
        }
        this.scheduleGenerateEntitiesJob(overwriteConfirmer);
        return true;
    }

    private DatabaseAnnotationNameBuilder buildDatabaseAnnotationNameBuilder() {
        return new LocalDatabaseAnnotationNameBuilder(this.jpaProject.getJpaPlatform().getEntityGeneratorDatabaseAnnotationNameBuilder());
    }

    protected void scheduleGenerateEntitiesJob(OverwriteConfirmer overwriteConfirmer) {
        GenerateEntitiesJob genEntitiesJob = new GenerateEntitiesJob(this.jpaProject, this.getCustomizer(), this.dynamicDefaultTableGenerationPage.getPackageText(), overwriteConfirmer, true);
        genEntitiesJob.schedule();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object sel = selection.getFirstElement();
        if (sel instanceof IResource) {
            JpaProject jpaProj;
            IProject proj = ((IResource)sel).getProject();
            this.jpaProject = jpaProj = this.getJpaProject(proj);
        } else if (sel instanceof IPackageFragmentRoot) {
            JpaProject jpaProj;
            IPackageFragmentRoot root = (IPackageFragmentRoot)sel;
            IProject proj = root.getJavaProject().getProject();
            this.jpaProject = jpaProj = this.getJpaProject(proj);
        } else if (sel instanceof IPackageFragment) {
            JpaProject jpaProj;
            IPackageFragment frag = (IPackageFragment)sel;
            IProject proj = frag.getJavaProject().getProject();
            this.jpaProject = jpaProj = this.getJpaProject(proj);
        }
        this.selection = selection;
        this.setWindowTitle(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_generateEntities);
    }

    protected PromptEclipseLinkProjectWizardPage buildProjectWizardPage() {
        return new PromptEclipseLinkProjectWizardPage(HELP_CONTEXT_ID);
    }

    public void setJpaProject(JpaProject jpaProject) {
        if (!this.projectIsValidSelection(this.jpaProject)) {
            this.jpaProject = jpaProject;
            IWizardPage currentPage = this.getContainer().getCurrentPage();
            if (this.projectPage != null && currentPage.equals((Object)this.projectPage)) {
                this.addMainPages();
            }
        }
    }

    protected boolean projectIsValidSelection(JpaProject jpaProj) {
        return this.jpaProject != null && jpaProj.getJpaPlatform().getConfig().getGroupConfig().getId().equals("eclipselink_nosql");
    }

    public ORMGenCustomizer createORMGenCustomizer(Schema schema) {
        JpaPlatform jpaPlatform = this.jpaProject.getJpaPlatform();
        ORMGenCustomizer obj = (ORMGenCustomizer)PlatformTools.getAdapter((Object)jpaPlatform, ORMGenCustomizer.class);
        if (obj != null) {
            this.customizer = obj;
            this.customizer.init(this.getCustomizationFile(), schema);
        } else {
            this.customizer = new BaseEntityGenCustomizer();
            this.customizer.init(this.getCustomizationFile(), schema);
        }
        ORMGenTable newDefaultTable = this.getCustomizer().createGenTable(null);
        if (this.selection != null && this.selection.getFirstElement() instanceof IPackageFragment) {
            IPackageFragment packageFrag = (IPackageFragment)this.selection.getFirstElement();
            newDefaultTable.setPackage(packageFrag.getElementName());
            for (IPackageFragmentRoot root : JDTTools.getJavaSourceFolders((IJavaProject)this.jpaProject.getJavaProject())) {
                String srcFolder = root.getPath().toPortableString();
                if (!packageFrag.getPath().toPortableString().startsWith(String.valueOf(srcFolder) + '/')) continue;
                newDefaultTable.setSourceFolder(srcFolder.substring(1));
            }
        } else if (newDefaultTable.getPackage().equals("")) {
            newDefaultTable.setPackage(JpaPreferences.getEntityGenDefaultPackageName((IProject)this.jpaProject.getProject()));
        }
        this.customizer.setPlatformVersion(this.getJpaProject().getJpaPlatform().getJpaVersion().getVersion());
        return this.customizer;
    }

    public ORMGenCustomizer getCustomizer() {
        return this.customizer;
    }

    private File getCustomizationFile() {
        String projectPath = this.jpaProject.getProject().getLocation().toPortableString();
        File genDir = new File(String.valueOf(projectPath) + "/.settings");
        genDir.mkdirs();
        return new File(genDir, this.getCustomizationFileName());
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public static boolean showOverwriteWarning() {
        return OptionalMessageDialog.isDialogEnabled((String)"dontShowOverwriteEntitesFromSchemas.warning");
    }

    public static class GenerateEntitiesJob
    extends WorkspaceJob {
        final JpaProject jpaProject;
        final ORMGenCustomizer customizer;
        final String packageName;
        final OverwriteConfirmer confirmer;
        final boolean generateXml;

        public GenerateEntitiesJob(JpaProject jpaProject, ORMGenCustomizer customizer, String packageName, OverwriteConfirmer confirmer, boolean generateXml) {
            super(JptJpaUiMessages.EntitiesGenerator_jobName);
            this.customizer = customizer;
            this.packageName = packageName;
            this.jpaProject = jpaProject;
            this.confirmer = confirmer;
            this.generateXml = generateXml;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)jpaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                byte[] content;
                IFile mappingFile;
                MongoEntityGenerator generator = new MongoEntityGenerator(this.getCustomizerProperty(GenerateDynamicEntitiesFromNoSqlDb.HOST_PROPERTY), Integer.parseInt(this.getCustomizerProperty(GenerateDynamicEntitiesFromNoSqlDb.PORT_PROPERTY)), this.getCustomizerProperty(GenerateDynamicEntitiesFromNoSqlDb.DATABASE_NAME_PROPERTY), Integer.parseInt(this.getCustomizerProperty(GenerateDynamicEntitiesFromNoSqlDb.ROW_SAMPLE_SIZE_PROPERTY)));
                String xmlFileContents = generator.generateXML((Collection)this.customizer.getTableNames(), this.packageName);
                String xmlMappingFileLocation = this.customizer.getXmlMappingFile();
                JptXmlResource jpaXmlResource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(xmlMappingFileLocation));
                if (jpaXmlResource != null) {
                    mappingFile = jpaXmlResource.getFile();
                } else {
                    IProject project = this.jpaProject.getProject();
                    IContainer container = ((ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class)).getDefaultLocation();
                    mappingFile = container.getFile((IPath)new Path(xmlMappingFileLocation.substring(xmlMappingFileLocation.lastIndexOf("/"))));
                }
                if (mappingFile.exists()) {
                    content = xmlFileContents.toString().getBytes(mappingFile.getCharset());
                    mappingFile.setContents((InputStream)new ByteArrayInputStream(content), false, true, null);
                } else {
                    content = xmlFileContents.toString().getBytes(mappingFile.getCharset());
                    this.createFile(mappingFile, new ByteArrayInputStream(content));
                }
                this.format((IProgressMonitor)new NullProgressMonitor(), mappingFile);
                mappingFile.refreshLocal(1, null);
                OpenXmlMappingFileJob openXmlMappingFileJob = new OpenXmlMappingFileJob(this.jpaProject, mappingFile);
                openXmlMappingFileJob.schedule();
            }
            catch (UnknownHostException uhe) {
                JptNoSQLEclipseLinkUiPlugin.instance().logError(uhe, uhe.getMessage());
            }
            catch (CoreException ce) {
                JptNoSQLEclipseLinkUiPlugin.instance().logError(ce, ce.getMessage());
            }
            catch (UnsupportedEncodingException uee) {
                JptNoSQLEclipseLinkUiPlugin.instance().logError(uee, uee.getMessage());
            }
            return Status.OK_STATUS;
        }

        private String getCustomizerProperty(String propertyName) {
            return this.customizer.getProperty(propertyName, null, null);
        }

        public void createFile(IFile file, InputStream contents) throws CoreException {
            file.create(contents, false, null);
        }

        protected void format(IProgressMonitor monitor, IFile file) {
            if (monitor == null || monitor.isCanceled()) {
                return;
            }
            try {
                IContentType contentType;
                IStructuredFormatProcessor formatProcessor;
                monitor.beginTask("", 100);
                IContentDescription contentDescription = file.getContentDescription();
                monitor.worked(5);
                if (!(contentDescription == null || (formatProcessor = this.getFormatProcessor((contentType = contentDescription.getContentType()).getId())) == null || monitor != null && monitor.isCanceled())) {
                    String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_3, (Object[])new String[]{file.getFullPath().toString().substring(1)});
                    monitor.subTask(message);
                    formatProcessor.setProgressMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 95));
                    formatProcessor.formatFile(file);
                }
                monitor.done();
            }
            catch (MalformedInputExceptionWithDetail e) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_5, (Object[])new String[]{file.getFullPath().toString()});
                JptNoSQLEclipseLinkUiPlugin.instance().logError(message, new Object[]{e});
            }
            catch (IOException e) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
                JptNoSQLEclipseLinkUiPlugin.instance().logError(message, new Object[]{e});
            }
            catch (CoreException e) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
                JptNoSQLEclipseLinkUiPlugin.instance().logError(message, new Object[]{e});
            }
        }

        protected IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
            return FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentTypeId);
        }
    }

    static class LocalDatabaseAnnotationNameBuilder
    implements DatabaseAnnotationNameBuilder {
        private EntityGeneratorDatabaseAnnotationNameBuilder builder;

        LocalDatabaseAnnotationNameBuilder(EntityGeneratorDatabaseAnnotationNameBuilder builder) {
            this.builder = builder;
        }

        public String buildTableAnnotationName(String entityName, Table table) {
            return this.builder.buildTableAnnotationName(entityName, table);
        }

        public String buildColumnAnnotationName(String attributeName, Column column) {
            return this.builder.buildColumnAnnotationName(attributeName, column);
        }

        public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
            return this.builder.buildJoinColumnAnnotationName(attributeName, foreignKey);
        }

        public String buildJoinColumnAnnotationName(Column column) {
            return this.builder.buildJoinColumnAnnotationName(column);
        }

        public String buildJoinTableAnnotationName(Table table) {
            return this.builder.buildJoinTableAnnotationName(table);
        }
    }

    public static class OpenXmlMappingFileJob
    extends WorkspaceJob {
        private final JpaProject jpaProject;
        private final IFile mappingFile;

        public OpenXmlMappingFileJob(JpaProject jpaProject, IFile mappingFile) {
            super("Open XML File");
            this.jpaProject = jpaProject;
            this.mappingFile = mappingFile;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)jpaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                this.postGeneration(this.jpaProject, this.mappingFile);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CoreException(JptNoSQLEclipseLinkUiPlugin.instance().buildErrorStatus());
            }
            return Status.OK_STATUS;
        }

        private void postGeneration(JpaProject jpaProject, IFile mappingFile) throws InvocationTargetException {
            try {
                this.openEditor(mappingFile);
            }
            catch (Exception cantOpen) {
                throw new InvocationTargetException(cantOpen);
            }
        }

        private void openEditor(final IFile file) {
            if (file != null) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                        catch (PartInitException e) {
                            JptNoSQLEclipseLinkUiPlugin.instance().logError(e);
                        }
                    }
                });
            }
        }
    }

    public static class OverwriteConfirmer
    implements org.eclipse.jpt.jpa.gen.internal.OverwriteConfirmer {
        private boolean overwriteAll = false;
        private boolean skipAll = false;

        OverwriteConfirmer() {
        }

        public boolean overwrite(String className) {
            if (this.overwriteAll) {
                return true;
            }
            if (this.skipAll) {
                return false;
            }
            return this.promptUser(className);
        }

        private boolean promptUser(final String className) {
            final boolean[] ret = new boolean[1];
            SWTUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(Display.getCurrent().getActiveShell(), className);
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        OverwriteConfirmer.this.skipAll = true;
                        ret[0] = false;
                        return;
                    }
                    if (dialog.yes()) {
                        ret[0] = true;
                    }
                    if (dialog.yesToAll()) {
                        OverwriteConfirmer.this.overwriteAll = true;
                        ret[0] = true;
                    }
                    if (dialog.no()) {
                        ret[0] = false;
                    }
                    if (dialog.noToAll()) {
                        OverwriteConfirmer.this.skipAll = true;
                        ret[0] = false;
                    }
                }
            });
            return ret[0];
        }
    }

    static class OverwriteConfirmerDialog
    extends OptionalMessageDialog {
        private boolean yes = false;
        private boolean yesToAll = false;
        private boolean no = false;
        private boolean noToAll = false;
        private static final String ID = "dontShowOverwriteEntitesFromSchemas.warning";

        OverwriteConfirmerDialog(Shell parent, String className) {
            super(ID, parent, JptJpaUiMessages.OverwriteConfirmerDialog_title, NLS.bind((String)JptJpaUiMessages.OverwriteConfirmerDialog_text, (Object)className), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.yesPressed();
                    break;
                }
                case 4: {
                    this.yesToAllPressed();
                    break;
                }
                case 3: {
                    this.noPressed();
                    break;
                }
                case 21: {
                    this.noToAllPressed();
                    break;
                }
                case 1: {
                    this.cancelPressed();
                    break;
                }
            }
        }

        private void yesPressed() {
            this.yes = true;
            this.setReturnCode(0);
            this.close();
        }

        private void yesToAllPressed() {
            this.yesToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noPressed() {
            this.no = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noToAllPressed() {
            this.noToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        boolean yes() {
            return this.yes;
        }

        boolean yesToAll() {
            return this.yesToAll;
        }

        boolean no() {
            return this.no;
        }

        boolean noToAll() {
            return this.noToAll;
        }
    }
}

