/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConverterClassConverter;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmEclipseLinkConverterClassConverter<X extends XmlNamedConverter>
extends OrmEclipseLinkConverter<X>
implements EclipseLinkConverterClassConverter {
    private String converterClass = this.getXmlConverterClass();
    private String fullyQualifiedConverterClass;

    public OrmEclipseLinkConverterClassConverter(JpaContextNode parent, X xmlConverter) {
        super(parent, xmlConverter);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(this.getXmlConverterClass());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedConverterClass(this.buildFullyQualifiedConverterClass());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        this.setConverterClass_(converterClass);
        this.setXmlConverterClass(converterClass);
    }

    protected void setConverterClass_(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    @Override
    public String getFullyQualifiedConverterClass() {
        return this.fullyQualifiedConverterClass;
    }

    protected void setFullyQualifiedConverterClass(String converterClass) {
        String old = this.fullyQualifiedConverterClass;
        this.fullyQualifiedConverterClass = converterClass;
        this.firePropertyChanged("fullyQualifiedConverterClass", old, converterClass);
    }

    protected String buildFullyQualifiedConverterClass() {
        return this.getMappingFileRoot().qualify(this.converterClass);
    }

    protected JavaResourceAbstractType getConverterJavaResourceType() {
        if (this.fullyQualifiedConverterClass == null) {
            return null;
        }
        return this.getJpaProject().getJavaResourceType(this.fullyQualifiedConverterClass);
    }

    protected abstract String getXmlConverterClass();

    protected abstract void setXmlConverterClass(String var1);

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConverterClass(messages);
    }

    protected void validateConverterClass(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", (JpaNode)this, this.getConverterClassTextRange()));
            return;
        }
        IType converterJdtType = JDTTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedConverterClass());
        if (converterJdtType == null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.getFullyQualifiedConverterClass()}, (JpaNode)this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassImplementsInterface(this.getEclipseLinkConverterInterface())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, this.getEclipseLinkConverterInterfaceErrorMessage(), new String[]{this.getFullyQualifiedConverterClass()}, (JpaNode)this, this.getConverterClassTextRange()));
        }
    }

    protected abstract String getEclipseLinkConverterInterface();

    protected abstract String getEclipseLinkConverterInterfaceErrorMessage();

    protected boolean typeImplementsInterface(String typeName, String interfaceName) {
        return typeName != null && JDTTools.typeIsSubType((IJavaProject)this.getJavaProject(), (String)typeName, (String)interfaceName);
    }

    protected boolean converterClassImplementsInterface(String interfaceName) {
        return this.typeImplementsInterface(this.getFullyQualifiedConverterClass(), interfaceName);
    }

    protected TextRange getConverterClassTextRange() {
        return this.getValidationTextRange(this.getXmlConverterClassTextRange());
    }

    protected abstract TextRange getXmlConverterClassTextRange();

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return super.isEquivalentTo(node) && this.isEquivalentTo((EclipseLinkConverterClassConverter)node);
    }

    protected boolean isEquivalentTo(EclipseLinkConverterClassConverter converter) {
        return ObjectTools.equals((Object)this.getFullyQualifiedConverterClass(), (Object)converter.getFullyQualifiedConverterClass());
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected abstract ReplaceEdit createRenameEdit(IType var1, String var2);

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    protected abstract ReplaceEdit createRenamePackageEdit(String var1);

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.isIn(originalPackage) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    protected boolean isFor(String typeName) {
        String converterType = this.getFullyQualifiedConverterClass();
        return converterType != null && converterType.equals(typeName);
    }

    protected boolean isIn(IPackageFragment packageFragment) {
        JavaResourceAbstractType converterType = this.getConverterJavaResourceType();
        return converterType != null && converterType.isIn(packageFragment);
    }
}

