/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.util.Arrays;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.CollectionTools;

public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    private static final char[] VOWELS = new char[]{'a', 'e', 'i', 'o', 'u'};

    public static String pad(String string, int length) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.padInternal(string, length);
    }

    public static String padOrTruncate(String string, int length) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(0, length);
        }
        return StringTools.padInternal(string, length);
    }

    private static String padInternal(String string, int length) {
        char[] a = new char[length];
        int stringLength = string.length();
        string.getChars(0, stringLength, a, 0);
        Arrays.fill(a, stringLength, length, ' ');
        return new String(a);
    }

    public static String zeroPad(String string, int length) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.zeroPadInternal(string, length);
    }

    public static String zeroPadOrTruncate(String string, int length) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(stringLength - length);
        }
        return StringTools.zeroPadInternal(string, length);
    }

    private static String zeroPadInternal(String string, int length) {
        char[] a = new char[length];
        int stringLength = string.length();
        int padLength = length - stringLength;
        string.getChars(0, stringLength, a, padLength);
        Arrays.fill(a, 0, padLength, '0');
        return new String(a);
    }

    public static String removeFirstOccurrence(String string, char character) {
        int index = string.indexOf(character);
        if (index == -1) {
            return string;
        }
        if (index == 0) {
            return string.substring(1);
        }
        int last = string.length() - 1;
        if (index == last) {
            return string.substring(0, last);
        }
        return string.substring(0, index).concat(string.substring(index + 1));
    }

    public static String removeAllOccurrences(String string, char character) {
        StringBuffer sb = new StringBuffer(string.length());
        StringTools.removeAllOccurrencesOn(string, character, sb);
        return sb.toString();
    }

    public static void removeAllOccurrencesOn(String string, char character, StringBuffer sb) {
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c != character) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static int commonPrefixLength(String s1, String s2) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return StringTools.commonPrefixLengthInternal(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(String s1, String s2, int max) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        return StringTools.commonPrefixLengthInternal(s1, s2, Math.min(max, Math.min(s1.length, s2.length)));
    }

    private static int commonPrefixLengthInternal(char[] s1, char[] s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1[i] != s2[i]) {
                return i;
            }
            ++i;
        }
        return max;
    }

    public static String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer sb = new StringBuffer(string.length());
        StringTools.capitalizeOnInternal(string, sb);
        return sb.toString();
    }

    public static void capitalizeOn(String string, StringBuffer sb) {
        if (string.length() != 0) {
            StringTools.capitalizeOnInternal(string, sb);
        }
    }

    private static void capitalizeOnInternal(String string, StringBuffer sb) {
        sb.append(Character.toUpperCase(string.charAt(0)));
        sb.append(string.substring(1));
    }

    public static String uncapitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer sb = new StringBuffer(string.length());
        StringTools.uncapitalizeOnInternal(string, sb);
        return sb.toString();
    }

    public static void uncapitalizeOn(String string, StringBuffer sb) {
        if (string.length() != 0) {
            StringTools.uncapitalizeOnInternal(string, sb);
        }
    }

    private static void uncapitalizeOnInternal(String string, StringBuffer sb) {
        sb.append(Character.toLowerCase(string.charAt(0)));
        sb.append(string.substring(1));
    }

    public static String buildToStringFor(Object o, Object additionalInfo) {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(o, sb);
        sb.append(" (");
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String buildToStringFor(Object o) {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(o, sb);
        return sb.toString();
    }

    public static void buildSimpleToStringOn(Object o, StringBuffer sb) {
        sb.append(ClassTools.toStringClassNameForObject(o));
        sb.append('[');
        sb.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8));
        sb.append(']');
    }

    public static boolean stringIsEmpty(String text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        int i = text.length();
        while (i-- > 0) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean charIsVowel(char c) {
        return CollectionTools.contains(VOWELS, Character.toLowerCase(c));
    }

    public static String replaceHTMLBreaks(String string) {
        return string.replaceAll("<br>", CR).replaceAll("<BR>", CR);
    }

    public static String convertCamelBackToAllCaps(String camelBackString) {
        int len = camelBackString.length();
        if (len == 0) {
            return "";
        }
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelBackString.charAt(0);
        StringBuffer sb = new StringBuffer(len * 2);
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelBackString.charAt(i);
            if (StringTools.camelBackWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
        return sb.toString();
    }

    public static String convertCamelBackToAllCaps(String camelBackString, int maxLength) {
        int len = camelBackString.length();
        if (len == 0 || maxLength == 0) {
            return "";
        }
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelBackString.charAt(0);
        StringBuffer sb = new StringBuffer(maxLength);
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelBackString.charAt(i);
            if (StringTools.camelBackWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return sb.toString();
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return sb.toString();
            }
            prev = c;
            ++i;
        }
        return sb.toString();
    }

    private static boolean camelBackWordBreak(char prev, char c, char next) {
        if (prev == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return false;
        }
        if (Character.isLowerCase(prev)) {
            return true;
        }
        if (next == '\u0000') {
            return false;
        }
        return Character.isLowerCase(next);
    }

    public static String convertAllCapsToCamelBack(String allCapsString) {
        return StringTools.convertAllCapsToCamelBack(allCapsString, true);
    }

    public static String convertAllCapsToCamelBack(String allCapsString, boolean capitalizeFirstLetter) {
        int len = allCapsString.length();
        if (len == 0) {
            return "";
        }
        char prev = '\u0000';
        char c = '\u0000';
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            prev = c;
            c = allCapsString.charAt(i);
            if (c != '_') {
                if (sb.length() == 0) {
                    if (capitalizeFirstLetter) {
                        sb.append(Character.toUpperCase(c));
                    } else {
                        sb.append(Character.toLowerCase(c));
                    }
                } else if (prev == '_') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }
}

