/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.AccessType;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.PersistenceSourceRefElement;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.core.PersistentTypeFlavor;
import org.eclipse.dali.core.Version;
import org.eclipse.dali.core.adapters.IPersistentTypeModelAdapter;
import org.eclipse.dali.core.impl.PersistenceSourceRefElementImpl;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.CompositeIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PersistentTypeImpl
extends PersistenceSourceRefElementImpl
implements PersistentType {
    protected static final String CLASS_NAME_EDEFAULT = null;
    protected String className = CLASS_NAME_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final AccessType ACCESS_TYPE_EDEFAULT = AccessType.DEFAULT_LITERAL;
    protected AccessType accessType = ACCESS_TYPE_EDEFAULT;
    protected PersistentTypeFlavor flavor = null;
    protected EList persistentAttributes = null;
    static /* synthetic */ Class class$0;

    protected PersistentTypeImpl() {
    }

    protected PersistentTypeImpl(IPersistentTypeModelAdapter persistentTypeModelAdapter) {
        super(persistentTypeModelAdapter);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getPersistentType();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassNameGen(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldClassName, (Object)this.className));
        }
    }

    public void setClassName(String newClassName) {
        String oldDefaultName = this.getDefaultName();
        this.setClassNameGen(newClassName);
        String newDefaultName = this.getDefaultName();
        if (this.name == null && this.name == oldDefaultName || this.name != null && this.name.equals(oldDefaultName)) {
            this.setName(newDefaultName);
        }
    }

    public String getDefaultName() {
        return this.className == null ? "" : ClassTools.shortNameForClassNamed((String)this.className);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessTypeGen(AccessType newAccessType) {
        AccessType oldAccessType = this.accessType;
        AccessType accessType = this.accessType = newAccessType == null ? ACCESS_TYPE_EDEFAULT : newAccessType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldAccessType, (Object)this.accessType));
        }
    }

    public void setAccessType(AccessType newAccessType) {
        this.setAccessTypeGen(newAccessType);
        ((IPersistentTypeModelAdapter)this.getModelAdapter()).accessTypeChanged();
    }

    public PersistentTypeFlavor getFlavor() {
        return this.flavor;
    }

    public PersistentTypeFlavor.Key getFlavorKey() {
        return this.flavor != null ? this.flavor.getKey() : null;
    }

    public NotificationChain basicSetFlavor(PersistentTypeFlavor newFlavor, NotificationChain msgs) {
        PersistentTypeFlavor oldFlavor = this.flavor;
        this.flavor = newFlavor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldFlavor, (Object)newFlavor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setFlavorGen(PersistentTypeFlavor newFlavor) {
        if (newFlavor != this.flavor) {
            NotificationChain msgs = null;
            if (this.flavor != null) {
                msgs = ((InternalEObject)this.flavor).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newFlavor != null) {
                msgs = ((InternalEObject)newFlavor).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetFlavor(newFlavor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newFlavor, (Object)newFlavor));
        }
    }

    public void setFlavor(PersistentTypeFlavor newFlavor) {
        if (this.flavor == newFlavor) {
            return;
        }
        this.setFlavorGen(newFlavor);
        this.setName(this.getDefaultName());
        newFlavor.initialize(this);
    }

    public void setFlavorKey(PersistentTypeFlavor.Key flavorKey) {
        if (flavorKey.equals(this.getFlavorKey())) {
            return;
        }
        ((IPersistentTypeModelAdapter)this.getModelAdapter()).setFlavorKey(flavorKey);
    }

    public EList getPersistentAttributes() {
        if (this.persistentAttributes == null) {
            this.persistentAttributes = new EObjectContainmentEList(PersistentAttribute.class, (InternalEObject)this, 4);
        }
        return this.persistentAttributes;
    }

    public EList getAllPersistentAttributes() {
        ArrayList allPersistentAttributes = new ArrayList();
        PersistentType parentPersistentType = this.getParentPersistentType();
        if (parentPersistentType != null) {
            allPersistentAttributes.addAll(parentPersistentType.getAllPersistentAttributes());
        }
        allPersistentAttributes.addAll(0, this.getPersistentAttributes());
        return new BasicEList.UnmodifiableEList(allPersistentAttributes.size(), allPersistentAttributes.toArray());
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    return this.basicSetFlavor(null, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getPersistentAttributes()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getAllPersistentAttributes()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getClassName();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getAccessType();
            }
            case 3: {
                return this.getFlavor();
            }
            case 4: {
                return this.getPersistentAttributes();
            }
            case 5: {
                return this.getAllPersistentAttributes();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setClassName((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setAccessType((AccessType)((Object)newValue));
                return;
            }
            case 3: {
                this.setFlavor((PersistentTypeFlavor)newValue);
                return;
            }
            case 4: {
                this.getPersistentAttributes().clear();
                this.getPersistentAttributes().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getAllPersistentAttributes().clear();
                this.getAllPersistentAttributes().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setClassName(CLASS_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setAccessType(ACCESS_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setFlavor(null);
                return;
            }
            case 4: {
                this.getPersistentAttributes().clear();
                return;
            }
            case 5: {
                this.getAllPersistentAttributes().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return CLASS_NAME_EDEFAULT == null ? this.className != null : !CLASS_NAME_EDEFAULT.equals(this.className);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.accessType != ACCESS_TYPE_EDEFAULT;
            }
            case 3: {
                return this.flavor != null;
            }
            case 4: {
                return this.persistentAttributes != null && !this.persistentAttributes.isEmpty();
            }
            case 5: {
                return !this.getAllPersistentAttributes().isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (className: ");
        result.append(this.className);
        result.append(", name: ");
        result.append(this.name);
        result.append(", accessType: ");
        result.append((Object)this.accessType);
        result.append(')');
        return result.toString();
    }

    public PersistenceSourceRefElement persistenceObjectAt(int offset) {
        return ((IPersistentTypeModelAdapter)this.getModelAdapter()).persistenceObjectAt(offset);
    }

    protected void addProblemsTo(List problems) {
        this.addMultipleVersionMappingsProblemTo(problems);
        CollectionTools.addAll((Collection)problems, (Iterator)this.getFlavor().problems());
        CollectionTools.addAll((Collection)problems, (Iterator)new CompositeIterator(this.persistentAttributeProblems()));
    }

    private void addMultipleVersionMappingsProblemTo(List problems) {
        int numMappings = 0;
        for (PersistentAttribute attribute : this.getPersistentAttributes()) {
            if (!(attribute.getFlavor() instanceof Version)) continue;
            ++numMappings;
        }
        if (numMappings > 1) {
            problems.add(this.buildProblem("Multiple Version properties are not allowed", this.getTextRange()));
        }
    }

    private Iterator persistentAttributeProblems() {
        return new TransformationIterator(this.getPersistentAttributes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentAttribute)next).problems();
            }
        };
    }

    public PersistentType getParentPersistentType() {
        return ((IPersistentTypeModelAdapter)this.getModelAdapter()).getParentPersistentType();
    }
}

