/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.OrderBy;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.OrderByItemProvider;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OrderByComposite
extends Composite
implements IPersistenceComposite,
ModifyListener,
INotifyChangedListener {
    private static final String ORDER_BY_DEFAULT = "Default (by Primary Key)";
    private Combo combo;
    private EditingDomain editingDomain;
    private OrderBy orderBy;
    private OrderByItemProvider orderByItemProvider;

    public OrderByComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.initializeLayout();
        this.orderByItemProvider = (OrderByItemProvider)adapterFactory.createOrderByAdapter();
        this.orderByItemProvider.addListener((INotifyChangedListener)this);
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group columnGroup = new Group((Composite)this, 16);
        columnGroup.setText("Order By");
        columnGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        columnGroup.setLayoutData((Object)gridData);
        Label tableLabel = new Label((Composite)columnGroup, 16384);
        tableLabel.setText("Order By:");
        this.combo = new Combo((Composite)columnGroup, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)gridData);
        this.combo.add("");
        this.combo.add(ORDER_BY_DEFAULT);
        this.combo.addModifyListener((ModifyListener)this);
    }

    private void updateView(String newValue) {
        String oldValue = this.combo.getText();
        if (newValue == null && !oldValue.equals(ORDER_BY_DEFAULT)) {
            this.combo.setText(ORDER_BY_DEFAULT);
        } else if (newValue != null && !oldValue.equals(newValue)) {
            this.combo.setText(newValue);
        }
    }

    private void updateModel(Command command) {
        this.orderByItemProvider.removeListener((INotifyChangedListener)this);
        this.editingDomain.getCommandStack().execute(command);
        this.orderByItemProvider.addListener((INotifyChangedListener)this);
    }

    public void populate(EObject eObject) {
        OrderBy model = (OrderBy)eObject;
        if (model != null) {
            this.orderBy = model;
            if (!this.orderBy.eAdapters().contains((Object)this.orderByItemProvider)) {
                this.orderBy.eAdapters().add((Object)this.orderByItemProvider);
            }
            this.updateView(this.orderBy.getValue());
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.orderBy == null) {
            return;
        }
        String str = ((Combo)e.getSource()).getText().trim();
        if (str.equals(ORDER_BY_DEFAULT)) {
            str = null;
        } else if (str.length() == 0) {
            str = null;
        }
        String value = this.orderBy.getValue();
        if (value == null && str != null || value != null && !value.equals(str)) {
            this.updateModel(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.orderBy, (Object)DaliPackage.eINSTANCE.getOrderBy_Value(), (Object)str));
        }
    }

    public void notifyChanged(Notification notification) {
        final String value = (String)notification.getNewValue();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                OrderByComposite.this.updateView(value);
            }
        });
    }
}

