/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.ListIterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.BooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JoinColumnInfoAdapter;
import org.eclipse.dali.orm.adapters.java.JoinColumnInsertableInfo;
import org.eclipse.dali.orm.adapters.java.JoinColumnUpdatableInfo;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularOrPluralBooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public abstract class AbstractJavaJoinColumnModelAdapter
implements IJoinColumnModelAdapter {
    private Member member;
    JoinColumn joinColumn;
    private IJoinColumnModelAdapter.JoinColumnOwner owner;
    private AbstractAnnotationElementAdapter specifiedNameAdapter;
    private StringAnnotationElementAdapter specifiedTableNameAdapter;
    private AbstractAnnotationElementAdapter specifiedReferencedColumnNameAdapter;
    private BooleanAnnotationElementAdapter insertableAdapter;
    private BooleanAnnotationElementAdapter updatableAdapter;

    AbstractJavaJoinColumnModelAdapter(IJoinColumnModelAdapter.JoinColumnOwner owner, Member member) {
        this.member = member;
        this.owner = owner;
        this.specifiedNameAdapter = this.buildSpecifiedNameAdapter();
        this.specifiedTableNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedTableNameElementInfo());
        this.specifiedReferencedColumnNameAdapter = this.buildSpecifiedReferencedColumnNameAdapter();
        this.insertableAdapter = new SingularOrPluralBooleanAnnotationElementAdapter(this.buildInsertableInfo());
        this.updatableAdapter = new SingularOrPluralBooleanAnnotationElementAdapter(this.buildUpdatableInfo());
    }

    public void setJoinColumn(JoinColumn joinColumn) {
        this.joinColumn = joinColumn;
    }

    protected abstract AbstractAnnotationElementAdapter buildSpecifiedNameAdapter();

    protected abstract AbstractAnnotationElementAdapter buildSpecifiedReferencedColumnNameAdapter();

    public IJoinColumnModelAdapter.JoinColumnOwner getOwner() {
        return this.owner;
    }

    protected JoinColumn getJoinColumn() {
        return this.joinColumn;
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedTableNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                AbstractJavaJoinColumnModelAdapter.this.joinColumn.setSpecifiedTableName(newValue);
            }

            public String persValue() {
                return AbstractJavaJoinColumnModelAdapter.this.joinColumn.getSpecifiedTableName();
            }

            public String annotationElementName() {
                return "table";
            }

            public String annotationName() {
                return "JoinColumn";
            }

            public Member member() {
                return AbstractJavaJoinColumnModelAdapter.this.getMember();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private SingularOrPluralBooleanAnnotationElementAdapter.Info buildInsertableInfo() {
        return new JoinColumnInsertableInfo(this.buildJoinColumnInfoAdapter());
    }

    private SingularOrPluralBooleanAnnotationElementAdapter.Info buildUpdatableInfo() {
        return new JoinColumnUpdatableInfo(this.buildJoinColumnInfoAdapter());
    }

    private JoinColumnInfoAdapter buildJoinColumnInfoAdapter() {
        return new JoinColumnInfoAdapter(){

            public JoinColumn joinColumn() {
                return AbstractJavaJoinColumnModelAdapter.this.joinColumn;
            }

            public Member member() {
                return AbstractJavaJoinColumnModelAdapter.this.getMember();
            }
        };
    }

    public void updatePersModel(CompilationUnit astRoot) {
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersDefaultTableName();
        this.updatePersDefaultReferencedColumnName();
        this.updatePersSpecifiedName(astRoot);
        this.updatePersSpecifiedTableName(astRoot);
        this.updatePersSpecifiedReferencedColumnName(astRoot);
        this.updatePersInsertable(astRoot);
        this.updatePersUpdatable(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.joinColumn.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultName(name);
        }
    }

    protected abstract String defaultName();

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.joinColumn.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        this.specifiedTableNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersInsertable(CompilationUnit astRoot) {
        this.insertableAdapter.updatePersElement(astRoot);
    }

    private void updatePersUpdatable(CompilationUnit astRoot) {
        this.updatableAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultReferencedColumnName() {
        String name = this.defaultReferencedColumnName();
        String persName = this.joinColumn.getDefaultReferencedColumnName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultReferencedColumnName(name);
        }
    }

    private void updatePersSpecifiedReferencedColumnName(CompilationUnit astRoot) {
        this.specifiedReferencedColumnNameAdapter.updatePersElement(astRoot);
    }

    protected abstract String defaultReferencedColumnName();

    protected String idNameFromPersistentType(PersistentType persistentType) {
        String targetIdName = null;
        if (persistentType != null) {
            ListIterator i = persistentType.getAllPersistentAttributes().listIterator();
            while (i.hasNext()) {
                PersistentAttribute targetAttribute = (PersistentAttribute)i.next();
                if (!(targetAttribute.getAttributeMapping() instanceof IdMapping)) continue;
                targetIdName = ((IdMapping)targetAttribute.getAttributeMapping()).getColumn().getName();
                break;
            }
        }
        return targetIdName;
    }

    private String defaultTableName() {
        RelationshipMapping relationshipMapping = this.owner.relationshipMapping();
        TypeMapping typeMapping = relationshipMapping.getTypeMapping();
        if (typeMapping.getKey() == Entity.Key.INSTANCE) {
            return ((Entity)typeMapping).getTable().getName();
        }
        return null;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedTableNameChanged() {
        this.specifiedTableNameAdapter.updateJavaElement();
    }

    public void specifiedReferencedColumnNameChanged() {
        this.specifiedReferencedColumnNameAdapter.updateJavaElement();
    }

    public void insertableChanged() {
        this.insertableAdapter.updateJavaElement();
    }

    public void updatableChanged() {
        this.updatableAdapter.updateJavaElement();
    }

    protected Member getMember() {
        return this.member;
    }

    public ITextRange getTextRange() {
        return this.getMember().getTextRange("JoinColumn");
    }

    public ITextRange joinColumnTextRange() {
        return this.specifiedNameAdapter.textRange();
    }

    public ITextRange referencedColumnTextRange() {
        return this.specifiedReferencedColumnNameAdapter.textRange();
    }

    public ITextRange tableNameTextRange() {
        return this.specifiedTableNameAdapter.textRange();
    }
}

