/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.composites.action.ToggleLinkingAction;
import org.eclipse.dali.ui.selection.Selection;
import org.eclipse.dali.ui.views.PersistenceView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PersistenceOutlineView
extends PersistenceView {
    private static final String NOT_AVAILABLE_LABEL = DaliUiMessages.PersistenceOutlineView_outlineNotAvailable;
    private static final EClass PERSISTENCE_FILE_COMPOSITE_KEY = OrmPackage.eINSTANCE.getPersistenceFile();
    private PersistenceOutlineComposite outlineComposite;
    private boolean linkingWithEditorEnabled;

    public PersistenceOutlineView() {
        super(NOT_AVAILABLE_LABEL);
    }

    public void subcreatePartControl(Composite parent) {
        IActionBars actionBars = ((IViewSite)this.getSite()).getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new ToggleLinkingAction(this));
        }
        this.outlineComposite = new PersistenceOutlineComposite(this.pageBookManager.getComposite(), 0);
        this.pageBookManager.put(PERSISTENCE_FILE_COMPOSITE_KEY, this.outlineComposite);
        this.pageBookManager.deactivate(PERSISTENCE_FILE_COMPOSITE_KEY);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer i = memento.getInteger("org.eclipse.dali.linkpropertiestoeditor");
            this.linkingWithEditorEnabled = i != null && i == 1;
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        memento.putInteger("org.eclipse.dali.linkpropertiestoeditor", this.linkingWithEditorEnabled ? 1 : 0);
        super.saveState(memento);
    }

    public boolean isLinkingWithEditorEnabled() {
        return this.linkingWithEditorEnabled;
    }

    public void setLinkingWithEditorEnabled(boolean linkingWithEditorEnabled) {
        this.linkingWithEditorEnabled = linkingWithEditorEnabled;
    }

    public Selection getSelection() {
        if (this.pageBookManager.getActive() != this.outlineComposite) {
            return Selection.NULL_SELECTION;
        }
        return this.outlineComposite.getSelection();
    }

    public void select(Selection newSelection) {
        Selection currentSelection = this.getSelection();
        if (newSelection.equals(currentSelection)) {
            return;
        }
        PersistenceSourceRefElement newElement = newSelection.getSelectedElement();
        if (newSelection == Selection.NULL_SELECTION) {
            this.pageBookManager.deactivate(PERSISTENCE_FILE_COMPOSITE_KEY);
            this.outlineComposite.viewer.setSelection((ISelection)new StructuredSelection());
        } else if (currentSelection == Selection.NULL_SELECTION) {
            this.pageBookManager.activate(PERSISTENCE_FILE_COMPOSITE_KEY);
            PersistenceFile newPfile = newElement.getPersistenceFile();
            this.outlineComposite.viewer.setInput((Object)newPfile);
            this.outlineComposite.viewer.setSelection((ISelection)new StructuredSelection((Object)newElement));
        } else {
            PersistenceFile currentPfile;
            PersistenceFile newPfile = newElement.getPersistenceFile();
            if (!newPfile.equals(currentPfile = (PersistenceFile)this.outlineComposite.viewer.getInput())) {
                this.outlineComposite.viewer.setInput((Object)newPfile);
            }
            this.outlineComposite.viewer.setSelection((ISelection)new StructuredSelection((Object)newElement));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineComposite.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineComposite.viewer.removeSelectionChangedListener(listener);
    }

    private class PersistenceOutlineComposite
    extends Composite {
        private TreeViewer viewer;

        PersistenceOutlineComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new FillLayout());
            OrmItemProviderAdapterFactory adapterFactory = new OrmItemProviderAdapterFactory();
            this.viewer = new TreeViewer((Composite)this, 770);
            this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
            this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.viewer.setAutoExpandLevel(2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewer.getTree(), "org.eclipse.dali.ui.persistenceOutline");
        }

        Selection getSelection() {
            ITreeSelection viewerSelection = (ITreeSelection)this.viewer.getSelection();
            if (viewerSelection.isEmpty() || viewerSelection.size() > 1) {
                return new Selection((PersistenceSourceRefElement)this.viewer.getInput());
            }
            return new Selection((PersistenceSourceRefElement)viewerSelection.getFirstElement());
        }

        void select(Selection selection) {
            if (selection == null) {
                throw new IllegalArgumentException("Must use NULL SELECTION");
            }
            if (selection == Selection.NULL_SELECTION) {
                this.viewer.setInput(null);
            }
            PersistenceSourceRefElement selectedElement = selection.getSelectedElement();
            this.viewer.setInput((Object)selectedElement.getPersistenceFile());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)selectedElement));
        }
    }
}

