/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.xml;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.adapters.IPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.xml.IXMLAttributeMappingModelAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPersistentAttributeModelAdapter
implements IPersistentAttributeModelAdapter {
    private IDOMElement persAttributeElement;
    private PersistentAttribute persistentAttribute;
    private static final String ATTRIBUTE_TAG = "p:attribute";

    public XMLPersistentAttributeModelAdapter(IDOMElement persAttributeElement) {
        this.persAttributeElement = persAttributeElement;
    }

    public void engage(PersistentAttribute persistentAttribute, IDOMElement persAttributeElement) {
        this.persAttributeElement = persAttributeElement;
        this.persistentAttribute = persistentAttribute;
        this.updatePersModel();
    }

    public String getName() {
        return this.getName(this.persAttributeElement);
    }

    private String getName(IDOMElement domElement) {
        IDOMElement element;
        Node node;
        NodeList elements = domElement.getElementsByTagName(ATTRIBUTE_TAG);
        if (elements.getLength() > 0 && (node = (element = (IDOMElement)elements.item(0)).getFirstChild()).getNodeType() == 3) {
            return node.getNodeValue();
        }
        return "";
    }

    void synchWithXML() {
        this.updatePersModel();
    }

    private void updatePersModel() {
        this.updatePersPersistentAttributeType();
    }

    private void updatePersPersistentAttributeType() {
        IConfigurationElement xmlMappingType = this.xmlConfigurationElement();
        AttributeMapping persAttributeMapping = this.persistentAttribute.getAttributeMapping();
        if (persAttributeMapping != null && xmlMappingType.getAttribute(this.attributeMappingNameExtensionAttribute()).equals(persAttributeMapping.mappingName())) {
            return;
        }
        IXMLAttributeMappingModelAdapter adapter = null;
        try {
            adapter = (IXMLAttributeMappingModelAdapter)xmlMappingType.createExecutableExtension(this.attributeMappingModelAdapterExtensionAttribute());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        AttributeMapping persistentAttributeType = adapter.createAttributeMapping(false);
        this.persistentAttribute.setAttributeMapping(persistentAttributeType);
        if (adapter != null) {
            adapter.synchWithXML(this.persAttributeElement);
        }
    }

    public void setAttributeMappingKey(String attributeMappingKey, boolean isDefault) {
    }

    public boolean persistentAttributeFor(IDOMElement domElement) {
        return this.getName(this.persAttributeElement).equals(domElement);
    }

    public ITextRange getTextRange() {
        return new ITextRange(){

            public int getOffset() {
                return XMLPersistentAttributeModelAdapter.this.persAttributeElement.getStartOffset();
            }

            public int getLength() {
                return XMLPersistentAttributeModelAdapter.this.persAttributeElement.getLength();
            }

            public int getLineNumber() {
                return 0;
            }
        };
    }

    private IConfigurationElement xmlConfigurationElement() {
        Iterator i = DaliPlugin.getPlugin().xmlMappingConfigurationElements();
        while (i.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)i.next();
            String tagName = element.getAttribute(this.attributeMappingNameExtensionAttribute());
            if (!tagName.equals(this.persAttributeElement.getTagName())) continue;
            return element;
        }
        return null;
    }

    public String attributeMappingModelAdapterExtensionAttribute() {
        return "xmlModelAdapter";
    }

    public String attributeMappingNameExtensionAttribute() {
        return "xmlTagName";
    }
}

