/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.util.HashMap;
import org.eclipse.dali.internal.utility.JDBCType;
import org.eclipse.dali.internal.utility.JavaType;

public final class JDBCTools {
    private static HashMap JDBC_TO_JAVA_TYPE_MAPPINGS;
    private static final JavaType DEFAULT_JAVA_TYPE;
    private static HashMap JAVA_TO_JDBC_TYPE_MAPPINGS;
    private static final JDBCType DEFAULT_JDBC_TYPE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_JAVA_TYPE = new JavaType(clazz);
        DEFAULT_JDBC_TYPE = JDBCType.type(12);
    }

    public static JDBCType jdbcTypeForClassNamed(String className) {
        JavaToJDBCTypeMapping mapping = JDBCTools.javaToJDBCTypeMapping(className);
        return mapping == null ? DEFAULT_JDBC_TYPE : mapping.getJDBCType();
    }

    public static JDBCType jdbcTypeFor(Class javaClass) {
        return JDBCTools.jdbcTypeForClassNamed(javaClass.getName());
    }

    public static JDBCType jdbcTypeFor(JavaType javaType) {
        return JDBCTools.jdbcTypeForClassNamed(javaType.javaClassName());
    }

    public static JavaType javaTypeForJDBCTypeNamed(String jdbcTypeName) {
        JDBCToJavaTypeMapping mapping = JDBCTools.jdbcToJavaTypeMapping(jdbcTypeName);
        return mapping == null ? DEFAULT_JAVA_TYPE : mapping.getJavaType();
    }

    public static JavaType javaTypeFor(JDBCType jdbcType) {
        return JDBCTools.javaTypeForJDBCTypeNamed(jdbcType.getName());
    }

    public static JavaType javaTypeForJDBCTypeCode(int jdbcTypeCode) {
        return JDBCTools.javaTypeFor(JDBCType.type(jdbcTypeCode));
    }

    private static JDBCToJavaTypeMapping jdbcToJavaTypeMapping(String jdbcTypeName) {
        return (JDBCToJavaTypeMapping)JDBCTools.jdbcToJavaTypeMappings().get(jdbcTypeName);
    }

    private static synchronized HashMap jdbcToJavaTypeMappings() {
        if (JDBC_TO_JAVA_TYPE_MAPPINGS == null) {
            JDBC_TO_JAVA_TYPE_MAPPINGS = JDBCTools.buildJDBCToJavaTypeMappings();
        }
        return JDBC_TO_JAVA_TYPE_MAPPINGS;
    }

    private static HashMap buildJDBCToJavaTypeMappings() {
        HashMap mappings = new HashMap();
        JDBCTools.addJDBCToJavaTypeMappingsTo(mappings);
        return mappings;
    }

    private static void addJDBCToJavaTypeMappingsTo(HashMap mappings) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.sql.Array");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2003, clazz, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-5, Long.TYPE, mappings);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(-2, clazz2, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-7, Boolean.TYPE, mappings);
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2004, clazz3, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(16, Boolean.TYPE, mappings);
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(1, clazz4, mappings);
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2005, clazz5, mappings);
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(70, clazz6, mappings);
        Class<?> clazz7 = class$9;
        if (clazz7 == null) {
            try {
                clazz7 = class$9 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(91, clazz7, mappings);
        Class<?> clazz8 = class$10;
        if (clazz8 == null) {
            try {
                clazz8 = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(3, clazz8, mappings);
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2001, clazz9, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(8, Double.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(6, Double.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(4, Integer.TYPE, mappings);
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2000, clazz10, mappings);
        Class<?> clazz11 = class$3;
        if (clazz11 == null) {
            try {
                clazz11 = class$3 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(-4, clazz11, mappings);
        Class<?> clazz12 = class$6;
        if (clazz12 == null) {
            try {
                clazz12 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(-1, clazz12, mappings);
        Class<?> clazz13 = class$10;
        if (clazz13 == null) {
            try {
                clazz13 = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2, clazz13, mappings);
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(1111, clazz14, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(7, Float.TYPE, mappings);
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("java.sql.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2006, clazz15, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(5, Short.TYPE, mappings);
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("java.sql.Struct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(2002, clazz16, mappings);
        Class<?> clazz17 = class$17;
        if (clazz17 == null) {
            try {
                clazz17 = class$17 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(92, clazz17, mappings);
        Class<?> clazz18 = class$18;
        if (clazz18 == null) {
            try {
                clazz18 = class$18 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(93, clazz18, mappings);
        JDBCTools.addJDBCToJavaTypeMappingTo(-6, Byte.TYPE, mappings);
        Class<?> clazz19 = class$3;
        if (clazz19 == null) {
            try {
                clazz19 = class$3 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(-3, clazz19, mappings);
        Class<?> clazz20 = class$6;
        if (clazz20 == null) {
            try {
                clazz20 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJDBCToJavaTypeMappingTo(12, clazz20, mappings);
    }

    private static void addJDBCToJavaTypeMappingTo(int jdbcTypeCode, Class javaClass, HashMap mappings) {
        JDBCType jdbcType = JDBCType.type(jdbcTypeCode);
        JDBCToJavaTypeMapping prev = mappings.put(jdbcType.getName(), JDBCTools.buildJDBCToJavaTypeMapping(jdbcType, javaClass));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate JDBC type: " + jdbcType.getName());
        }
    }

    private static JDBCToJavaTypeMapping buildJDBCToJavaTypeMapping(JDBCType jdbcType, Class javaClass) {
        return new JDBCToJavaTypeMapping(jdbcType, new JavaType(javaClass));
    }

    private static JavaToJDBCTypeMapping javaToJDBCTypeMapping(String className) {
        return (JavaToJDBCTypeMapping)JDBCTools.javaToJDBCTypeMappings().get(className);
    }

    private static synchronized HashMap javaToJDBCTypeMappings() {
        if (JAVA_TO_JDBC_TYPE_MAPPINGS == null) {
            JAVA_TO_JDBC_TYPE_MAPPINGS = JDBCTools.buildJavaToJDBCTypeMappings();
        }
        return JAVA_TO_JDBC_TYPE_MAPPINGS;
    }

    private static HashMap buildJavaToJDBCTypeMappings() {
        HashMap mappings = new HashMap();
        JDBCTools.addJavaToJDBCTypeMappingsTo(mappings);
        return mappings;
    }

    private static void addJavaToJDBCTypeMappingsTo(HashMap mappings) {
        JDBCTools.addJavaToJDBCTypeMappingTo(Boolean.TYPE, -7, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Byte.TYPE, -6, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Double.TYPE, 8, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Float.TYPE, 7, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Integer.TYPE, 4, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Long.TYPE, -5, mappings);
        JDBCTools.addJavaToJDBCTypeMappingTo(Short.TYPE, 5, mappings);
        Class<?> clazz = class$20;
        if (clazz == null) {
            try {
                clazz = class$20 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz, -7, mappings);
        Class<?> clazz2 = class$21;
        if (clazz2 == null) {
            try {
                clazz2 = class$21 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz2, -6, mappings);
        Class<?> clazz3 = class$22;
        if (clazz3 == null) {
            try {
                clazz3 = class$22 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz3, 8, mappings);
        Class<?> clazz4 = class$23;
        if (clazz4 == null) {
            try {
                clazz4 = class$23 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz4, 7, mappings);
        Class<?> clazz5 = class$24;
        if (clazz5 == null) {
            try {
                clazz5 = class$24 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz5, 4, mappings);
        Class<?> clazz6 = class$25;
        if (clazz6 == null) {
            try {
                clazz6 = class$25 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz6, -5, mappings);
        Class<?> clazz7 = class$26;
        if (clazz7 == null) {
            try {
                clazz7 = class$26 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz7, 5, mappings);
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz8, 12, mappings);
        Class<?> clazz9 = class$10;
        if (clazz9 == null) {
            try {
                clazz9 = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz9, 2, mappings);
        Class<?> clazz10 = class$8;
        if (clazz10 == null) {
            try {
                clazz10 = class$8 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz10, 70, mappings);
        Class<?> clazz11 = class$1;
        if (clazz11 == null) {
            try {
                clazz11 = class$1 = Class.forName("java.sql.Array");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz11, 2003, mappings);
        Class<?> clazz12 = class$5;
        if (clazz12 == null) {
            try {
                clazz12 = class$5 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz12, 2004, mappings);
        Class<?> clazz13 = class$7;
        if (clazz13 == null) {
            try {
                clazz13 = class$7 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz13, 2005, mappings);
        Class<?> clazz14 = class$9;
        if (clazz14 == null) {
            try {
                clazz14 = class$9 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz14, 91, mappings);
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("java.sql.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz15, 2006, mappings);
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("java.sql.Struct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz16, 2002, mappings);
        Class<?> clazz17 = class$17;
        if (clazz17 == null) {
            try {
                clazz17 = class$17 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz17, 92, mappings);
        Class<?> clazz18 = class$18;
        if (clazz18 == null) {
            try {
                clazz18 = class$18 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz18, 93, mappings);
        Class<?> clazz19 = class$3;
        if (clazz19 == null) {
            try {
                clazz19 = class$3 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz19, -3, mappings);
        Class<?> clazz20 = class$27;
        if (clazz20 == null) {
            try {
                clazz20 = class$27 = Class.forName("[Ljava.lang.Byte;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTools.addJavaToJDBCTypeMappingTo(clazz20, -3, mappings);
    }

    private static void addJavaToJDBCTypeMappingTo(Class javaClass, int jdbcTypeCode, HashMap mappings) {
        JavaToJDBCTypeMapping prev = mappings.put(javaClass.getName(), JDBCTools.buildJavaToJDBCTypeMapping(javaClass, jdbcTypeCode));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate Java class: " + prev.getJavaType().declaration());
        }
    }

    private static JavaToJDBCTypeMapping buildJavaToJDBCTypeMapping(Class javaClass, int jdbcTypeCode) {
        return new JavaToJDBCTypeMapping(new JavaType(javaClass), JDBCType.type(jdbcTypeCode));
    }

    private JDBCTools() {
        throw new UnsupportedOperationException();
    }

    private static class JDBCToJavaTypeMapping {
        private final JDBCType jdbcType;
        private final JavaType javaType;

        JDBCToJavaTypeMapping(JDBCType jdbcType, JavaType javaType) {
            this.jdbcType = jdbcType;
            this.javaType = javaType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public boolean maps(int jdbcTypeCode) {
            return this.jdbcType.getCode() == jdbcTypeCode;
        }

        public boolean maps(String jdbcTypeName) {
            return this.jdbcType.getName().equals(jdbcTypeName);
        }

        public boolean maps(JDBCType type) {
            return this.jdbcType == type;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuffer sb) {
            this.jdbcType.appendTo(sb);
            sb.append(" => ");
            this.javaType.appendDeclarationTo(sb);
        }
    }

    private static class JavaToJDBCTypeMapping {
        private final JavaType javaType;
        private final JDBCType jdbcType;

        JavaToJDBCTypeMapping(JavaType javaType, JDBCType jdbcType) {
            this.javaType = javaType;
            this.jdbcType = jdbcType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public boolean maps(JavaType jt) {
            return this.javaType.equals(jt);
        }

        public boolean maps(String elementTypeName, int arrayDepth) {
            return this.javaType.equals(elementTypeName, arrayDepth);
        }

        public boolean maps(String javaClassName) {
            return this.javaType.describes(javaClassName);
        }

        public boolean maps(Class javaClass) {
            return this.javaType.describes(javaClass);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuffer sb) {
            this.javaType.appendDeclarationTo(sb);
            sb.append(" => ");
            this.jdbcType.appendTo(sb);
        }
    }
}

