/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.IPersistenceFileModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPersistenceFileModelAdapter
implements IPersistenceFileModelAdapter {
    private PersistenceFile persistenceFile;
    private ICompilationUnit compilationUnit;
    private JavaPersistentTypeModelAdapter persistentTypeModelAdapter;

    public void setPersistenceFile(PersistenceFile persistenceFile) {
        this.persistenceFile = persistenceFile;
    }

    public void engage() {
        this.compilationUnit = JavaCore.createCompilationUnitFrom((IFile)this.persistenceFile.getFile());
        this.updateModel();
    }

    public void disengage() {
        if (this.persistentTypeModelAdapter != null) {
            if (this.persistentTypeModelAdapter.getPersistentType() != null) {
                this.removePersistentType();
            } else {
                this.persistentTypeModelAdapter.disengage();
                this.persistentTypeModelAdapter = null;
            }
        }
        this.persistenceFile = null;
    }

    public void handleEvent(ElementChangedEvent event) {
        this.synchWithJavaDelta(event.getDelta());
    }

    private void updateModel() {
        this.updatePrimaryType();
    }

    private void synchWithJavaDelta(IJavaElementDelta delta) {
        boolean processChildren = false;
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                processChildren = true;
                break;
            }
            case 5: {
                break;
            }
            default: {
                return;
            }
        }
        if (processChildren) {
            ArrayIterator stream = new ArrayIterator((Object[])delta.getAffectedChildren());
            while (stream.hasNext()) {
                this.synchWithJavaDelta((IJavaElementDelta)stream.next());
            }
        }
        if (!delta.getElement().equals(this.compilationUnit)) {
            return;
        }
        if ((delta.getFlags() & 8) != 0) {
            this.updatePrimaryType();
        }
        if (this.persistentTypeModelAdapter != null) {
            CompilationUnit astRoot = this.persistentTypeModelAdapter.getType().createASTRoot();
            this.persistentTypeModelAdapter.synchWithJavaDelta(delta, astRoot);
        }
    }

    private void updatePrimaryType() {
        IType primaryType = this.compilationUnit.findPrimaryType();
        if (primaryType == null) {
            if (this.persistentTypeModelAdapter != null) {
                this.removePersistentType();
            }
            return;
        }
        CompilationUnit astRoot = JDTTools.createASTRoot((IMember)primaryType);
        if (primaryType != null && this.persistentTypeModelAdapter == null) {
            this.addPersistentType(primaryType, astRoot);
        } else if (!primaryType.equals(this.persistentTypeModelAdapter.getJDTType())) {
            this.removePersistentType();
            this.addPersistentType(primaryType, astRoot);
        }
    }

    private void addPersistentType(IType primaryType, CompilationUnit astRoot) {
        this.persistentTypeModelAdapter = new JavaPersistentTypeModelAdapter(primaryType);
        PersistentType persistentType = OrmFactory.eINSTANCE.createPersistentType(this.persistentTypeModelAdapter);
        this.persistenceFile.getPersistentTypes().add((Object)persistentType);
        this.persistentTypeModelAdapter.engage(astRoot);
    }

    private void removePersistentType() {
        PersistentType persistentType = this.persistentTypeModelAdapter.getPersistentType();
        this.persistentTypeModelAdapter.disengage();
        this.persistenceFile.getPersistentTypes().remove((Object)persistentType);
        this.persistentTypeModelAdapter = null;
    }

    public ITextRange getTextRange() {
        return null;
    }
}

