/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaGeneratedValueModelAdapter
implements IGeneratedValueModelAdapter {
    private JavaIdMappingModelAdapter parent;
    private EnumAnnotationElementAdapter strategyAdapter;
    private StringAnnotationElementAdapter specifiedGeneratorNameAdapter;
    public static final String ANNOTATION_NAME = "GeneratedValue";
    public static final String STRATEGY_ELEMENT = "strategy";
    public static final String GENERATOR_NAME_ELEMENT = "generator";
    public static final String GENERATION_TYPE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.GenerationType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATION_TYPE = ClassTools.shortNameFor((Class)clazz);
    }

    public JavaGeneratedValueModelAdapter(JavaIdMappingModelAdapter parent) {
        this.parent = parent;
        this.strategyAdapter = new EnumAnnotationElementAdapter(this.buildStrategyInfo());
        this.specifiedGeneratorNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedGeneratorNameInfo());
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildStrategyInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String generationType) {
                GenerationType genType;
                if (generationType == null) {
                    return;
                }
                if (generationType.equals("AUTO")) {
                    genType = GenerationType.AUTO_LITERAL;
                } else if (generationType.equals("SEQUENCE")) {
                    genType = GenerationType.SEQUENCE_LITERAL;
                } else if (generationType.equals("IDENTITY")) {
                    genType = GenerationType.IDENTITY_LITERAL;
                } else if (generationType.equals("TABLE")) {
                    genType = GenerationType.TABLE_LITERAL;
                } else if (generationType.equals(GenerationType.DEFAULT_LITERAL.getName())) {
                    genType = GenerationType.DEFAULT_LITERAL;
                } else {
                    return;
                }
                JavaGeneratedValueModelAdapter.this.getGeneratedValue().setStrategy(genType);
            }

            public String persValue() {
                GenerationType genType = JavaGeneratedValueModelAdapter.this.getGeneratedValue().getStrategy();
                switch (genType.getValue()) {
                    case 1: {
                        return "AUTO";
                    }
                    case 2: {
                        return "SEQUENCE";
                    }
                    case 3: {
                        return "IDENTITY";
                    }
                    case 4: {
                        return "TABLE";
                    }
                    case 0: {
                        return GenerationType.DEFAULT_LITERAL.getName();
                    }
                }
                return null;
            }

            public String enumClassName() {
                return GENERATION_TYPE;
            }

            public String annotationElementName() {
                return JavaGeneratedValueModelAdapter.STRATEGY_ELEMENT;
            }

            public String annotationName() {
                return JavaGeneratedValueModelAdapter.ANNOTATION_NAME;
            }

            public Member member() {
                return JavaGeneratedValueModelAdapter.this.parent.getAttribute();
            }

            public String defaultValue() {
                return GenerationType.DEFAULT_LITERAL.getName();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedGeneratorNameInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaGeneratedValueModelAdapter.this.getGeneratedValue().setSpecifiedGeneratorName(newValue);
            }

            public String persValue() {
                return JavaGeneratedValueModelAdapter.this.getGeneratedValue().getSpecifiedGeneratorName();
            }

            public String annotationElementName() {
                return JavaGeneratedValueModelAdapter.GENERATOR_NAME_ELEMENT;
            }

            public String annotationName() {
                return JavaGeneratedValueModelAdapter.ANNOTATION_NAME;
            }

            public Member member() {
                return JavaGeneratedValueModelAdapter.this.parent.getAttribute();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersStrategy(astRoot);
        this.updatePersSpecifiedGeneratorName(astRoot);
    }

    private void updatePersStrategy(CompilationUnit astRoot) {
        if (this.strategyAdapter.updatePersElement(astRoot)) {
            this.parent.updatePersGenerator(astRoot);
        }
    }

    public void specifiedGeneratorNameChanged() {
        this.updateJavaSpecifiedGeneratorName();
    }

    private void updateJavaSpecifiedGeneratorName() {
        this.specifiedGeneratorNameAdapter.updateJavaElement();
    }

    private void updatePersSpecifiedGeneratorName(CompilationUnit astRoot) {
        this.specifiedGeneratorNameAdapter.updatePersElement(astRoot);
    }

    public void strategyChanged() {
        this.updateJavaGenerationType();
    }

    private void updateJavaGenerationType() {
        if (this.strategyAdapter.updateJavaElement()) {
            this.parent.strategyChanged();
        }
    }

    public ITextRange getTextRange() {
        return null;
    }

    GeneratedValue getGeneratedValue() {
        return ((IdMapping)this.parent.getAttributeMapping()).getGeneratedValue();
    }
}

