/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.InheritanceType;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.adapters.IDiscriminatorColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IDiscriminatorValueModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaDiscriminatorColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaDiscriminatorValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.dali.orm.impl.SingleTableInheritanceChildTableImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaInheritanceModelAdapter
implements IInheritanceModelAdapter {
    private Inheritance inheritance;
    private Type type;
    private EnumAnnotationElementAdapter strategyAdapter;
    public static final String INHERITANCE_ANNOTATION = "Inheritance";
    public static final String INHERITANCE_TYPE_JOINED = "JOINED";
    public static final String INHERITANCE_TYPE_SINGLE_TABLE = "SINGLE_TABLE";
    public static final String INHERITANCE_TYPE_TABLE_PER_CLASS = "TABLE_PER_CLASS";

    JavaInheritanceModelAdapter(Type type) {
        this.type = type;
        this.strategyAdapter = new EnumAnnotationElementAdapter(this.buildStrategyInfo());
    }

    public void setInheritance(Inheritance inheritance) {
        this.inheritance = inheritance;
    }

    public IDiscriminatorColumnModelAdapter createDiscriminatorColumnModelAdapter() {
        return new JavaDiscriminatorColumnModelAdapter(this.type());
    }

    public IDiscriminatorValueModelAdapter createDiscriminatorValueModelAdapter() {
        return new JavaDiscriminatorValueModelAdapter(this.type());
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildStrategyInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String inheritanceType) {
                if (inheritanceType == null) {
                    return;
                }
                if (inheritanceType.equals(JavaInheritanceModelAdapter.INHERITANCE_TYPE_JOINED)) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.JOINED_LITERAL);
                } else if (inheritanceType.equals(JavaInheritanceModelAdapter.INHERITANCE_TYPE_SINGLE_TABLE)) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.SINGLE_TABLE_LITERAL);
                } else if (inheritanceType.equals(JavaInheritanceModelAdapter.INHERITANCE_TYPE_TABLE_PER_CLASS)) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.TABLE_PER_CLASS_LITERAL);
                } else if (inheritanceType.equals(InheritanceType.DEFAULT_LITERAL.getName())) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                InheritanceType inheritanceType = JavaInheritanceModelAdapter.this.getInheritance().getStrategy();
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.JOINED_LITERAL)) {
                    return JavaInheritanceModelAdapter.INHERITANCE_TYPE_JOINED;
                }
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.SINGLE_TABLE_LITERAL)) {
                    return JavaInheritanceModelAdapter.INHERITANCE_TYPE_SINGLE_TABLE;
                }
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.TABLE_PER_CLASS_LITERAL)) {
                    return JavaInheritanceModelAdapter.INHERITANCE_TYPE_TABLE_PER_CLASS;
                }
                return InheritanceType.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "InheritanceType";
            }

            public String annotationElementName() {
                return "strategy";
            }

            public String annotationName() {
                return JavaInheritanceModelAdapter.INHERITANCE_ANNOTATION;
            }

            public Member member() {
                return JavaInheritanceModelAdapter.this.type();
            }

            public String defaultValue() {
                return InheritanceType.DEFAULT_LITERAL.getName();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected Inheritance getInheritance() {
        return this.inheritance;
    }

    private JavaDiscriminatorColumnModelAdapter getDiscriminatorColumnModelAdapter() {
        return (JavaDiscriminatorColumnModelAdapter)this.inheritance.getDiscriminatorColumn().getModelAdapter();
    }

    private JavaDiscriminatorValueModelAdapter getDiscriminatorValueModelAdapter() {
        return (JavaDiscriminatorValueModelAdapter)this.inheritance.getDiscriminatorValue().getModelAdapter();
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersStrategy(astRoot);
        this.getDiscriminatorColumnModelAdapter().updatePersModel(astRoot);
        this.getDiscriminatorValueModelAdapter().updatePersModel(astRoot);
    }

    void postUpdatePersModel(CompilationUnit astRoot) {
        this.updateEntityTable(astRoot);
    }

    private void updateEntityTable(CompilationUnit astRoot) {
        Entity entity = (Entity)this.getInheritance().getParent();
        InheritanceType rootStrategy = this.getInheritance().rootEntity().getInheritance().getStrategy();
        if (rootStrategy == InheritanceType.SINGLE_TABLE_LITERAL || rootStrategy == InheritanceType.DEFAULT_LITERAL) {
            if (this.getInheritance().rootEntity() != entity) {
                if (!(entity.getTable() instanceof SingleTableInheritanceChildTableImpl)) {
                    JavaTableModelAdapter tableModelAdapter = this.buildNoUpdateJavaTableModelAdapter();
                    Table table = OrmFactory.eINSTANCE.createSingleTableInheritanceChildTable(tableModelAdapter);
                    entity.setTable(table);
                    tableModelAdapter.updatePersModel(astRoot);
                    tableModelAdapter.postUpdatePersModel(astRoot);
                }
            } else if (entity.getTable() instanceof SingleTableInheritanceChildTableImpl) {
                JavaTableModelAdapter tableModelAdapter = (JavaTableModelAdapter)((IEntityModelAdapter)entity.getModelAdapter()).createTableModelAdapter();
                Table table = OrmFactory.eINSTANCE.createTable(tableModelAdapter);
                tableModelAdapter.updatePersModel(astRoot);
                entity.setTable(table);
                tableModelAdapter.postUpdatePersModel(astRoot);
            }
        } else if (entity.getTable() instanceof SingleTableInheritanceChildTableImpl) {
            JavaTableModelAdapter tableModelAdapter = (JavaTableModelAdapter)((IEntityModelAdapter)entity.getModelAdapter()).createTableModelAdapter();
            Table table = OrmFactory.eINSTANCE.createTable(tableModelAdapter);
            tableModelAdapter.updatePersModel(astRoot);
            entity.setTable(table);
            tableModelAdapter.postUpdatePersModel(astRoot);
        }
    }

    private JavaTableModelAdapter buildNoUpdateJavaTableModelAdapter() {
        return new JavaTableModelAdapter(this.type()){

            public void specifiedNameChanged() {
            }

            protected String defaultName() {
                return JavaInheritanceModelAdapter.this.getInheritance().rootEntity().getName();
            }
        };
    }

    private void updatePersStrategy(CompilationUnit astRoot) {
        this.strategyAdapter.updatePersElement(astRoot);
    }

    public void strategyChanged() {
        boolean changed = this.strategyAdapter.updateJavaElement();
        if (changed) {
            this.updateEntityTable(this.type().createASTRoot());
        }
    }

    protected Type type() {
        return this.type;
    }

    public ITextRange getTextRange() {
        return this.type().getTextRange(this.annotationName());
    }

    protected String annotationName() {
        return INHERITANCE_ANNOTATION;
    }

    public boolean specifyDiscriminatorValue() {
        return !this.type().isAbstract();
    }
}

