/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.CompositeIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.IPersistenceFileModelAdapter;
import org.eclipse.dali.orm.adapters.IPersistenceModelAdapter;
import org.eclipse.dali.orm.impl.PersistenceResourceImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class PersistenceFileImpl
extends PersistenceResourceImpl
implements PersistenceFile {
    protected EList persistentTypes = null;
    private IPersistenceFileModelAdapter modelAdapter;
    static /* synthetic */ Class class$0;

    protected PersistenceFileImpl() {
    }

    protected PersistenceFileImpl(IFile file, IPersistenceFileModelAdapter modelAdapter) {
        super((IResource)file);
        this.modelAdapter = modelAdapter;
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.PERSISTENCE_FILE;
    }

    public EList getPersistentTypes() {
        if (this.persistentTypes == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dali.orm.PersistentType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.persistentTypes = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 0);
        }
        return this.persistentTypes;
    }

    public void engageModel() {
        this.modelAdapter.updatePersModel();
    }

    public void postEngageModel() {
        this.modelAdapter.postUpdatePersModel();
    }

    public IFile getFile() {
        return (IFile)this.getResource();
    }

    public PersistenceFile getPersistenceFile() {
        return this;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getPersistentTypes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPersistentTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getPersistentTypes().clear();
                this.getPersistentTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getPersistentTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.persistentTypes != null && !this.persistentTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public ITextRange getTextRange() {
        return this.modelAdapter.getTextRange();
    }

    public IPersistenceModelAdapter getModelAdapter() {
        return this.modelAdapter;
    }

    public void handleEvent(ElementChangedEvent event) {
        this.modelAdapter.handleEvent(event);
    }

    public final Iterator problems() {
        ArrayList problems = new ArrayList();
        this.addProblemsTo(problems);
        return problems.iterator();
    }

    public PersistentType resolvePersistentType(String persistentTypeName) {
        IType itype;
        block6: {
            PersistentType ptype = PersistenceFileImpl.selectPersistentType((List)this.getPersistentTypes(), persistentTypeName);
            if (ptype != null) {
                return ptype;
            }
            try {
                itype = this.getJavaProject().findType(persistentTypeName);
                if (itype != null) break block6;
                return null;
            }
            catch (JavaModelException javaModelException) {}
        }
        IResource resource = itype.getResource();
        if (resource instanceof IFile) {
            DaliPlugin.getPlugin();
            PersistenceFile pfile = DaliPlugin.getPersistenceFile((IFile)resource);
            if (pfile != null) {
                return PersistenceFileImpl.selectPersistentType((List)pfile.getPersistentTypes(), persistentTypeName);
            }
        }
        return null;
    }

    private static PersistentType selectPersistentType(List persistentTypes, String persistentTypeName) {
        Iterator stream = persistentTypes.iterator();
        while (stream.hasNext()) {
            PersistentType ptype = (PersistentType)stream.next();
            if (!persistentTypeName.equals(ptype.getClassName())) continue;
            return ptype;
        }
        return null;
    }

    public PersistentAttribute resolvePersistentAttribute(String persistentTypeName, String persistentAttributeName) {
        PersistentType ptype = this.resolvePersistentType(persistentTypeName);
        if (ptype == null) {
            return null;
        }
        return PersistenceFileImpl.selectPersistentAttribute((List)ptype.getPersistentAttributes(), persistentAttributeName);
    }

    private static PersistentAttribute selectPersistentAttribute(List persistentAttributes, String persistentAttributeName) {
        Iterator stream = persistentAttributes.iterator();
        while (stream.hasNext()) {
            PersistentAttribute pattribute = (PersistentAttribute)stream.next();
            if (!persistentAttributeName.equals(pattribute.getName())) continue;
            return pattribute;
        }
        return null;
    }

    protected void addProblemsTo(List problems) {
        CollectionTools.addAll((Collection)problems, (Iterator)new CompositeIterator(this.persistentTypeProblems()));
    }

    private Iterator persistentTypeProblems() {
        return new TransformationIterator(this.getPersistentTypes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentType)next).problems();
            }
        };
    }

    public PersistenceSourceRefElement persistenceObjectAt(int offset) {
        Iterator i = this.getPersistentTypes().iterator();
        while (i.hasNext()) {
            PersistenceSourceRefElement object = ((PersistentType)i.next()).persistenceObjectAt(offset);
            if (object == null) continue;
            return object;
        }
        return this;
    }
}

