/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.provider.ColumnItemProvider;
import org.eclipse.dali.orm.provider.EntityItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.TableItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ColumnComposite
extends Composite
implements IPersistenceComposite {
    private Column column;
    private TypeMapping typeMapping;
    private ColumnItemProvider columnItemProvider;
    private EntityItemProvider entityItemProvider;
    private TableItemProvider tableItemProvider;
    private INotifyChangedListener columnListener;
    private INotifyChangedListener entityListener;
    private INotifyChangedListener tableListener;
    protected EditingDomain editingDomain;
    protected Combo columnCombo;
    protected Combo tableCombo;
    protected boolean populating;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ColumnComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory, String columnHelpContextId) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.columnItemProvider = (ColumnItemProvider)adapterFactory.createColumnAdapter();
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.tableItemProvider = (TableItemProvider)adapterFactory.createTableAdapter();
        this.initializeLayout(columnHelpContextId);
    }

    private void initializeLayout(String columnHelpContextId) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group columnGroup = new Group((Composite)this, 16);
        columnGroup.setText(DaliUiMessages.ColumnComposite_columnSection);
        columnGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        columnGroup.setLayoutData((Object)gridData);
        Label columnLabel = new Label((Composite)columnGroup, 16384);
        columnLabel.setText(DaliUiMessages.ColumnComposite_column);
        this.columnCombo = this.buildColumnCombo((Composite)columnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.columnCombo, columnHelpContextId);
        Label tableNameLabel = new Label((Composite)columnGroup, 16384);
        tableNameLabel.setText(DaliUiMessages.ColumnComposite_tableName);
        this.tableCombo = this.buildTableCombo((Composite)columnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableCombo, columnHelpContextId);
    }

    private Combo buildColumnCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColumnComposite.this.populating) {
                    return;
                }
                String columnText = ((Combo)e.getSource()).getText();
                if (columnText.equals("")) {
                    columnText = null;
                    if (ColumnComposite.this.column.getSpecifiedName() == null || ColumnComposite.this.column.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (columnText != null && combo.getItemCount() > 0 && columnText.equals(combo.getItem(0))) {
                    columnText = null;
                }
                if (ColumnComposite.this.column.getSpecifiedName() == null || !ColumnComposite.this.stringsAreEqual(ColumnComposite.this.column.getSpecifiedName(), columnText)) {
                    ColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ColumnComposite.this.editingDomain, (Object)ColumnComposite.this.column, (Object)OrmPackage.eINSTANCE.getColumn_SpecifiedName(), (Object)columnText));
                }
            }
        });
        return combo;
    }

    private Combo buildTableCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColumnComposite.this.populating) {
                    return;
                }
                String newTableName = ((Combo)e.getSource()).getText();
                if (newTableName.equals("")) {
                    newTableName = null;
                    if (ColumnComposite.this.column.getSpecifiedTableName() == null || ColumnComposite.this.column.getSpecifiedTableName().equals("")) {
                        return;
                    }
                }
                if (newTableName != null && combo.getItemCount() > 0 && newTableName.equals(combo.getItem(0))) {
                    newTableName = null;
                }
                if (ColumnComposite.this.column.getSpecifiedTableName() == null || !ColumnComposite.this.stringsAreEqual(ColumnComposite.this.column.getSpecifiedTableName(), newTableName)) {
                    ColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ColumnComposite.this.editingDomain, (Object)ColumnComposite.this.column, (Object)OrmPackage.eINSTANCE.getColumn_SpecifiedTableName(), (Object)newTableName));
                }
            }
        });
        return combo;
    }

    private INotifyChangedListener getColumnListener() {
        if (this.columnListener == null) {
            this.columnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    ColumnComposite.this.columnChanged(notification);
                }
            };
        }
        return this.columnListener;
    }

    protected void columnChanged(Notification notification) {
        if (this.populating || notification.getNotifier() != this.column) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 1) {
            final String columnName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ColumnComposite.this.populating = true;
                    if (ColumnComposite.this.columnCombo.getText() == null || !ColumnComposite.this.columnCombo.getText().equals(columnName)) {
                        if (columnName == null) {
                            ColumnComposite.this.columnCombo.select(0);
                        } else {
                            ColumnComposite.this.columnCombo.setText(columnName);
                        }
                    }
                    ColumnComposite.this.populating = false;
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.Column");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 0) {
                final String defaultColumnName = (String)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        int selectionIndex = ColumnComposite.this.columnCombo.getSelectionIndex();
                        ColumnComposite.this.columnCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName));
                        if (selectionIndex == 0) {
                            ColumnComposite.this.columnCombo.select(0);
                        }
                        ColumnComposite.this.populating = false;
                    }
                });
            } else {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.dali.orm.Column");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 8) {
                    String cfr_ignored_0 = (String)notification.getNewValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ColumnComposite.this.populating = true;
                            ColumnComposite.this.populateColumnCombo();
                            ColumnComposite.this.populateTableSelectionAndDefault();
                            ColumnComposite.this.populating = false;
                        }
                    });
                } else {
                    Class<?> clazz4 = class$0;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$0 = Class.forName("org.eclipse.dali.orm.Column");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz4) == 9) {
                        String cfr_ignored_1 = (String)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                ColumnComposite.this.populating = true;
                                ColumnComposite.this.populateColumnCombo();
                                ColumnComposite.this.populateTableSelectionAndDefault();
                                ColumnComposite.this.populating = false;
                            }
                        });
                    }
                }
            }
        }
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    ColumnComposite.this.entityChanged(notification);
                }
            };
        }
        return this.entityListener;
    }

    protected void entityChanged(Notification notification) {
        if (this.populating) {
            return;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.Entity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 3) {
            Table oldTable = (Table)notification.getOldValue();
            Table newTable = (Table)notification.getNewValue();
            if (oldTable != null) {
                oldTable.eAdapters().remove((Object)this.tableItemProvider);
            }
            if (newTable != null) {
                newTable.eAdapters().add((Object)this.tableItemProvider);
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ColumnComposite.this.populating = true;
                    ColumnComposite.this.populateTableComboChoices();
                    ColumnComposite.this.populating = false;
                }
            });
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.dali.orm.Entity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 4) {
                if (notification.getEventType() == 3) {
                    Table table = (Table)notification.getNewValue();
                    table.eAdapters().add((Object)this.tableItemProvider);
                } else if (notification.getEventType() == 5) {
                    List list = (List)notification.getNewValue();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        Table table = (Table)i.next();
                        table.eAdapters().add((Object)this.tableItemProvider);
                    }
                } else if (notification.getEventType() == 4) {
                    Table table = (Table)notification.getOldValue();
                    table.eAdapters().remove((Object)this.tableItemProvider);
                } else if (notification.getEventType() == 6) {
                    List list = (List)notification.getOldValue();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        Table table = (Table)i.next();
                        table.eAdapters().remove((Object)this.tableItemProvider);
                    }
                }
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        ColumnComposite.this.populateTableComboChoices();
                        ColumnComposite.this.populating = false;
                    }
                });
            }
        }
    }

    private INotifyChangedListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    ColumnComposite.this.tableChanged(notification);
                }
            };
        }
        return this.tableListener;
    }

    protected void tableChanged(Notification notification) {
        block13: {
            block12: {
                if (this.populating) {
                    return;
                }
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.dali.orm.Table");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 1) break block12;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.dali.orm.Table");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) != 0) break block13;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ColumnComposite.this.populating = true;
                    ColumnComposite.this.populateTableComboChoices();
                    ColumnComposite.this.populating = false;
                }
            });
        }
    }

    public void populate(EObject model) {
        Iterator i;
        this.populating = true;
        if (this.column != null) {
            this.columnItemProvider.removeListener(this.getColumnListener());
            this.column.eAdapters().remove((Object)this.columnItemProvider);
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.typeMapping.eAdapters().remove((Object)this.entityItemProvider);
            this.tableItemProvider.removeListener(this.getTableListener());
            i = this.typeMapping.associatedTablesIncludingInherited();
            while (i.hasNext()) {
                ((Table)i.next()).eAdapters().remove((Object)this.tableItemProvider);
            }
        }
        this.column = (Column)model;
        if (this.column == null) {
            this.typeMapping = null;
            return;
        }
        this.columnItemProvider.addListener(this.getColumnListener());
        this.column.eAdapters().add((Object)this.columnItemProvider);
        this.entityItemProvider.addListener(this.getEntityListener());
        this.typeMapping = ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTypeMapping();
        this.typeMapping.eAdapters().add((Object)this.entityItemProvider);
        this.tableItemProvider.addListener(this.getTableListener());
        i = this.typeMapping.associatedTables();
        while (i.hasNext()) {
            ((Table)i.next()).eAdapters().add((Object)this.tableItemProvider);
        }
        this.populateColumnCombo();
        this.populateTableCombo();
        this.populating = false;
    }

    private org.eclipse.dali.db.Table getDbTable() {
        return ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTableNamed(this.column.getTableName());
    }

    private void populateColumnCombo() {
        String columnName = this.column.getSpecifiedName();
        String defaultColumnName = this.column.getDefaultName();
        this.columnCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName));
        PersistenceProject persistenceProject = this.column.getPersistenceProject();
        Connection connection = persistenceProject.getConnection();
        if (connection.isConnected()) {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
            org.eclipse.dali.db.Table table = this.getDbTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.columnCombo.add((String)i.next());
                }
            }
        } else {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
        }
        if (columnName != null) {
            if (!this.columnCombo.getText().equals(columnName)) {
                this.columnCombo.setText(columnName);
            }
        } else if (!this.columnCombo.getText().equals(NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName))) {
            this.columnCombo.select(0);
        }
    }

    private Iterator associatedTableNames() {
        return ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTypeMapping().associatedTableIncludingInheritedNames();
    }

    private void populateTableCombo() {
        this.populateTableComboChoices();
        this.populateTableSelectionAndDefault();
    }

    private void populateTableSelectionAndDefault() {
        String specifiedTableName = this.column.getSpecifiedTableName();
        String defaultTableName = this.column.getDefaultTableName();
        this.tableCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName));
        if (specifiedTableName != null) {
            if (!this.stringsAreEqual(this.tableCombo.getText(), specifiedTableName)) {
                this.tableCombo.setText(specifiedTableName);
            }
        } else if (!this.stringsAreEqual(this.tableCombo.getText(), NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName))) {
            this.tableCombo.select(0);
        }
    }

    private void populateTableComboChoices() {
        String initialText = this.tableCombo.getText();
        this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
        Iterator tables = this.associatedTableNames();
        while (tables.hasNext()) {
            String table = (String)tables.next();
            this.tableCombo.add(table);
        }
        if (!this.tableCombo.getText().equals(initialText)) {
            this.columnCombo.setText(initialText);
        }
    }

    public void dispose() {
        if (this.column != null) {
            this.column.eAdapters().remove((Object)this.columnItemProvider);
            this.typeMapping.eAdapters().remove((Object)this.entityItemProvider);
            Iterator tables = this.typeMapping.associatedTablesIncludingInherited();
            while (tables.hasNext()) {
                ((Table)tables.next()).eAdapters().remove((Object)this.tableItemProvider);
            }
        }
        super.dispose();
    }

    private boolean stringsAreEqual(String string1, String string2) {
        if (this.ignoreCase()) {
            return StringTools.stringsAreEqualIgnoreCase((String)string1, (String)string2);
        }
        return string1.equals(string2);
    }

    private boolean ignoreCase() {
        return true;
    }
}

