/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.Generator;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.provider.IdMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.GeneratedValueComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.SequenceGeneratorComposite;
import org.eclipse.dali.ui.views.TableGeneratorComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class IdMappingComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private GeneratedValueComposite generatedValueComposite;
    private PageBook generatorComposite;
    private ColumnComposite columnComposite;
    private TableGeneratorComposite tableGeneratorComposite;
    private SequenceGeneratorComposite sequenceGeneratorComposite;
    private Composite emptyComposite;
    private IdMapping idMapping;
    private INotifyChangedListener idListener;
    private ConnectionListener connectionListener;
    EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private IdMappingItemProvider idItemProvider;
    static /* synthetic */ Class class$0;

    protected IdMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.idItemProvider = (IdMappingItemProvider)this.adapterFactory.createIdMappingAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_column");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
        this.generatedValueComposite = new GeneratedValueComposite(this, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.generatedValueComposite.setLayoutData(gridData);
        this.generatorComposite = new PageBook((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.generatorComposite.setLayoutData((Object)gridData);
        this.tableGeneratorComposite = new TableGeneratorComposite((Composite)this.generatorComposite, this.editingDomain, this.adapterFactory);
        this.sequenceGeneratorComposite = new SequenceGeneratorComposite((Composite)this.generatorComposite, this.editingDomain, this.adapterFactory);
        this.emptyComposite = new Composite((Composite)this.generatorComposite, 0);
        this.generatorComposite.showPage((Control)this.emptyComposite);
    }

    protected void updateGeneratorComposite(GenerationType newGenerationType) {
        if (newGenerationType.getValue() == 4) {
            this.tableGeneratorComposite.populate((EObject)this.idMapping.getGenerator());
            this.generatorComposite.showPage((Control)this.tableGeneratorComposite);
        } else if (newGenerationType.getValue() == 2) {
            this.sequenceGeneratorComposite.populate((EObject)this.idMapping.getGenerator());
            this.generatorComposite.showPage((Control)this.sequenceGeneratorComposite);
        }
    }

    protected void removeGeneratorComposite() {
        this.tableGeneratorComposite.populate(null);
        this.sequenceGeneratorComposite.populate(null);
        this.idMapping.setGenerator(null);
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.idMapping != null) {
            this.idItemProvider.removeListener(this.getIdListener());
            this.idMapping.eAdapters().remove((Object)this.idItemProvider);
        }
        if (model == null) {
            this.idMapping = null;
            this.generatedValueComposite.populate(null);
            this.tableGeneratorComposite.populate(null);
            this.columnComposite.populate(null);
            this.populating = false;
            return;
        }
        this.idMapping = (IdMapping)((PersistentAttribute)model).getAttributeMapping();
        this.idItemProvider.addListener(this.getIdListener());
        this.idMapping.eAdapters().add((Object)this.idItemProvider);
        this.generatedValueComposite.populate((EObject)this.idMapping.getGeneratedValue());
        if (this.idMapping.getGeneratedValue() != null) {
            this.updateGeneratorComposite(this.idMapping.getGeneratedValue().getStrategy());
        }
        this.populateColumnCombo();
        this.populating = false;
    }

    private void populateColumnCombo() {
        this.addConnectionListener();
        if (this.idMapping == null) {
            this.columnComposite.populate(null);
        } else {
            this.columnComposite.populate((EObject)this.idMapping.getColumn());
        }
    }

    private INotifyChangedListener getIdListener() {
        if (this.idListener == null) {
            this.idListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    IdMappingComposite.this.idChanged(notification);
                }
            };
        }
        return this.idListener;
    }

    protected void idChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.IdMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 1) {
            Generator cfr_ignored_0 = (Generator)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IdMappingComposite.this.updateGeneratorComposite(IdMappingComposite.this.idMapping.getGeneratedValue().getStrategy());
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.IdMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 2) {
                final GeneratedValue generatedValue = (GeneratedValue)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IdMappingComposite.this.updateGeneratorComposite(generatedValue.getStrategy());
                    }
                });
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.removeConnectionListener();
    }

    private void addConnectionListener() {
        if (this.connectionListener == null) {
            Connection connection = this.idMapping.getPersistenceProject().getConnection();
            this.connectionListener = this.buildConnectionListener(connection);
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.idMapping.getPersistenceProject().getConnection().removeConnectionListener(this.connectionListener);
            this.connectionListener = null;
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    IdMappingComposite.this.populateColumnCombo();
                }
            }

            public void disconnected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    IdMappingComposite.this.populateColumnCombo();
                }
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                IdMappingComposite.this.populateColumnCombo();
            }

            public void tableChanged(Table table) {
                if (IdMappingComposite.this.idMapping != null && table.getName().equalsIgnoreCase(IdMappingComposite.this.idMapping.getColumn().getTableName())) {
                    IdMappingComposite.this.populateColumnCombo();
                }
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    IdMappingComposite.this.populateColumnCombo();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    IdMappingComposite.this.populateColumnCombo();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }

            public void dispose() {
            }
        };
    }

    public static class IdMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new IdMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

