/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JoinColumnInJoinTableDialog
extends Dialog {
    private JoinColumn joinColumn;
    private JoinTable joinTable;
    private Combo nameCombo;
    private Combo referencedColumnNameCombo;
    private boolean defaultNameSelected;
    private String selectedName;
    private boolean defaultReferencedColumnNameSelected;
    private String selectedReferencedColumnName;

    JoinColumnInJoinTableDialog(Shell parent, JoinTable joinTable) {
        super(parent);
        this.joinTable = joinTable;
    }

    JoinColumnInJoinTableDialog(Shell parent, JoinColumn joinColumn) {
        super(parent);
        this.joinColumn = joinColumn;
        this.joinTable = (JoinTable)joinColumn.eContainer();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return DaliUiMessages.JoinColumnDialog_editJoinColumn;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(DaliUiMessages.JoinColumnDialog_name);
        GridData gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        this.nameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameCombo, "org.eclipse.dali.ui.mapping_joinColumnName");
        this.populateNameCombo(this.nameCombo);
        Label referencedColumnNameLabel = new Label(composite, 16384);
        referencedColumnNameLabel.setText(DaliUiMessages.JoinColumnDialog_referencedColumnName);
        gridData = new GridData();
        referencedColumnNameLabel.setLayoutData((Object)gridData);
        this.referencedColumnNameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.referencedColumnNameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.referencedColumnNameCombo, "org.eclipse.dali.ui.mapping_joinReferencedColumn");
        this.populateReferencedNameCombo(this.referencedColumnNameCombo);
        return composite;
    }

    protected JoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void populateNameCombo(Combo nameCombo) {
        Table joinDBTable;
        if (this.getJoinColumn() != null) {
            nameCombo.add(NLS.bind((String)DaliUiMessages.JoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultName()));
        }
        if ((joinDBTable = this.getJoinTable().getDBTable()) != null) {
            Iterator i = joinDBTable.columnNames();
            while (i.hasNext()) {
                nameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn() != null) {
            if (this.getJoinColumn().getSpecifiedName() != null) {
                nameCombo.setText(this.getJoinColumn().getSpecifiedName());
            } else {
                nameCombo.select(0);
            }
        }
    }

    protected void populateReferencedNameCombo(Combo referencedColumnNameCombo) {
        MultiRelationshipMapping multiRelationshipMapping;
        Table referencedDbTable;
        if (this.getJoinColumn() != null) {
            referencedColumnNameCombo.add(NLS.bind((String)DaliUiMessages.JoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultReferencedColumnName()));
        }
        if ((referencedDbTable = (multiRelationshipMapping = (MultiRelationshipMapping)this.getJoinTable().getParent()).getTypeMapping().getResolvedDBTable()) != null) {
            Iterator i = referencedDbTable.columnNames();
            while (i.hasNext()) {
                referencedColumnNameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn() != null) {
            if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
                referencedColumnNameCombo.setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
            } else {
                referencedColumnNameCombo.select(0);
            }
        }
    }

    protected JoinColumn getJoinColumn() {
        return this.joinColumn;
    }

    protected boolean isDefaultNameSelected() {
        return this.defaultNameSelected;
    }

    protected String getSelectedName() {
        return this.selectedName;
    }

    protected boolean isDefaultReferencedColumnNameSelected() {
        return this.defaultReferencedColumnNameSelected;
    }

    protected String getReferencedColumnName() {
        return this.selectedReferencedColumnName;
    }

    public boolean close() {
        this.defaultNameSelected = this.nameCombo.getSelectionIndex() == 0;
        this.selectedName = this.nameCombo.getText();
        this.defaultReferencedColumnNameSelected = this.referencedColumnNameCombo.getSelectionIndex() == 0;
        this.selectedReferencedColumnName = this.referencedColumnNameCombo.getText();
        return super.close();
    }
}

