/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IJoinTableModelAdapter;
import org.eclipse.dali.orm.provider.JoinColumnItemProvider;
import org.eclipse.dali.orm.provider.JoinTableItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.InverseJoinColumnDialog;
import org.eclipse.dali.ui.views.JoinColumnInJoinTableDialog;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JoinTableComposite
extends Composite
implements IPersistenceComposite {
    private JoinTable joinTable;
    private JoinTableItemProvider joinTableItemProvider;
    private INotifyChangedListener tableListener;
    protected EditingDomain editingDomain;
    protected Combo tableCombo;
    protected boolean populating;
    private ListViewer joinColumnsListViewer;
    private ListViewer inverseJoinColumnsListViewer;
    private JoinColumnItemProvider joinColumnItemProvider;
    private INotifyChangedListener joinColumnListener;
    private INotifyChangedListener inverseJoinColumnListener;
    private Group joinColumnsGroup;
    private Button overrideDefaultJoinColumnsCheckBox;
    private Button joinColumnsRemoveButton;
    private Button joinColumnsEditButton;
    private Group inverseJoinColumnsGroup;
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private Button inverseJoinColumnsRemoveButton;
    private Button inverseJoinColumnsEditButton;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JoinTableComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.joinTableItemProvider = (JoinTableItemProvider)adapterFactory.createJoinTableAdapter();
        this.joinColumnItemProvider = (JoinColumnItemProvider)adapterFactory.createJoinColumnAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        Composite tableComboComposite = new Composite((Composite)this, 0);
        tableComboComposite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        tableComboComposite.setLayoutData((Object)gridData);
        Label tableLabel = new Label(tableComboComposite, 16384);
        tableLabel.setText(DaliUiMessages.JoinTableComposite_name);
        this.tableCombo = this.buildTableCombo(tableComboComposite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableCombo, "org.eclipse.dali.ui.mapping_joinTableName");
        this.overrideDefaultJoinColumnsCheckBox = new Button((Composite)this, 32);
        this.overrideDefaultJoinColumnsCheckBox.setText(DaliUiMessages.JoinTableComposite_overrideDefaultJoinColumns);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinTableComposite.this.editingDomain, (Object)JoinTableComposite.this.joinTable, (Object)OrmPackage.eINSTANCE.getJoinTable_DefaultJoinColumns(), (Object)(!JoinTableComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection() ? 1 : 0)));
            }
        });
        this.joinColumnsGroup = new Group((Composite)this, 16);
        this.joinColumnsGroup.setText(DaliUiMessages.JoinTableComposite_joinColumn);
        this.joinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.joinColumnsGroup.setLayoutData((Object)gridData);
        this.joinColumnsListViewer = new ListViewer((Composite)this.joinColumnsGroup, 2050);
        this.joinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.joinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinColumnsListViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.joinColumnsListViewer.getList(), "org.eclipse.dali.ui.mapping_joinTableJoinColumns");
        Button addJoinColumnButton = new Button((Composite)this.joinColumnsGroup, 0);
        addJoinColumnButton.setText(DaliUiMessages.JoinTableComposite_add);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addJoinColumnButton.setLayoutData((Object)gridData);
        addJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.addJoinColumn();
            }
        });
        this.joinColumnsEditButton = new Button((Composite)this.joinColumnsGroup, 0);
        this.joinColumnsEditButton.setText(DaliUiMessages.JoinTableComposite_edit);
        this.joinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.editJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.joinColumnsEditButton.setLayoutData((Object)gridData);
        this.joinColumnsRemoveButton = new Button((Composite)this.joinColumnsGroup, 0);
        this.joinColumnsRemoveButton.setText(DaliUiMessages.JoinTableComposite_remove);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.joinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.joinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.removeJoinColumn();
            }
        });
        this.joinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JoinTableComposite.this.updateJoinColumnsEnablement();
            }
        });
        this.overrideDefaultInverseJoinColumnsCheckBox = new Button((Composite)this, 32);
        this.overrideDefaultInverseJoinColumnsCheckBox.setText(DaliUiMessages.JoinTableComposite_overrideDefaultInverseJoinColumns);
        this.overrideDefaultInverseJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinTableComposite.this.editingDomain, (Object)JoinTableComposite.this.joinTable, (Object)OrmPackage.eINSTANCE.getJoinTable_DefaultInverseJoinColumns(), (Object)(!JoinTableComposite.this.overrideDefaultInverseJoinColumnsCheckBox.getSelection() ? 1 : 0)));
            }
        });
        this.inverseJoinColumnsGroup = new Group((Composite)this, 16);
        this.inverseJoinColumnsGroup.setText(DaliUiMessages.JoinTableComposite_inverseJoinColumn);
        this.inverseJoinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.inverseJoinColumnsGroup.setLayoutData((Object)gridData);
        this.inverseJoinColumnsListViewer = new ListViewer((Composite)this.inverseJoinColumnsGroup, 2050);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.inverseJoinColumnsListViewer.getList().setLayoutData((Object)gridData);
        this.inverseJoinColumnsListViewer.setContentProvider(this.buildInverseJoinColumnsListContentProvider());
        this.inverseJoinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildInverseJoinColumnsListLabelProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.inverseJoinColumnsListViewer.getList(), "org.eclipse.dali.ui.mapping_joinTableInverseJoinColumns");
        Button addInverseJoinColumnButton = new Button((Composite)this.inverseJoinColumnsGroup, 0);
        addInverseJoinColumnButton.setText(DaliUiMessages.JoinTableComposite_add);
        addInverseJoinColumnButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addInverseJoinColumnButton.setLayoutData((Object)gridData);
        addInverseJoinColumnButton.setLayoutData((Object)gridData);
        addInverseJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.addInverseJoinColumn();
            }
        });
        this.inverseJoinColumnsEditButton = new Button((Composite)this.inverseJoinColumnsGroup, 0);
        this.inverseJoinColumnsEditButton.setText(DaliUiMessages.JoinTableComposite_edit);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.inverseJoinColumnsEditButton.setLayoutData((Object)gridData);
        this.inverseJoinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.editInverseJoinColumn();
            }
        });
        this.inverseJoinColumnsRemoveButton = new Button((Composite)this.inverseJoinColumnsGroup, 0);
        this.inverseJoinColumnsRemoveButton.setText(DaliUiMessages.JoinTableComposite_remove);
        this.inverseJoinColumnsRemoveButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.inverseJoinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.inverseJoinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.removeInverseJoinColumn();
            }
        });
        this.inverseJoinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JoinTableComposite.this.updateInverseJoinColumnsEnablement();
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((JoinTable)inputElement).getJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                if (JoinTableComposite.this.joinTable.isDefaultJoinColumns()) {
                    return JoinTableComposite.this.buildDefaultJoinColumnLabel(joinColumn);
                }
                return JoinTableComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private String buildDefaultJoinColumnLabel(JoinColumn joinColumn) {
        return NLS.bind((String)DaliUiMessages.JoinTableComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private String buildJoinColumnLabel(JoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)DaliUiMessages.JoinTableComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)DaliUiMessages.JoinTableComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)DaliUiMessages.JoinTableComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)DaliUiMessages.JoinTableComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private ILabelProvider buildInverseJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                if (JoinTableComposite.this.joinTable.isDefaultInverseJoinColumns()) {
                    return JoinTableComposite.this.buildDefaultJoinColumnLabel(joinColumn);
                }
                return JoinTableComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private IContentProvider buildInverseJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((JoinTable)inputElement).getInverseJoinColumns().toArray();
            }
        };
    }

    private Combo buildTableCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.JoinTableComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JoinTableComposite.this.populating) {
                    return;
                }
                String tableText = ((Combo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (JoinTableComposite.this.joinTable.getSpecifiedName() == null || JoinTableComposite.this.joinTable.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (tableText != null && combo.getItemCount() > 0 && tableText.equals(combo.getItem(0))) {
                    tableText = null;
                }
                if (JoinTableComposite.this.joinTable.getSpecifiedName() == null || !JoinTableComposite.this.joinTable.getSpecifiedName().equals(tableText)) {
                    JoinTableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinTableComposite.this.editingDomain, (Object)JoinTableComposite.this.joinTable, (Object)OrmPackage.eINSTANCE.getTable_SpecifiedName(), (Object)tableText));
                }
            }
        });
        return combo;
    }

    private PersistenceProject getPersistenceProject() {
        return this.joinTable.getPersistenceProject();
    }

    private void addJoinColumn() {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.getShell(), this.joinTable);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(JoinColumnInJoinTableDialog dialog) {
        if (dialog.open() == 0) {
            IJoinColumnModelAdapter columnModelAdapter = ((IJoinTableModelAdapter)this.joinTable.getModelAdapter()).buildJoinColumnModelAdapter();
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(columnModelAdapter);
            this.editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.joinTable, (Object)OrmPackage.eINSTANCE.getJoinTable_JoinColumns(), (Object)joinColumn));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)name));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private void addInverseJoinColumn() {
        InverseJoinColumnDialog dialog = new InverseJoinColumnDialog(this.getShell(), this.joinTable);
        this.addInverseJoinColumnFromDialog(dialog);
    }

    private void addInverseJoinColumnFromDialog(InverseJoinColumnDialog dialog) {
        if (dialog.open() == 0) {
            IJoinColumnModelAdapter columnModelAdapter = ((IJoinTableModelAdapter)this.joinTable.getModelAdapter()).buildInverseJoinColumnModelAdapter();
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(columnModelAdapter);
            this.editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.joinTable, (Object)OrmPackage.eINSTANCE.getJoinTable_InverseJoinColumns(), (Object)joinColumn));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)name));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private void editJoinColumn() {
        JoinColumn joinColumn = this.getSelectedJoinColumn();
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void editJoinColumnFromDialog(JoinColumnInJoinTableDialog dialog, JoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(JoinColumnInJoinTableDialog dialog, JoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), null));
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)name));
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), null));
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private void editInverseJoinColumn() {
        JoinColumn joinColumn = this.getSelectedInverseJoinColumn();
        InverseJoinColumnDialog dialog = new InverseJoinColumnDialog(this.getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void removeJoinColumn() {
        ISelection selection = this.joinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.joinTable.getJoinColumns().remove((Object)((JoinColumn)i.next()));
            }
        }
    }

    private void removeInverseJoinColumn() {
        ISelection selection = this.inverseJoinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.joinTable.getInverseJoinColumns().remove((Object)((JoinColumn)i.next()));
            }
        }
    }

    private JoinColumn getSelectedJoinColumn() {
        return (JoinColumn)((StructuredSelection)this.joinColumnsListViewer.getSelection()).getFirstElement();
    }

    private JoinColumn getSelectedInverseJoinColumn() {
        return (JoinColumn)((StructuredSelection)this.inverseJoinColumnsListViewer.getSelection()).getFirstElement();
    }

    private INotifyChangedListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinTableComposite.this.tableChanged(notification);
                }
            };
        }
        return this.tableListener;
    }

    protected void tableChanged(Notification notification) {
        block31: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block30: {
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("org.eclipse.dali.orm.JoinTable");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (notification.getFeatureID((Class)clazz) != 1) break block30;
                                final String tableName = (String)notification.getNewValue();
                                Display.getDefault().syncExec(new Runnable(){

                                    public void run() {
                                        if (JoinTableComposite.this.tableCombo.getText() == null || !JoinTableComposite.this.tableCombo.getText().equals(tableName)) {
                                            if (tableName == null) {
                                                JoinTableComposite.this.tableCombo.select(0);
                                            } else {
                                                JoinTableComposite.this.tableCombo.setText(tableName);
                                            }
                                        }
                                    }
                                });
                                break block31;
                            }
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.dali.orm.JoinTable");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (notification.getFeatureID((Class)clazz) != 0) break block32;
                            final String defaultTableName = (String)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    int selectionIndex = JoinTableComposite.this.tableCombo.getSelectionIndex();
                                    JoinTableComposite.this.tableCombo.setItem(0, NLS.bind((String)DaliUiMessages.JoinTableComposite_defaultWithOneParam, (Object)defaultTableName));
                                    if (selectionIndex == 0) {
                                        JoinTableComposite.this.tableCombo.select(0);
                                    }
                                }
                            });
                            break block31;
                        }
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.dali.orm.JoinTable");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (notification.getFeatureID((Class)clazz) != 7) break block33;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                JoinTableComposite.this.joinColumnsListViewer.refresh();
                                boolean isDefault = JoinTableComposite.this.joinTable.isDefaultJoinColumns();
                                JoinTableComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(!isDefault);
                                JoinTableComposite.this.updateJoinColumnsEnablement();
                            }
                        });
                        break block31;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.JoinTable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) != 8) break block34;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            JoinTableComposite.this.inverseJoinColumnsListViewer.refresh();
                            boolean isDefault = JoinTableComposite.this.joinTable.isDefaultInverseJoinColumns();
                            JoinTableComposite.this.overrideDefaultInverseJoinColumnsCheckBox.setSelection(!isDefault);
                            JoinTableComposite.this.updateInverseJoinColumnsEnablement();
                        }
                    });
                    break block31;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dali.orm.JoinTable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 5) break block35;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.JoinTable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) != 6) break block31;
            }
            if (notification.getEventType() == 3) {
                ((JoinColumn)notification.getNewValue()).eAdapters().add((Object)this.joinColumnItemProvider);
            } else if (notification.getEventType() == 4) {
                ((JoinColumn)notification.getOldValue()).eAdapters().remove((Object)this.joinColumnItemProvider);
            }
        }
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        int i = 0;
        while (i < group.getChildren().length) {
            group.getChildren()[i].setEnabled(enabled);
            ++i;
        }
    }

    private INotifyChangedListener getJoinColumnListener() {
        if (this.joinColumnListener == null) {
            this.joinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinTableComposite.this.joinColumnChanged(notification, JoinTableComposite.this.joinColumnsListViewer);
                }
            };
        }
        return this.joinColumnListener;
    }

    private INotifyChangedListener getInverseJoinColumnListener() {
        if (this.inverseJoinColumnListener == null) {
            this.inverseJoinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinTableComposite.this.joinColumnChanged(notification, JoinTableComposite.this.inverseJoinColumnsListViewer);
                }
            };
        }
        return this.inverseJoinColumnListener;
    }

    protected void joinColumnChanged(Notification notification, final ListViewer listViewer) {
        block28: {
            block27: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 4) break block27;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) == 7) break block27;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 1) break block27;
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz4) == 3) break block27;
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz5) == 6) break block27;
                Class<?> clazz6 = class$1;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$1 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz6) != 0) break block28;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    listViewer.refresh();
                }
            });
        }
    }

    public void populate(EObject model) {
        Iterator i;
        this.populating = true;
        if (this.joinTable != null) {
            this.joinTableItemProvider.removeListener(this.getTableListener());
            this.joinColumnItemProvider.removeListener(this.getJoinColumnListener());
            this.joinColumnItemProvider.removeListener(this.getInverseJoinColumnListener());
            this.joinTable.eAdapters().remove((Object)this.joinTableItemProvider);
            i = this.joinTable.getJoinColumns().iterator();
            while (i.hasNext()) {
                ((JoinColumn)i.next()).eAdapters().remove((Object)this.joinColumnItemProvider);
            }
        }
        if (this.joinTable == null) {
            this.joinColumnsListViewer.setInput(null);
            this.inverseJoinColumnsListViewer.setInput(null);
            return;
        }
        this.joinTable = (JoinTable)model;
        this.joinTableItemProvider.addListener(this.getTableListener());
        this.joinColumnItemProvider.addListener(this.getJoinColumnListener());
        this.joinColumnItemProvider.addListener(this.getInverseJoinColumnListener());
        this.joinTable.eAdapters().add((Object)this.joinTableItemProvider);
        i = this.joinTable.getJoinColumns().iterator();
        while (i.hasNext()) {
            ((JoinColumn)i.next()).eAdapters().add((Object)this.joinColumnItemProvider);
        }
        this.populateTableCombo();
        this.joinColumnsListViewer.setInput((Object)this.joinTable);
        this.inverseJoinColumnsListViewer.setInput((Object)this.joinTable);
        this.updateEnablement();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(!this.joinTable.isDefaultJoinColumns());
        this.overrideDefaultInverseJoinColumnsCheckBox.setSelection(!this.joinTable.isDefaultInverseJoinColumns());
        this.populating = false;
    }

    private void populateTableCombo() {
        Connection connection;
        String tableName = this.joinTable.getSpecifiedName();
        String defaultTableName = this.joinTable.getDefaultName();
        int selectionIndex = this.tableCombo.getSelectionIndex();
        this.tableCombo.setItem(0, NLS.bind((String)DaliUiMessages.JoinTableComposite_defaultWithOneParam, (Object)defaultTableName));
        if (selectionIndex == 0) {
            this.tableCombo.select(0);
        }
        if ((connection = this.getPersistenceProject().getConnection()).isConnected()) {
            this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
            Iterator stream = CollectionTools.sort((Iterator)connection.getDatabase().schemaNamed(this.getPersistenceProject().getSchemaName()).tableNames());
            while (stream.hasNext()) {
                this.tableCombo.add((String)stream.next());
            }
        } else {
            this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
        }
        if (tableName != null) {
            if (!this.tableCombo.getText().equals(tableName)) {
                this.tableCombo.setText(tableName);
            }
        } else if (!this.tableCombo.getText().equals(NLS.bind((String)DaliUiMessages.JoinTableComposite_defaultWithOneParam, (Object)defaultTableName))) {
            this.tableCombo.select(0);
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    JoinTableComposite.this.populateTableCombo();
                }
            }

            public void disconnected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    JoinTableComposite.this.populateTableCombo();
                }
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                JoinTableComposite.this.populateTableCombo();
            }

            public void tableChanged(Table table) {
                JoinTableComposite.this.populateTableCombo();
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    JoinTableComposite.this.populateTableCombo();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    JoinTableComposite.this.populateTableCombo();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
                connectionInfo.equals(connection);
            }

            public void dispose() {
            }
        };
    }

    private void updateEnablement() {
        this.updateJoinColumnsEnablement();
        this.updateInverseJoinColumnsEnablement();
    }

    private void updateJoinColumnsEnablement() {
        boolean groupEnabledState = !this.joinTable.isDefaultJoinColumns();
        this.enableGroup(this.joinColumnsGroup, groupEnabledState);
        this.joinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.joinColumnsListViewer.getSelection()).isEmpty());
        this.joinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.joinColumnsListViewer.getSelection()).size() == 1);
    }

    private void updateInverseJoinColumnsEnablement() {
        boolean groupEnabledState = !this.joinTable.isDefaultInverseJoinColumns();
        this.enableGroup(this.inverseJoinColumnsGroup, groupEnabledState);
        this.inverseJoinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.joinColumnsListViewer.getSelection()).isEmpty());
        this.inverseJoinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.joinColumnsListViewer.getSelection()).size() == 1);
    }

    public void dispose() {
        super.dispose();
        this.joinTable.eAdapters().remove((Object)this.joinTableItemProvider);
        Iterator i = this.joinTable.getJoinColumns().iterator();
        while (i.hasNext()) {
            ((JoinColumn)i.next()).eAdapters().remove((Object)this.joinColumnItemProvider);
        }
    }
}

