/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.DatabaseReconnectWizardPage;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizardPage;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class GenerateEntitiesWizard
extends Wizard {
    private Collection selectedTables;
    private IPackageFragment packageFragment;
    private IPackageFragmentRoot packageFragmentRoot;
    private IStructuredSelection fSelection;
    private PersistenceProject persistenceProject;
    private DatabaseReconnectWizardPage dbSettingsPage;
    private GenerateEntitiesWizardPage generateEntitiesPage;

    public GenerateEntitiesWizard(PersistenceProject persistenceProject, IStructuredSelection selection) {
        this.fSelection = selection;
        this.persistenceProject = persistenceProject;
        this.setWindowTitle(DaliUiMessages.GenerateEntitiesWizard_generateEntities);
    }

    public void addPages() {
        super.addPages();
        if (!this.persistenceProjectIsConnected()) {
            this.dbSettingsPage = new DatabaseReconnectWizardPage(this.persistenceProject);
            this.addPage((IWizardPage)this.dbSettingsPage);
        }
        this.generateEntitiesPage = new GenerateEntitiesWizardPage();
        this.addPage((IWizardPage)this.generateEntitiesPage);
        this.generateEntitiesPage.init(this.getSelection());
    }

    public boolean performFinish() {
        this.selectedTables = this.generateEntitiesPage.getSelectedTables();
        this.packageFragmentRoot = this.generateEntitiesPage.getPackageFragmentRoot();
        this.packageFragment = this.generateEntitiesPage.getPackageFragment();
        if (this.packageFragment == null) {
            this.packageFragment = this.packageFragmentRoot.getPackageFragment("");
        }
        if (!this.packageFragment.exists()) {
            String packName = this.packageFragment.getElementName();
            try {
                this.packageFragment = this.packageFragmentRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    Collection getPossibleTables() {
        if (this.dbSettingsPage != null) {
            return this.dbSettingsPage.getTables();
        }
        return CollectionTools.collection((Iterator)this.persistenceProject.getSchema().tables());
    }

    public Collection getSelectedTables() {
        return this.selectedTables;
    }

    public IPackageFragmentRoot getSourcePackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    public IPackageFragment getPackageFragment() {
        return this.packageFragment;
    }

    private IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public boolean canFinish() {
        boolean canFinish = true;
        if (!this.generateEntitiesPage.isPageComplete()) {
            canFinish = false;
        }
        return canFinish;
    }

    private boolean persistenceProjectIsConnected() {
        String connectionName = this.persistenceProject.getConnectionName();
        Connection connection = PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(connectionName);
        return connection.isConnected();
    }

    void updatePossibleTables(Collection possibleTables) {
        this.generateEntitiesPage.updateTablesListViewer(possibleTables);
    }
}

