/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.internal.synch;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.internal.DaliCoreMessages;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.packaging.PackagingFactory;
import org.eclipse.dali.packaging.PackagingResource;
import org.eclipse.dali.packaging.Persistence;
import org.eclipse.dali.packaging.PersistenceUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;

public class SynchronizeClassesJob
extends Job {
    private IFile persistenceXmlFile;

    public SynchronizeClassesJob(IFile file) {
        super(DaliCoreMessages.SYNCHRONIZING_CLASSES);
        this.persistenceXmlFile = file;
    }

    protected IStatus run(IProgressMonitor monitor) {
        PersistenceUnit punit;
        Persistence persistence;
        IProject project = this.persistenceXmlFile.getProject();
        monitor.beginTask(DaliCoreMessages.SYNCHRONIZING_CLASSES, 150);
        try {
            project.build(6, "org.eclipse.dali.core.persistenceBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        catch (CoreException ce) {
            return new Status(4, "org.eclipse.dali.core", 75, DaliCoreMessages.ERROR_BUILDING_PROJECT, (Throwable)ce);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        URI uri = URI.createPlatformResourceURI((String)this.persistenceXmlFile.getFullPath().toString());
        PackagingResource resource = (PackagingResource)this.getResourceSet().getResource(uri, true);
        if (resource.getContents().isEmpty()) {
            persistence = PackagingFactory.eINSTANCE.createPersistence();
            resource.getContents().add((Object)persistence);
        }
        if ((persistence = (Persistence)resource.getContents().get(0)).getPersistenceUnits().isEmpty()) {
            punit = PackagingFactory.eINSTANCE.createPersistenceUnit();
            punit.setName(project.getName());
            persistence.getPersistenceUnits().add((Object)punit);
        }
        punit = (PersistenceUnit)persistence.getPersistenceUnits().get(0);
        PersistenceProject pproject = DaliPlugin.persistenceProject(project);
        monitor.subTask(DaliCoreMessages.WRITING_CLASSES);
        punit.getClasses().clear();
        Iterator stream = this.mappedTypeNames(pproject);
        while (stream.hasNext()) {
            punit.getClasses().add((Object)((String)stream.next()));
        }
        monitor.worked(50);
        try {
            resource.save(null);
        }
        catch (IOException ioe) {
            return new Status(4, "org.eclipse.dali.core", 272, DaliCoreMessages.ERROR_SAVING_FILE, (Throwable)ioe);
        }
        return Status.OK_STATUS;
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }

    private Iterator mappedTypeNames(PersistenceProject pproject) {
        return CollectionTools.sort((Iterator)new TransformationIterator(pproject.mappedTypes()){

            protected Object transform(Object next) {
                return ((PersistentType)next).className();
            }
        });
    }
}

