/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.core.internal.project.facet;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wtp.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wtp.jsf.core.internal.Messages;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.wtp.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.wtp.jsf.core.internal.project.facet.JSFUtils;

public class JSFFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IJSFFacetInstallDataModelProperties {
    private String errorMessage;
    private IPath webContentPath;
    private IPath projectPath;

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
        names.add("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION");
        names.add("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        names.add("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION")) {
            if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() == null) {
                return null;
            }
            return JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation();
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
            return "/WEB-INF/faces-config.xml";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
            return "Faces Servlet";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS")) {
            return new String[]{"*.faces"};
        }
        if (propertyName.equals("IFacetDataModelPropeties.FACET_ID")) {
            return "wtp.jsf";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR")) {
            return "WebContent";
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        this.errorMessage = null;
        if (name.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION") && this.getBooleanProperty("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return this.validateImpl((JSFLibrary)this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION"));
        }
        if (name.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
            return this.validateConfigLocation(this.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
        }
        if (name.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
            return this.validateServletName(this.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME"));
        }
        return super.validate(name);
    }

    private IStatus validateServletName(String servletName) {
        if (servletName == null || servletName.trim().length() == 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateServletName;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateImpl(JSFLibrary impl) {
        if (impl == null) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateJSFImpl;
        }
        if (this.errorMessage != null) {
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateConfigLocation(String text) {
        if (text == null || text.trim().equals("")) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileEmpty;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        text = text.trim();
        if (this.getProjectPath() == null) {
            return OK_STATUS;
        }
        IPath fullPath = this.getProjectPath().append(text);
        Path passedPath = new Path(text);
        if (!fullPath.isValidPath(text)) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFilePath;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        if (text.toLowerCase().lastIndexOf(".xml") != text.length() - 4) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileXML;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        if (passedPath.getDevice() != null) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative1, (Object)this.getWebContentFolder().removeFirstSegments(this.getWebContentFolder().segmentCount() - 1).toString());
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        IPath setPath = this.getWebContentFolder().append((IPath)passedPath);
        if (!this.getWebContentFolder().isPrefixOf(setPath)) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative2, (Object)this.getWebContentFolder().removeFirstSegments(this.getWebContentFolder().segmentCount() - 1).toString());
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        return OK_STATUS;
    }

    private IPath getProjectPath() {
        if (this.projectPath == null) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME"));
            this.projectPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(proj.getFullPath());
        }
        return this.projectPath;
    }

    private IPath getWebContentFolder() {
        IPath iPath;
        block6: {
            WebArtifactEdit webApp;
            block4: {
                IPath iPath2;
                block5: {
                    if (this.webContentPath != null) {
                        return this.webContentPath;
                    }
                    webApp = null;
                    try {
                        String projName = this.model.getStringProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME");
                        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
                        webApp = JSFUtils.getWebArtifactEditForRead(proj);
                        if (webApp == null) break block4;
                        iPath2 = this.webContentPath = JSFUtils.getWebArtifactEditForRead(proj).getDeploymentDescriptorPath().removeLastSegments(2);
                        Object var4_6 = null;
                        if (webApp == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var4_8 = null;
                            if (webApp == null) break block7;
                            webApp.dispose();
                        }
                        throw throwable;
                    }
                    webApp.dispose();
                }
                return iPath2;
            }
            iPath = this.webContentPath = new Path(this.getStringProperty("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR"));
            Object var4_7 = null;
            if (webApp == null) break block6;
            webApp.dispose();
        }
        return iPath;
    }
}

