/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentmodel.annotation.internal;

import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationMap;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAttributeAnnotation;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMElementAnnotation;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.ICMAnnotationAdvisor;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.provisional.ICMAnnotationSourceFileInfo;

public final class CMAnnotationAdvisor
implements ICMAnnotationAdvisor {
    private CMAnnotationMap map;

    public CMAnnotationAdvisor(CMAnnotationMap map) {
        this.map = map;
        this.setCaseSensitive(true);
    }

    public void addElementAnnotation(String elementName, String propertyName, String propertyValue) {
        CMElementAnnotation elem = this.getElementAnnotation(this.getStringValueForCaseSensitivity(elementName));
        elem.setProperty(this.getStringValueForCaseSensitivity(propertyName), propertyValue);
    }

    public void addAttributeAnnotation(String elementName, String attributeName, String propertyName, String propertyValue) {
        CMElementAnnotation elem = this.getElementAnnotation(this.getStringValueForCaseSensitivity(elementName));
        CMAttributeAnnotation attr = this.getAttributeAnnotation(elem, this.getStringValueForCaseSensitivity(attributeName));
        attr.setProperty(this.getStringValueForCaseSensitivity(propertyName), propertyValue);
    }

    public ICMAnnotationSourceFileInfo getFileInfo() {
        return this.map.getFileInfo();
    }

    public void setCaseSensitive(boolean val) {
        this.map.setCaseSensitive(val);
    }

    private CMElementAnnotation getElementAnnotation(String elementName) {
        CMElementAnnotation elem = this.map.getElementAnnotation(elementName);
        if (elem == null) {
            elem = new CMElementAnnotation(elementName);
            this.map.addCMElementAnnotation(elem);
        }
        return elem;
    }

    private CMAttributeAnnotation getAttributeAnnotation(CMElementAnnotation elem, String attributeName) {
        CMAttributeAnnotation attr = (CMAttributeAnnotation)elem.getAttributeAnnotations().get(attributeName);
        if (attr == null) {
            attr = new CMAttributeAnnotation(elem.getName(), attributeName);
            elem.addCMAttributeAnnotation(attr);
        }
        return attr;
    }

    private String getStringValueForCaseSensitivity(String val) {
        return this.map.getStringValueForCaseSensitivity(val);
    }
}

